/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Config;
import classes.Employee;
import classes.Month;
import classes.User;
import classes.Year;
import com.google.gson.Gson;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class PayslipFilter
implements Initializable {
    private boolean caretaker;
    private User user;
    private Employee myEmployee;
    @FXML
    private ComboBox<Employee> employee;
    @FXML
    private ComboBox<Year> year;
    @FXML
    private Button generate;
    @FXML
    private Button sendViaEmail;
    @FXML
    private Button chooseEmployee;
    @FXML
    private ComboBox<Month> month;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;

    public boolean isCaretaker() {
        return this.caretaker;
    }

    public void setCaretaker(boolean caretaker) {
        this.caretaker = caretaker;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        ObservableList<Employee> allEmployees = new Employee().getAllEmployees(this.getUser());
        allEmployees.sort(Comparator.comparing(Employee::getFullName));
        this.employee.setItems(allEmployees);
        this.year.setItems(new Year().getAllYears(this.getUser()));
    }

    public Employee getMyEmployee() {
        return this.myEmployee;
    }

    public void setMyEmployee(Employee myEmployee) {
        this.myEmployee = myEmployee;
        this.employee.setValue((Object)myEmployee);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.month.setItems(new Month().getAllMonths());
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.employee, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.month, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.year, Validator.createEmptyValidator((String)"Required"));
        this.chooseEmployee.setOnAction(e -> {
            try {
                String tEmp = new Config().getObjectFromSelection(this.isCaretaker() ? "caretaker" : "employee", this.getUser());
                Employee selected = (Employee)new Gson().fromJson(tEmp, Employee.class);
                this.employee.setValue((Object)selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.generate.setOnAction(e -> {
            boolean error = false;
            String message = "";
            String employeeNo = "";
            int monthCode = 0;
            int yearCode = 0;
            try {
                employeeNo = ((Employee)this.employee.getValue()).getEmployeeNumber();
            }
            catch (Exception y) {
                error = true;
                message = message + "Please select the employee";
            }
            try {
                monthCode = ((Month)this.month.getValue()).getCode();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the month";
            }
            try {
                yearCode = ((Year)this.year.getValue()).getYear();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the year";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("employeeNo", employeeNo);
                params.put("month", monthCode);
                params.put("year", yearCode);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("employerName", Config.saccoName);
                reportVariables.put("payrollperiod", ((Month)this.month.getValue()).getMonthName() + " " + ((Year)this.year.getValue()).getYear());
                reportVariables.put("saccoName", Config.saccoName.toUpperCase());
                new Config().getReport("Payslip", "masterfetch?type=payslip", params, "payslip.jasper", reportVariables, this.getUser());
                Stage stage = (Stage)this.generate.getScene().getWindow();
                stage.close();
            }
        });
        this.sendViaEmail.setOnAction(e -> {
            boolean error = false;
            String message = "";
            String employeeNo = "";
            int monthCode = 0;
            int yearCode = 0;
            try {
                employeeNo = ((Employee)this.employee.getValue()).getEmployeeNumber();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                monthCode = ((Month)this.month.getValue()).getCode();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the month";
            }
            try {
                yearCode = ((Year)this.year.getValue()).getYear();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the year";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else if (employeeNo.length() > 1) {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("employeeNo", employeeNo);
                params.put("month", monthCode);
                params.put("year", yearCode);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("employerName", Config.saccoName);
                reportVariables.put("payrollperiod", ((Month)this.month.getValue()).getMonthName() + " " + ((Year)this.year.getValue()).getYear());
                new Config().saveReportAsPDF("Payslip", "masterfetch?type=payslip", params, "payslip.jasper", reportVariables, this.getUser(), employeeNo + ".pdf");
                String emailBody = "Dear " + ((Employee)this.employee.getValue()).getFullName() + ", <br\\> Please find attached your payslip for the period " + ((Month)this.month.getValue()).getMonthName() + " " + yearCode;
                Config.sendEmail(((Employee)this.employee.getValue()).getEmail(), "Payslip", emailBody, Config.getReportURL() + employeeNo + ".pdf", "Payslip.pdf");
                Stage stage = (Stage)this.generate.getScene().getWindow();
                stage.close();
            }
        });
    }
}

