/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.ChargeItem;
import classes.Config;
import classes.Customer;
import classes.ItemBrand;
import classes.ProfitNLoss;
import classes.Property;
import classes.Region;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.NotificationPane;

public class PNLFilter
implements Initializable {
    private Customer customer;
    private Vendor vendor;
    private Property property;
    private User user;
    private String reportName = "";
    private ProfitNLoss pnl;
    @FXML
    private DatePicker from;
    @FXML
    private DatePicker to;
    @FXML
    private Button generate;
    @FXML
    private HBox chargeItemHbox;
    @FXML
    private ComboBox<ChargeItem> chargeItem;
    @FXML
    private HBox salesRepHbox;
    @FXML
    private CheckComboBox<String> salesRep;
    @FXML
    private HBox documentTypeHBox;
    @FXML
    private CheckComboBox<String> documentType;
    @FXML
    private Button cancelDocumentType;
    @FXML
    private HBox customerHbox;
    @FXML
    private Label detailedLabel;
    @FXML
    private HBox fromHBox;
    @FXML
    private HBox toHBox;
    @FXML
    private Label toLabel;
    @FXML
    private ComboBox<Customer> selectCustomer;
    @FXML
    private HBox vendorHbox;
    @FXML
    private ComboBox<Vendor> selectVendor;
    @FXML
    private Button searchVendor;
    @FXML
    private Button searchCustomer;
    @FXML
    private Button cancelSalesRep;
    @FXML
    private HBox detailedHbox;
    @FXML
    private CheckBox detailedStatement;
    @FXML
    private HBox pdcHbox;
    @FXML
    private CheckBox includePdc;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private HBox regionHBox;
    @FXML
    private CheckComboBox<Region> region;
    @FXML
    private Button cancelRegion;
    @FXML
    private VBox holder;
    @FXML
    private HBox itemBrandHbox;
    @FXML
    private CheckComboBox<ItemBrand> itemBrands;
    @FXML
    private Button cancelItemBrand;

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
        if (this.selectCustomer.getItems().size() == 0) {
            ObservableList myCustomers = FXCollections.observableArrayList();
            myCustomers.add((Object)customer);
            this.selectCustomer.setItems(myCustomers);
            this.selectCustomer.setValue((Object)customer);
        }
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
        if (this.selectVendor.getItems().size() == 0) {
            ObservableList myVendors = FXCollections.observableArrayList();
            myVendors.add((Object)vendor);
            this.selectVendor.setItems(myVendors);
            this.selectVendor.setValue((Object)vendor);
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
        switch (reportName) {
            case "customerinvoices": {
                this.chargeItemHbox.setVisible(true);
                this.chargeItem.setItems(new ChargeItem().getChargeItems(1, this.getUser()));
                this.salesRepHbox.setVisible(true);
                this.loadSalesReps();
                break;
            }
            case "customer_statement_products": 
            case "dms_products": {
                this.chargeItemHbox.setVisible(false);
                this.salesRepHbox.setVisible(false);
                this.customerHbox.setVisible(true);
                this.loadCustomers();
                break;
            }
            case "distributor_sales_summary": {
                this.loadBrands();
                this.loadDocumentType();
                this.loadSalesReps();
                break;
            }
            case "customerstatement": {
                this.chargeItemHbox.setVisible(false);
                this.salesRepHbox.setVisible(false);
                this.customerHbox.setVisible(true);
                this.detailedHbox.setVisible(true);
                if (Config.hasPdc) {
                    this.pdcHbox.setVisible(true);
                }
                this.loadCustomers();
                break;
            }
            case "vendorstatement": {
                this.chargeItemHbox.setVisible(false);
                this.salesRepHbox.setVisible(false);
                this.customerHbox.setVisible(false);
                this.vendorHbox.setVisible(true);
                this.detailedHbox.setVisible(true);
                if (Config.hasPdc) {
                    this.pdcHbox.setVisible(true);
                }
                this.loadVendors();
                this.loadRegions();
                break;
            }
            case "allcustomers": {
                this.chargeItemHbox.setVisible(false);
                this.salesRepHbox.setVisible(true);
                this.customerHbox.setVisible(false);
                this.detailedHbox.setVisible(true);
                if (Config.hasPdc) {
                    this.pdcHbox.setVisible(true);
                }
                this.detailedLabel.setText("Show Aging:");
                this.detailedStatement.setSelected(true);
                this.fromHBox.setVisible(false);
                this.toHBox.setVisible(true);
                this.loadSalesReps();
                this.to.setValue((Object)Config.getCurrentLocaldate());
                this.to.setPromptText("Balance as at");
                this.toLabel.setText("Balance as At:");
                break;
            }
            case "allvendors": {
                this.chargeItemHbox.setVisible(false);
                this.salesRepHbox.setVisible(false);
                this.customerHbox.setVisible(false);
                this.detailedHbox.setVisible(true);
                if (Config.hasPdc) {
                    this.pdcHbox.setVisible(true);
                }
                this.detailedLabel.setText("Show Aging:");
                this.detailedStatement.setSelected(true);
                this.fromHBox.setVisible(false);
                this.toHBox.setVisible(true);
                this.to.setValue((Object)Config.getCurrentLocaldate());
                this.to.setPromptText("Balance as at");
                this.toLabel.setText("Balance as At:");
                this.loadRegions();
                break;
            }
            case "stock_report": 
            case "bank_discrepancy": 
            case "accounts_report": {
                this.chargeItemHbox.setVisible(false);
                this.salesRepHbox.setVisible(false);
                this.loadSalesReps();
                break;
            }
            case "sales_summary": 
            case "detailed_sales": 
            case "payments_summary": 
            case "detailed_payments": 
            case "commissions_report": {
                this.salesRepHbox.setVisible(true);
                this.documentTypeHBox.setVisible(true);
                this.loadSalesReps();
                this.loadDocumentType();
                break;
            }
            case "rep_sales_summary": {
                this.loadSalesReps();
                break;
            }
            case "purchase_summary": 
            case "dms_sales": {
                this.loadRegions();
                break;
            }
        }
    }

    private void loadCustomers() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Node original = PNLFilter.this.searchCustomer.getGraphic();
                Platform.runLater(() -> {
                    ProgressIndicator progressIndicator = new ProgressIndicator();
                    progressIndicator.setPrefWidth(20.0);
                    progressIndicator.setPrefHeight(20.0);
                    PNLFilter.this.searchCustomer.setGraphic((Node)progressIndicator);
                });
                ObservableList<Customer> allCustomers = new Customer().getAllCustomers(PNLFilter.this.getUser());
                Platform.runLater(() -> {
                    PNLFilter.this.selectCustomer.setItems(allCustomers);
                    try {
                        PNLFilter.this.selectCustomer.setValue((Object)PNLFilter.this.getCustomer());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PNLFilter.this.searchCustomer.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadVendors() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Node original = PNLFilter.this.searchVendor.getGraphic();
                Platform.runLater(() -> {
                    ProgressIndicator progressIndicator = new ProgressIndicator();
                    progressIndicator.setPrefWidth(20.0);
                    progressIndicator.setPrefHeight(20.0);
                    PNLFilter.this.searchVendor.setGraphic((Node)progressIndicator);
                });
                ObservableList<Vendor> allVendors = new Vendor().getAllVendors(PNLFilter.this.getUser());
                Platform.runLater(() -> {
                    PNLFilter.this.selectVendor.setItems(allVendors);
                    try {
                        PNLFilter.this.selectVendor.setValue((Object)PNLFilter.this.getVendor());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PNLFilter.this.searchVendor.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadBrands() {
        this.itemBrandHbox.setVisible(true);
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Node original = PNLFilter.this.cancelItemBrand.getGraphic();
                Platform.runLater(() -> {
                    ProgressIndicator progressIndicator = new ProgressIndicator();
                    progressIndicator.setPrefWidth(20.0);
                    progressIndicator.setPrefHeight(20.0);
                    PNLFilter.this.cancelItemBrand.setGraphic((Node)progressIndicator);
                });
                ObservableList allBrands = FXCollections.observableArrayList(new ItemBrand().getAllBrands(PNLFilter.this.getUser()));
                Platform.runLater(() -> {
                    PNLFilter.this.itemBrands.getItems().addAll((Collection)allBrands);
                    for (int a = 0; a < allBrands.size(); ++a) {
                        PNLFilter.this.itemBrands.getCheckModel().check(a);
                    }
                    PNLFilter.this.cancelItemBrand.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadSalesReps() {
        this.salesRepHbox.setVisible(true);
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Node original = PNLFilter.this.cancelSalesRep.getGraphic();
                Platform.runLater(() -> {
                    ProgressIndicator progressIndicator = new ProgressIndicator();
                    progressIndicator.setPrefWidth(20.0);
                    progressIndicator.setPrefHeight(20.0);
                    PNLFilter.this.cancelSalesRep.setGraphic((Node)progressIndicator);
                });
                String response = Config.loadDataFromPhp("masterfetch?type=sales_reps", new LinkedHashMap<String, Object>(), PNLFilter.this.getUser());
                String[] allReps = (String[])new Gson().fromJson(response, String[].class);
                Platform.runLater(() -> {
                    PNLFilter.this.salesRep.getItems().addAll((Collection)FXCollections.observableArrayList((Object[])allReps));
                    for (int a = 0; a < allReps.length; ++a) {
                        PNLFilter.this.salesRep.getCheckModel().check(a);
                    }
                    PNLFilter.this.cancelSalesRep.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadDocumentType() {
        this.documentTypeHBox.setVisible(true);
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Node original = PNLFilter.this.cancelDocumentType.getGraphic();
                Platform.runLater(() -> {
                    ProgressIndicator progressIndicator = new ProgressIndicator();
                    progressIndicator.setPrefWidth(20.0);
                    progressIndicator.setPrefHeight(20.0);
                    PNLFilter.this.cancelDocumentType.setGraphic((Node)progressIndicator);
                });
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("category", "Sales");
                String response = Config.loadDataFromPhp("masterfetch?type=document_types", params, PNLFilter.this.getUser());
                String[] allDocs = (String[])new Gson().fromJson(response, String[].class);
                Platform.runLater(() -> {
                    PNLFilter.this.documentType.getItems().addAll((Collection)FXCollections.observableArrayList((Object[])allDocs));
                    for (int a = 0; a < allDocs.length; ++a) {
                        PNLFilter.this.documentType.getCheckModel().check(a);
                    }
                    PNLFilter.this.cancelDocumentType.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadRegions() {
        if (Config.showRegionReports) {
            this.regionHBox.setVisible(true);
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Node original = PNLFilter.this.cancelRegion.getGraphic();
                    Platform.runLater(() -> {
                        ProgressIndicator progressIndicator = new ProgressIndicator();
                        progressIndicator.setPrefWidth(20.0);
                        progressIndicator.setPrefHeight(20.0);
                        PNLFilter.this.cancelRegion.setGraphic((Node)progressIndicator);
                    });
                    ObservableList<Region> allRegions = new Region().getAllRegions(PNLFilter.this.getUser());
                    Platform.runLater(() -> {
                        PNLFilter.this.region.getItems().addAll((Collection)FXCollections.observableArrayList((Collection)allRegions));
                        for (int a = 0; a < allRegions.size(); ++a) {
                            PNLFilter.this.region.getCheckModel().check(a);
                        }
                        PNLFilter.this.cancelRegion.setGraphic(original);
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
    }

    public ProfitNLoss getPnl() {
        return this.pnl;
    }

    public void setPnl(ProfitNLoss pnl) {
        this.pnl = pnl;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.chargeItemHbox.managedProperty().bind((ObservableValue)this.chargeItemHbox.visibleProperty());
        this.salesRepHbox.managedProperty().bind((ObservableValue)this.salesRepHbox.visibleProperty());
        this.customerHbox.managedProperty().bind((ObservableValue)this.customerHbox.visibleProperty());
        this.vendorHbox.managedProperty().bind((ObservableValue)this.vendorHbox.visibleProperty());
        this.detailedHbox.managedProperty().bind((ObservableValue)this.detailedHbox.visibleProperty());
        this.pdcHbox.managedProperty().bind((ObservableValue)this.pdcHbox.visibleProperty());
        this.fromHBox.managedProperty().bind((ObservableValue)this.fromHBox.visibleProperty());
        this.toHBox.managedProperty().bind((ObservableValue)this.toHBox.visibleProperty());
        this.documentTypeHBox.managedProperty().bind((ObservableValue)this.documentTypeHBox.visibleProperty());
        this.regionHBox.managedProperty().bind((ObservableValue)this.regionHBox.visibleProperty());
        this.itemBrandHbox.managedProperty().bind((ObservableValue)this.itemBrandHbox.visibleProperty());
        this.cancelSalesRep.setOnAction(e -> this.salesRep.getCheckModel().clearChecks());
        this.cancelItemBrand.setOnAction(e -> this.itemBrands.getCheckModel().clearChecks());
        this.cancelDocumentType.setOnAction(e -> this.documentType.getCheckModel().clearChecks());
        this.cancelRegion.setOnAction(e -> this.region.getCheckModel().clearChecks());
        this.searchVendor.setOnAction(e -> {
            Gson gson = new Gson();
            String response = new Config().getObjectFromSelection("vendor", gson.toJson((Object)this.selectVendor.getItems()), this.getUser());
            this.selectVendor.setValue(gson.fromJson(response, Vendor.class));
        });
        this.searchCustomer.setOnAction(e -> {
            Gson gson = new Gson();
            String response = new Config().getObjectFromSelection("customer", gson.toJson((Object)this.selectCustomer.getItems()), this.getUser());
            this.selectCustomer.setValue(gson.fromJson(response, Customer.class));
        });
        this.includePdc.setOnAction(e -> {
            if (this.includePdc.isSelected() && (this.getReportName().equalsIgnoreCase("allcustomers") || this.getReportName().equalsIgnoreCase("allvendors"))) {
                this.detailedStatement.setSelected(false);
            }
        });
        this.detailedStatement.setOnAction(e -> {
            if (this.detailedStatement.isSelected() && (this.getReportName().equalsIgnoreCase("allcustomers") || this.getReportName().equalsIgnoreCase("allvendors"))) {
                this.includePdc.setSelected(false);
            }
        });
        this.generate.setOnAction(e -> {
            ObservableList selectedRegions = FXCollections.observableArrayList();
            boolean close = true;
            try {
                Customer customer;
                LinkedHashMap<String, Object> reportVariables;
                LinkedHashMap<String, Object> reportParams;
                String dateFrom = "";
                String dateTo = "";
                String chargeCode = "";
                ArrayList repCode = new ArrayList();
                ArrayList documentTypeCode = new ArrayList();
                List<Object> selectedBrands = new ArrayList();
                try {
                    dateFrom = Config.localDateToString((LocalDate)this.from.getValue());
                }
                catch (Exception t) {
                    dateFrom = "";
                }
                try {
                    dateTo = Config.localDateToString((LocalDate)this.to.getValue());
                }
                catch (Exception t) {
                    dateTo = "";
                }
                try {
                    chargeCode = ((ChargeItem)this.chargeItem.getValue()).getCode() + "";
                }
                catch (Exception u) {
                    chargeCode = "";
                }
                try {
                    repCode = new ArrayList(this.salesRep.getCheckModel().getCheckedItems());
                }
                catch (Exception u) {
                    // empty catch block
                }
                try {
                    documentTypeCode = new ArrayList(this.documentType.getCheckModel().getCheckedItems());
                }
                catch (Exception u) {
                    // empty catch block
                }
                try {
                    selectedBrands = this.itemBrands.getCheckModel().getCheckedItems().stream().map(ItemBrand::getId).collect(Collectors.toList());
                }
                catch (Exception u) {
                    // empty catch block
                }
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("dateFrom", dateFrom);
                dataParams.put("dateTo", dateTo);
                dataParams.put("salesRep", new Gson().toJson(repCode));
                dataParams.put("documentTypes", new Gson().toJson(documentTypeCode));
                dataParams.put("selectedBrands", new Gson().toJson(selectedBrands));
                String tReportName = this.getReportName();
                if (tReportName.equalsIgnoreCase("customerinvoices")) {
                    dataParams.put("posted", 1);
                    dataParams.put("reversed", 0);
                    dataParams.put("document_type", "sales_invoice");
                    dataParams.put("chargeCode", chargeCode);
                    reportParams = new LinkedHashMap<String, Object>();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Sales Invoices for the Period " + dateFrom + " to " + dateTo);
                    new Config().getReport("Customer Invoices", "masterfetch?type=customerinvoice", dataParams, "allinvoices.jasper", reportParams, this.getUser());
                } else if (tReportName.equalsIgnoreCase("allcustomers")) {
                    dataParams.put("includePdc", this.includePdc.isSelected() ? 1 : 0);
                    dataParams.put("showAging", this.detailedStatement.isSelected() ? 1 : 0);
                    reportVariables = new LinkedHashMap<String, Object>();
                    reportVariables.put("saccoName", Config.saccoName);
                    if (this.detailedStatement.isSelected()) {
                        reportVariables.put("reportTitle", "RECEIVABLES AS AT: ");
                        new Config().getReport("All Customers", "masterfetch?type=customersaging", dataParams, "allcustomers.jasper", reportVariables, this.user);
                    } else {
                        reportVariables.put("reportTitle", "RECEIVABLES AS AT: " + dateTo);
                        new Config().getReport("All Customers", "masterfetch?type=customer_balances", dataParams, "customer_list.jasper", reportVariables, this.user);
                    }
                } else if (tReportName.equalsIgnoreCase("allvendors")) {
                    dataParams.put("includePdc", this.includePdc.isSelected() ? 1 : 0);
                    dataParams.put("showAging", this.detailedStatement.isSelected() ? 1 : 0);
                    reportVariables = new LinkedHashMap();
                    reportVariables.put("saccoName", Config.saccoName);
                    if (this.detailedStatement.isSelected()) {
                        String reportTitle = "PAYABLES AS AT: " + dateTo;
                        reportVariables.put("reportTitle", "PAYABLES AS AT: " + dateTo);
                        if (this.region.getCheckModel().getCheckedItems().size() != this.region.getItems().size()) {
                            ObservableList selected = this.region.getCheckModel().getCheckedItems();
                            reportTitle = "PAYABLES " + selected.toString() + " AS AT " + dateTo;
                            for (Region mySelection : selected) {
                                selectedRegions.add((Object)mySelection.getId());
                            }
                            dataParams.put("selectedRegions", new Gson().toJson((Object)selectedRegions));
                        }
                        reportVariables.put("reportTitle", reportTitle);
                        reportVariables.put("reportName", reportTitle);
                        new Config().getReport("All Payables", "masterfetch?type=payables_aging", dataParams, "allvendors.jasper", reportVariables, this.user);
                    } else {
                        String reportTitle = "PAYABLES AS AT: " + dateTo;
                        reportVariables.put("reportTitle", "PAYABLES AS AT: " + dateTo);
                        if (this.region.getCheckModel().getCheckedItems().size() != this.region.getItems().size()) {
                            ObservableList selected = this.region.getCheckModel().getCheckedItems();
                            reportTitle = "PAYABLES " + selected.toString() + " AS AT " + dateTo;
                            for (Region mySelection : selected) {
                                selectedRegions.add((Object)mySelection.getId());
                            }
                            dataParams.put("selectedRegions", new Gson().toJson((Object)selectedRegions));
                        }
                        reportVariables.put("reportTitle", reportTitle);
                        reportVariables.put("reportName", reportTitle);
                        new Config().getReport("All Payables", "masterfetch?type=vendor_balances", dataParams, "vendor_list.jasper", reportVariables, this.user);
                    }
                } else if (tReportName.equalsIgnoreCase("customer_statement_products")) {
                    try {
                        customer = (Customer)this.selectCustomer.getValue();
                        LinkedHashMap<String, Object> reportVariables2 = new LinkedHashMap<String, Object>();
                        reportVariables2.put("customerNo", customer.getCustomerNumber());
                        reportVariables2.put("customerName", customer.getCustomerName());
                        reportVariables2.put("customerPhone", customer.getCustomerPhone());
                        reportVariables2.put("customerEmail", customer.getCustomerEmail());
                        reportVariables2.put("saccoName", Config.saccoName);
                        reportVariables2.put("address", Config.getShopAddress());
                        reportVariables2.put("reportName", "CUSTOMER PRODUCT STATEMENT FOR THE PERIOD " + dateFrom + " - " + dateTo);
                        dataParams.put("customerNo", customer.getCustomerNumber());
                        new Config().getReport("Customer Statement", "masterfetch?type=customer_product_statement", dataParams, "customer_products.jasper", reportVariables2, this.getUser());
                    }
                    catch (NullPointerException ignored) {
                        close = false;
                        this.notificationPane.setText("Please select a customer");
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.show();
                    }
                } else if (tReportName.equalsIgnoreCase("dms_products")) {
                    try {
                        customer = (Customer)this.selectCustomer.getValue();
                        LinkedHashMap<String, Object> reportVariables3 = new LinkedHashMap<String, Object>();
                        reportVariables3.put("customerNo", customer.getCustomerNumber());
                        reportVariables3.put("customerName", customer.getCustomerName());
                        reportVariables3.put("customerPhone", customer.getCustomerPhone());
                        reportVariables3.put("customerEmail", customer.getCustomerEmail());
                        reportVariables3.put("saccoName", Config.saccoName);
                        reportVariables3.put("address", Config.getShopAddress());
                        reportVariables3.put("reportName", "DMS PRODUCT STATEMENT FOR THE PERIOD " + dateFrom + " - " + dateTo);
                        dataParams.put("customerNo", customer.getCustomerNumber());
                        new Config().getReport("DMS Product Statement", "masterfetch?type=dms_products", dataParams, "dms_products.jasper", reportVariables3, this.getUser());
                    }
                    catch (NullPointerException ignored) {
                        close = false;
                        this.notificationPane.setText("Please select a customer");
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.show();
                    }
                } else if (tReportName.equalsIgnoreCase("customerstatement")) {
                    customer = (Customer)this.selectCustomer.getValue();
                    LinkedHashMap<String, Object> reportVariables4 = new LinkedHashMap<String, Object>();
                    reportVariables4.put("customerNo", customer.getCustomerNumber());
                    reportVariables4.put("customerName", customer.getCustomerName());
                    reportVariables4.put("customerPhone", customer.getCustomerPhone());
                    reportVariables4.put("customerEmail", customer.getCustomerEmail());
                    reportVariables4.put("saccoName", Config.saccoName);
                    reportVariables4.put("address", Config.getShopAddress());
                    dataParams.put("customerNo", customer.getCustomerNumber());
                    dataParams.put("detailed", this.detailedStatement.isSelected() ? 1 : 0);
                    dataParams.put("includePdc", this.includePdc.isSelected() ? 1 : 0);
                    new Config().getReport("Customer Statement", "masterfetch?type=customerentries", dataParams, "customerstatement.jasper", reportVariables4, this.user);
                } else if (tReportName.equalsIgnoreCase("vendorstatement")) {
                    String reportTitle = "SUPPLIER STATEMENT";
                    Vendor vendor = (Vendor)this.selectVendor.getValue();
                    LinkedHashMap<String, Object> reportVariables5 = new LinkedHashMap<String, Object>();
                    reportVariables5.put("vendorName", vendor.getFullName());
                    reportVariables5.put("vendorPhone", vendor.getVendorPhone());
                    reportVariables5.put("vendorEmail", vendor.getVendorEmail());
                    reportVariables5.put("saccoName", Config.saccoName);
                    reportVariables5.put("vendorNo", vendor.getVendorNumber());
                    dataParams.put("vendorNo", vendor.getVendorNumber());
                    dataParams.put("detailed", this.detailedStatement.isSelected() ? 1 : 0);
                    dataParams.put("includePdc", this.includePdc.isSelected() ? 1 : 0);
                    if (this.region.getCheckModel().getCheckedItems().size() != this.region.getItems().size()) {
                        ObservableList selected = this.region.getCheckModel().getCheckedItems();
                        reportTitle = reportTitle + " " + selected.toString() + " AS AT " + dateTo;
                        for (Region mySelection : selected) {
                            selectedRegions.add((Object)mySelection.getId());
                        }
                        dataParams.put("selectedRegions", new Gson().toJson((Object)selectedRegions));
                    }
                    reportVariables5.put("reportTitle", reportTitle);
                    new Config().getReport("Vendor Statement", "masterfetch?type=vendorentries", dataParams, "vendorstatement.jasper", reportVariables5, this.user);
                } else if (tReportName.equalsIgnoreCase("stock_report")) {
                    reportVariables = new LinkedHashMap();
                    reportVariables.put("saccoName", Config.saccoName);
                    reportVariables.put("address", Config.getShopAddress());
                    reportVariables.put("reportName", "STOCK REPORT " + dateFrom + " - " + dateTo);
                    new Config().getReport("STOCK REPORT", "masterfetch?type=stock_report", dataParams, "stock_report.jasper", reportVariables, this.getUser());
                } else if (tReportName.equalsIgnoreCase("accounts_report")) {
                    reportVariables = new LinkedHashMap();
                    reportVariables.put("saccoName", Config.saccoName);
                    reportVariables.put("address", Config.getShopAddress());
                    reportVariables.put("reportName", "ACCOUNTS REPORT " + dateFrom + " - " + dateTo);
                    new Config().getReport("ACCOUNTS REPORT", "masterfetch?type=accounts_report", dataParams, "accounts_report.jasper", reportVariables, this.getUser());
                } else if (tReportName.equalsIgnoreCase("bank_discrepancy")) {
                    reportVariables = new LinkedHashMap();
                    reportVariables.put("saccoName", Config.saccoName);
                    reportVariables.put("address", Config.getShopAddress());
                    reportVariables.put("reportName", "BANK DISCREPANCY FOR THE PERIOD " + dateFrom + " - " + dateTo);
                    new Config().getReport("BANK DISCREPANCY REPORT", "masterfetch?type=bank_discrepancy", dataParams, "bank_discrepancies.jasper", reportVariables, this.getUser());
                } else if (tReportName.equalsIgnoreCase("sales_person_report")) {
                    reportVariables = new LinkedHashMap();
                    reportVariables.put("saccoName", Config.saccoName);
                    reportVariables.put("address", Config.getShopAddress());
                    reportVariables.put("reportName", "SALES PERSON REPORT FOR THE PERIOD " + dateFrom + " to " + dateTo);
                    new Config().getReport("Sales Person Report", "masterfetch?type=sales_person_report", dataParams, "sales_person_report.jasper", reportVariables, this.getUser());
                } else if (tReportName.equalsIgnoreCase("purchase_summary")) {
                    reportVariables = new LinkedHashMap();
                    reportVariables.put("saccoName", Config.saccoName);
                    reportVariables.put("address", Config.getShopAddress());
                    String reportTitle = "PURCHASE SUMMARY REPORT FOR THE PERIOD " + dateFrom + " to " + dateTo;
                    if (this.region.getCheckModel().getCheckedItems().size() != this.region.getItems().size()) {
                        ObservableList selected = this.region.getCheckModel().getCheckedItems();
                        reportTitle = "PURCHASE SUMMARY REPORT " + selected.toString() + " FOR THE PERIOD " + dateFrom + " to " + dateTo;
                        for (Region mySelection : selected) {
                            selectedRegions.add((Object)mySelection.getId());
                        }
                    }
                    reportVariables.put("reportName", reportTitle);
                    dataParams.put("selectedRegions", new Gson().toJson((Object)selectedRegions));
                    new Config().getReport("Purchase Summary Report", "masterfetch?type=purchase_summary", dataParams, "purchase_summary.jasper", reportVariables, this.getUser());
                } else if (tReportName.equalsIgnoreCase("dms_sales")) {
                    reportVariables = new LinkedHashMap();
                    reportVariables.put("saccoName", Config.saccoName);
                    reportVariables.put("address", Config.getShopAddress());
                    String reportTitle = "DMS SALES REPORT FOR THE PERIOD " + dateFrom + " to " + dateTo;
                    if (this.region.getCheckModel().getCheckedItems().size() != this.region.getItems().size()) {
                        ObservableList selected = this.region.getCheckModel().getCheckedItems();
                        reportTitle = "DMS SALES REPORT " + selected.toString() + " FOR THE PERIOD " + dateFrom + " to " + dateTo;
                        for (Region mySelection : selected) {
                            selectedRegions.add((Object)mySelection.getId());
                        }
                    }
                    reportVariables.put("reportName", reportTitle);
                    dataParams.put("selectedRegions", new Gson().toJson((Object)selectedRegions));
                    new Config().getReport("DMS Sales Report", "masterfetch?type=dms_sales", dataParams, "dms_sales.jasper", reportVariables, this.getUser());
                } else if (tReportName.equalsIgnoreCase("vendorinvoices")) {
                    dataParams.put("posted", 1);
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Purchase Invoices for the Period " + dateFrom + " to " + dateTo);
                    new Config().getReport("Purchase Invoices", "masterfetch?type=vendorinvoices", dataParams, "allinvoices.jasper", reportParams, this.getUser());
                } else if (tReportName.equalsIgnoreCase("customerbalances")) {
                    dataParams.put("posted", 1);
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Receivables Summary for the Period " + dateFrom + " to " + dateTo);
                    new Config().getReport("Customer Summary", "masterfetch?type=customerbalances", dataParams, "customerbalances.jasper", reportParams, this.getUser());
                } else if (tReportName.equalsIgnoreCase("vendorbalances")) {
                    dataParams.put("posted", 1);
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Payables Summary for the Period " + dateFrom + " to " + dateTo);
                    new Config().getReport("Payables Summary", "masterfetch?type=vendorbalances", dataParams, "vendorbalances.jasper", reportParams, this.getUser());
                } else if (tReportName.equalsIgnoreCase("propertylandlordstatement")) {
                    dataParams.put("propertyCode", this.getProperty().getPropertyCode());
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Landlord Statement " + dateFrom + " to " + dateTo);
                    new Config().getReport("Landlord Statement", "masterfetch?type=landlordstatement", dataParams, "landlordstatement.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("sales_summary")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Sales Summary " + dateFrom + " to " + dateTo);
                    new Config().getReport("Sales Summary", "masterfetch?type=salessummary", dataParams, "salessummary.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("detailed_sales")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Detailed Sales " + dateFrom + " to " + dateTo);
                    new Config().getReport("Detailed Sales", "masterfetch?type=detailedsales", dataParams, "detailed_sales.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("detailed_payments")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Detailed Payments " + dateFrom + " to " + dateTo);
                    new Config().getReport("Detailed Payments", "masterfetch?type=detailedpayments", dataParams, "detailed_payments.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("payments_summary")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Payments Summary " + dateFrom + " to " + dateTo);
                    new Config().getReport("Payments Summary", "masterfetch?type=paymentssummary", dataParams, "paymentssummary.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("commissions_report")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Commissions Report " + dateFrom + " to " + dateTo);
                    new Config().getReport("Commissions Report", "masterfetch?type=commissions_report", dataParams, "commissions_report.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("stockanalysis")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Stock Analysis " + dateFrom + " to " + dateTo);
                    new Config().getReport("Stock Analysis", "masterfetch?type=stockanalysis", dataParams, "stockanalysis.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("all_customers_profitability")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("address", Config.companyAddress);
                    reportParams.put("reportName", "All Customers Profitability " + dateFrom + " to " + dateTo);
                    new Config().getReport("All Customers Profitability", "masterfetch?type=all_customers_profitability", dataParams, "all_customers_profitability.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("rep_sales_summary")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("address", Config.companyAddress);
                    reportParams.put("reportName", "Sales Reps Sales Summary " + dateFrom + " to " + dateTo);
                    new Config().getReport("Sales Reps Sales Summary", "masterfetch?type=rep_sales_summary", dataParams, "rep_sales_summary.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("salesreport")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "All Customers Profitability " + dateFrom + " to " + dateTo);
                    new Config().getReport("Sales Report", "masterfetch?type=salesreport", dataParams, "salesreport.jasper", reportParams, this.user);
                } else if (tReportName.equalsIgnoreCase("distributor_sales_summary")) {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "Distributor Sales Summary " + dateFrom + " to " + dateTo);
                    new Config().saveReportAsExcel("Distributor Sales Summary", "masterfetch?type=distributor_sales_summary", dataParams, "distributor_sales_summary.jasper", reportParams, this.user);
                } else {
                    reportParams = new LinkedHashMap();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("profitNLossName", Config.shortName);
                    LocalDate myStart = ((LocalDate)this.from.getValue()).with(TemporalAdjusters.firstDayOfMonth());
                    reportParams.put("month1Name", myStart.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toUpperCase() + " " + myStart.getYear());
                    myStart = myStart.plusMonths(1L);
                    dataParams.put("month2Start", Config.localDateToString(myStart.with(TemporalAdjusters.firstDayOfMonth())));
                    reportParams.put("month2Name", myStart.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toUpperCase() + " " + myStart.getYear());
                    myStart = myStart.plusMonths(1L);
                    dataParams.put("month3Start", Config.localDateToString(myStart.with(TemporalAdjusters.firstDayOfMonth())));
                    reportParams.put("month3Name", myStart.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toUpperCase() + " " + myStart.getYear());
                    reportParams.put("reportName", "INCOME STATEMENT FOR THE PERIOD " + dateFrom + " to " + dateTo);
                    new Config().getReport("Profit n Loss Statement", "masterfetch?type=profitnlossstatement", dataParams, "profitandloss_monthly.jasper", reportParams, this.getUser());
                }
                if (close) {
                    Stage stage = (Stage)this.generate.getScene().getWindow();
                    stage.close();
                }
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        });
    }
}

