/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.BalanceSheet;
import classes.Config;
import classes.User;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.stage.Stage;

public class BSFilter
implements Initializable {
    private String reportName;
    private User user;
    private BalanceSheet balanceSheet;
    @FXML
    private DatePicker date;
    @FXML
    private Button generate;

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public BalanceSheet getBalanceSheet() {
        return this.balanceSheet;
    }

    public void setBalanceSheet(BalanceSheet balanceSheet) {
        this.balanceSheet = balanceSheet;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.generate.setOnAction(e -> {
            try {
                String dateFrom = "";
                try {
                    dateFrom = Config.localDateToString((LocalDate)this.date.getValue());
                }
                catch (Exception t) {
                    dateFrom = "";
                }
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("bsName", "");
                reportParams.put("endDate", dateFrom);
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("date", dateFrom);
                if (this.getReportName().equalsIgnoreCase("balance_sheet_minimized")) {
                    new Config().getReport("Balance Sheet", "masterfetch?type=balancesheet", params, "balancesheetminimized.jasper", reportParams, this.getUser());
                } else {
                    new Config().getReport("Balance Sheet", "masterfetch?type=balancesheet", params, "balancesheetstatement.jasper", reportParams, this.getUser());
                }
                Stage stage = (Stage)this.generate.getScene().getWindow();
                stage.close();
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        });
    }
}

