/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Config;
import classes.User;
import classes.VehicleBrands;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.stage.Stage;
import org.controlsfx.control.CheckComboBox;

public class AllVehiclesReportFilter
implements Initializable {
    private User user;
    @FXML
    private CheckComboBox<VehicleBrands> vehicleBrands;
    @FXML
    private Button viewreport;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.vehicleBrands.getItems().addAll(new VehicleBrands().getAllBrands(this.getUser()));
    }

    public void initialize(URL location, ResourceBundle resources) {
        int count = this.vehicleBrands.getItems().size();
        int a = 0;
        while (a < count) {
            this.vehicleBrands.getCheckModel().checkIndices(new int[]{a++});
        }
        this.viewreport.setOnAction(e -> {
            try {
                String myBrands = "";
                String filterName = "";
                ObservableList selectedBrands = this.vehicleBrands.getCheckModel().getCheckedItems();
                for (VehicleBrands brand : selectedBrands) {
                    myBrands = myBrands + (myBrands.length() > 0 ? "," : "");
                    myBrands = myBrands + brand.getBrandId() + "";
                    filterName = filterName + (filterName.length() > 0 ? ", " : "Under ");
                    filterName = filterName + brand.getBrandName() + "";
                }
                if (selectedBrands.size() == this.vehicleBrands.getItems().size()) {
                    filterName = "";
                }
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("brand", myBrands);
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("filterName", filterName);
                new Config().getReport("All Vehicles", "masterfetch?type=vehicles", dataParams, "allvehicles.jasper", reportParams, this.getUser());
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your report. Please contact support");
                alert.showAndWait();
            }
            Stage stage = (Stage)this.viewreport.getScene().getWindow();
            stage.close();
        });
    }
}

