/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Config;
import classes.Member;
import classes.TransferAccounts;
import classes.User;
import classes.Year;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.stage.Stage;

public class AllMembersMonthlyFilter
implements Initializable {
    private User user;
    private Member mMember;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private ComboBox<TransferAccounts> transactionType;
    @FXML
    private ComboBox<Year> year;
    @FXML
    private Button generate;
    @FXML
    private Button chooseMember;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Member getmMember() {
        return this.mMember;
    }

    public void setmMember(Member mMember) {
        this.mMember = mMember;
        this.member.setValue((Object)mMember);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.chooseMember.setOnAction(e -> {
            try {
                Member me = new Member().getMemberFromSelection(this.getUser());
                if (me.getMemberNumber().length() > 0) {
                    this.member.setValue((Object)me);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.member.setItems(new Member().getAllMembers(this.getUser()));
        this.year.setItems(new Year().getAllYears(this.getUser()));
        try {
            Year currentYear = new Year();
            currentYear.setYear(LocalDate.now().getYear());
            this.year.setValue((Object)currentYear);
        }
        catch (Exception currentYear) {
            // empty catch block
        }
        this.transactionType.setItems(new TransferAccounts().getTransferAccount(this.getUser()));
        try {
            TransferAccounts account = (TransferAccounts)this.transactionType.getItems().get(0);
            this.transactionType.setValue((Object)account);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.generate.setOnAction(e -> {
            LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
            String memberNumber = "";
            try {
                memberNumber = ((Member)this.member.getValue()).getMemberNumber();
                if (memberNumber.length() > 0) {
                    dataParams.put("memberNo", memberNumber);
                }
            }
            catch (Exception u) {
                memberNumber = "";
            }
            try {
                int myYear = ((Year)this.year.getValue()).getYear();
                dataParams.put("year", myYear);
            }
            catch (Exception myYear) {
                // empty catch block
            }
            try {
                String transactionTypeCode = ((TransferAccounts)this.transactionType.getValue()).getTransferCode();
                dataParams.put("transactionType", transactionTypeCode);
            }
            catch (Exception transactionTypeCode) {
                // empty catch block
            }
            LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
            reportParams.put("saccoName", Config.saccoName);
            new Config().getReport(memberNumber.length() > 0 ? "All Members Monthly Report" : "Member Monthly Statement", "masterfetch?type=membermonthlyreport", dataParams, "membermonthly.jasper", reportParams, this.getUser());
            Stage stage = (Stage)this.generate.getScene().getWindow();
            stage.close();
        });
    }
}

