/*
 * Decompiled with CFR 0.152.
 */
package edms;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import edms.File;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;

public class FilesController
implements Initializable {
    private String documentType;
    private String documentId;
    private User user;
    @FXML
    private NotificationPane filesNotificationPane;
    @FXML
    private VBox filesHolder;
    @FXML
    private TableView<File> allFilesTable;
    @FXML
    private TableColumn<File, String> colFile;
    @FXML
    private Button uploadFile;

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
        this.loadFiles();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.filesNotificationPane = new Config().setUpNotificationPane(this.filesNotificationPane, (Node)this.filesHolder);
        this.uploadFile.setOnAction(e -> this.uploadFile());
        this.colFile.setCellValueFactory((Callback)new PropertyValueFactory("download"));
        this.allFilesTable.setPlaceholder((Node)new Label("No File Uploaded Yet"));
    }

    public void uploadFile() {
        System.out.println("Trying to upload file");
        System.out.println("Document Type" + this.getDocumentType());
        System.out.println("Document Id" + this.getDocumentId());
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Select Item Picture");
        final java.io.File file = chooser.showOpenDialog((Window)new Stage());
        if (file != null) {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> {
                        FilesController.this.filesNotificationPane.setText("Uploading");
                        FilesController.this.filesNotificationPane.setGraphic((Node)new ProgressIndicator());
                        FilesController.this.filesNotificationPane.show();
                    });
                    try {
                        System.out.println("Am here 1 " + System.currentTimeMillis() / 1000L);
                        ByteArrayOutputStream ba = Config.convertFileToJson(file.getPath());
                        System.out.println("Am here 2 " + System.currentTimeMillis() / 1000L);
                        String fileJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                        System.out.println("Am here 3 " + System.currentTimeMillis() / 1000L);
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("documentType", FilesController.this.getDocumentType());
                        params.put("documentId", FilesController.this.getDocumentId());
                        params.put("documentJson", fileJson);
                        params.put("fileName", file.getName());
                        System.out.println("Am here 4 " + System.currentTimeMillis() / 1000L);
                        String response = Config.loadDataFromPhp("mastercreate?type=file", params, FilesController.this.getUser());
                        System.out.println("Am here 5 " + System.currentTimeMillis() / 1000L);
                        System.out.println(response);
                        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                        if (jr.isStatus()) {
                            FilesController.this.loadFiles();
                        }
                        Platform.runLater(() -> {
                            FilesController.this.filesNotificationPane.setText(jr.getMessage());
                            FilesController.this.filesNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                            FilesController.this.filesNotificationPane.show();
                        });
                    }
                    catch (Exception y) {
                        Platform.runLater(() -> {
                            FilesController.this.filesNotificationPane.setText("Error");
                            FilesController.this.filesNotificationPane.setGraphic((Node)Config.getBanIcon());
                            FilesController.this.filesNotificationPane.show();
                        });
                    }
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
    }

    public void loadFiles() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("documentType", this.getDocumentType());
        params.put("documentId", this.getDocumentId());
        String response = Config.loadDataFromPhp("masterfetch?type=files", params, this.getUser());
        System.out.println(response);
        ObservableList allFiles = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, File[].class)));
        this.allFilesTable.setItems(allFiles);
    }
}

