/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Employee;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.animation.PauseTransition;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;

public class editAssetController
implements Initializable {
    private User user;
    @FXML
    private AnchorPane root;
    @FXML
    private VBox holdervbox;
    @FXML
    private AnchorPane holder;
    @FXML
    private TextField assetSerialNumber;
    @FXML
    private DatePicker dateAcquired;
    @FXML
    private JFXComboBox<Employee> assignedTo;
    @FXML
    private TextArea assetDescription;
    @FXML
    private ImageView assetImage;
    @FXML
    private JFXButton addAsset;
    @FXML
    private JFXButton reset;
    @FXML
    private TextField location;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private JFXButton deleteMember;
    @FXML
    private JFXButton assetStatement;
    private FixedAssets fixedAssets;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public FixedAssets getFixedAssets() {
        return this.fixedAssets;
    }

    public void setAsset(FixedAssets ifixedAssets) {
        this.fixedAssets = ifixedAssets;
        this.assetSerialNumber.setText(ifixedAssets.getAssetSerial());
        String date = ifixedAssets.getDateAcquired();
        LocalDate localDate = LocalDate.parse(date);
        this.dateAcquired.setValue((Object)localDate);
        Employee asst = ifixedAssets.getAssignedTo();
        this.assignedTo.setItems(new Employee().getAllEmployees(this.getUser()));
        for (Employee emp : this.assignedTo.getItems()) {
            try {
                if (!emp.getEmployeeNumber().equalsIgnoreCase(asst.getEmployeeNumber())) continue;
                this.assignedTo.getSelectionModel().select((Object)emp);
            }
            catch (Exception exception) {}
        }
        this.location.setText(ifixedAssets.getLocation());
        this.assetDescription.setText(ifixedAssets.getDescription());
    }

    public void initialize(URL location2, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.reset.setOnAction(e -> {
            try {
                Stage stage = (Stage)this.reset.getScene().getWindow();
                stage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.addAsset.setOnAction(e -> {
            try {
                String path = System.getProperty("user.dir");
                path = path.replace("\\", "/");
                String fileLocation = path + "/loading.gif";
                File file = new File(fileLocation);
                Image image2 = new Image(file.toURI().toString());
                ImageView loader = new ImageView(image2);
                loader.setFitHeight(30.0);
                loader.setFitWidth(30.0);
                this.notificationPane.setGraphic((Node)loader);
                this.notificationPane.getStyleClass().add((Object)"dark");
                this.notificationPane.setText("Updating Asset details. Please wait...");
                this.notificationPane.show();
                String assetSerial = this.assetSerialNumber.getText();
                String Description = this.assetDescription.getText();
                LocalDate assetdateAcquired = (LocalDate)this.dateAcquired.getValue();
                String assetlocation = this.location.getText();
                String assetAssignedTo = ((Employee)this.assignedTo.getValue()).getEmployeeNumber();
                String n = this.getFixedAssets().getAssetNo();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("Description", Description);
                params.put("assetSerial", assetSerial);
                params.put("dateAcquired", assetdateAcquired);
                params.put("location", assetlocation);
                params.put("assignedTo", assetAssignedTo);
                params.put("assetNo", this.getFixedAssets().getAssetNo());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterupdate?type=fixedasset", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                    this.notificationPane.show();
                    this.removenotif();
                } else {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                    this.removenotif();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        reset.setOnAction(e -> {
            String path = System.getProperty("user.dir");
            path = path.replace("\\", "/");
            String fileLocation = path + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.assetImage.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)editAssetController.this.assetImage, event.getScreenX(), event.getScreenY());
            }
        });
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            try {
                Image image2 = new Image(file.toURI().toString());
                ImageView loader = new ImageView(image2);
                loader.setFitHeight(30.0);
                loader.setFitWidth(30.0);
                this.notificationPane.setGraphic((Node)loader);
                this.notificationPane.getStyleClass().add((Object)"dark");
                this.notificationPane.setText("Updating asset photo. Please wait...");
                this.notificationPane.show();
                ByteArrayOutputStream ba = Config.convertFileToJson(file.getPath());
                String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("assetNo", this.getFixedAssets().getAssetNo());
                params.put("photo", photoJson);
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterupdate?type=assetphoto", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.notificationPane.setText(myResponse.getMessage());
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.CHECK);
                    icon.setStyle("-fx-fill: #4CAF50;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                } else {
                    this.notificationPane.setText(myResponse.getMessage());
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                    icon.setStyle("-fx-fill: #d32f2f;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                }
                this.addAsset.setDisable(false);
                this.assetImage.setImage(image);
            }
            catch (Exception t) {
                t.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                icon.setStyle("-fx-fill: #d32f2f;");
                icon.setSize("24.0");
                this.notificationPane.setGraphic((Node)icon);
                this.addAsset.setDisable(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removenotif() {
        PauseTransition pauseTransition = new PauseTransition(Duration.seconds((double)2.0));
        pauseTransition.setOnFinished(e -> this.notificationPane.hide());
        pauseTransition.play();
    }
}

