/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.AssetDisposal;
import classes.Config;
import classes.Customer;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class assetDisposalController
implements Initializable {
    private User user;
    private AssetDisposal assetDisposal;
    @FXML
    private VBox root;
    @FXML
    private VBox holdervbox;
    @FXML
    private AnchorPane holder;
    @FXML
    private ImageView assetImage;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton reset;
    @FXML
    private ComboBox<FixedAssets> asset;
    @FXML
    private ComboBox<Customer> customer;
    @FXML
    private DatePicker disposalDate;
    @FXML
    private TextField sellingPrice;
    @FXML
    private Label disposalNo;
    @FXML
    private JFXButton post;
    @FXML
    private Label bookValue;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.asset.setItems(new FixedAssets().getAllAssets(this.getUser()));
        this.customer.setItems(new Customer().getAllCustomers(this.getUser()));
    }

    public AssetDisposal getAssetDisposal() {
        return this.assetDisposal;
    }

    public void setAssetDisposal(AssetDisposal assetDisposal) {
        this.assetDisposal = assetDisposal;
        try {
            this.disposalNo.setText(assetDisposal.getDisposalNo());
            this.asset.setValue((Object)assetDisposal.getAsset());
            this.customer.setValue((Object)assetDisposal.getCustomer());
            this.disposalDate.setValue((Object)Config.stringToLocalDate(assetDisposal.getDisposalDate()));
            this.sellingPrice.setText(Config.doubleToString(assetDisposal.getSellingPrice()));
            if (assetDisposal.isPosted()) {
                this.disableFields();
                this.sellingPrice.setText(Config.formatNumber(assetDisposal.getSellingPrice()));
            }
            this.showImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holdervbox);
        this.sellingPrice = new Config().setDoubleTextField(this.sellingPrice);
        this.disposalDate.setValue((Object)Config.getCurrentLocaldate());
        this.asset.setOnAction(e -> this.showImage());
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.asset, Validator.createEmptyValidator((String)"Please select the asset"));
        vs.registerValidator(this.customer, Validator.createEmptyValidator((String)"Please select the customer"));
        vs.registerValidator((Control)this.disposalDate, Validator.createEmptyValidator((String)"Please select the disposal date"));
        vs.registerValidator((Control)this.sellingPrice, Validator.createEmptyValidator((String)"Selling Price is required"));
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
        this.save.setOnAction(r -> this.save());
        this.post.setOnAction(e -> {
            if (this.save()) {
                try {
                    String tDisposalNo = this.disposalNo.getText().trim();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("disposalNo", tDisposalNo);
                    String response = Config.loadDataFromPhp("masterpost?type=assetdisposal", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        Stage stage = (Stage)this.post.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }

    public boolean save() {
        String tDisposalNo = "";
        String tAssetNo = "";
        String tCustomerNo = "";
        String tDisposalDate = "";
        double mSellingPrice = 0.0;
        boolean error = false;
        String message = "";
        boolean newDisposal = false;
        NumberSeries ns = new NumberSeries(29, this.getUser());
        try {
            tDisposalNo = this.disposalNo.getText().trim();
            if (tDisposalNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            newDisposal = true;
            tDisposalNo = ns.getNextNumber();
        }
        try {
            tAssetNo = ((FixedAssets)this.asset.getValue()).getAssetNo();
        }
        catch (Exception t) {
            error = true;
            message = "Please select the asset";
        }
        try {
            tCustomerNo = ((Customer)this.customer.getValue()).getCustomerNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the customer buying the asset";
        }
        try {
            tDisposalDate = Config.localDateToString((LocalDate)this.disposalDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the disposal date of the asset";
        }
        try {
            mSellingPrice = Double.parseDouble(this.sellingPrice.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid selling price";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("disposalNo", tDisposalNo);
                params.put("assetNo", tAssetNo);
                params.put("customerNo", tCustomerNo);
                params.put("disposalDate", tDisposalDate);
                params.put("sellingPrice", mSellingPrice);
                String response = Config.loadDataFromPhp("mastercreate?type=assetdisposal", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus() && newDisposal) {
                    this.disposalNo.setText(tDisposalNo);
                    ns.updateLastUsed(tDisposalNo);
                }
                return jr.isStatus();
            }
            catch (Exception y) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public void showImage() {
        try {
            FixedAssets myAsset = (FixedAssets)this.asset.getValue();
            this.bookValue.setText(myAsset.getBookValueString());
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(myAsset.getAssetPhoto(this.getUser()));
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            Image image = new Image((InputStream)bis);
            this.assetImage.setImage(image);
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disableFields() {
        this.save.setDisable(true);
        this.post.setDisable(true);
        this.asset.setDisable(true);
        this.customer.setDisable(true);
        this.disposalDate.setDisable(true);
        this.sellingPrice.setDisable(true);
        this.disposalNo.setDisable(true);
    }
}

