/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.AssetAcquisition;
import classes.Config;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class assetAcquisitionController
implements Initializable {
    private User user;
    private AssetAcquisition acquisition;
    @FXML
    private VBox root;
    @FXML
    private VBox holdervbox;
    @FXML
    private TextField narration;
    @FXML
    private ImageView assetImage;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton post;
    @FXML
    private JFXButton reset;
    @FXML
    private ComboBox<FixedAssets> asset;
    @FXML
    private ComboBox<Vendor> vendor;
    @FXML
    private DatePicker purchaseDate;
    @FXML
    private TextField buyingPrice;
    @FXML
    private Label acquisitionNo;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Platform.runLater(() -> {
            this.asset.setItems(new FixedAssets().getAllAssets(this.getUser()));
            this.vendor.setItems(new Vendor().getAllVendors(this.getUser()));
        });
    }

    public AssetAcquisition getAcquisition() {
        return this.acquisition;
    }

    public void setAcquisition(AssetAcquisition acquisition) {
        this.acquisition = acquisition;
        try {
            this.acquisitionNo.setText(acquisition.getAcquisitionNo());
            this.asset.setValue((Object)acquisition.getAsset());
            this.vendor.setValue((Object)acquisition.getVendor());
            this.purchaseDate.setValue((Object)Config.stringToLocalDate(acquisition.getPurchaseDate()));
            this.buyingPrice.setText(Config.doubleToString(acquisition.getBuyingPrice()));
            try {
                this.narration.setText(acquisition.getNarration());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (acquisition.isPosted()) {
                this.disableFields();
                this.buyingPrice.setText(Config.formatNumber(acquisition.getBuyingPrice()));
            }
            this.showImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holdervbox);
        this.buyingPrice = new Config().setDoubleTextField(this.buyingPrice);
        this.purchaseDate.setValue((Object)Config.getCurrentLocaldate());
        this.asset.setOnAction(e -> this.showImage());
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.asset, Validator.createEmptyValidator((String)"Please select the asset"));
        vs.registerValidator(this.vendor, Validator.createEmptyValidator((String)"Please select the vendor"));
        vs.registerValidator((Control)this.purchaseDate, Validator.createEmptyValidator((String)"Please select the purchase date"));
        vs.registerValidator((Control)this.buyingPrice, Validator.createEmptyValidator((String)"Buying Price is required"));
        vs.registerValidator((Control)this.narration, Validator.createEmptyValidator((String)"Required"));
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
        this.save.setOnAction(r -> this.save());
        this.post.setOnAction(e -> {
            if (this.save()) {
                try {
                    String tAcquisitionNo = this.acquisitionNo.getText().trim();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("acquisitionNo", tAcquisitionNo);
                    String response = Config.loadDataFromPhp("masterpost?type=assetacquisition", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        Stage stage = (Stage)this.post.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }

    public boolean save() {
        String tAcquisitionNo = "";
        String tAssetNo = "";
        String tVendorNo = "";
        String tPurchaseDate = "";
        String tNarration = "";
        double mBuyingPrice = 0.0;
        boolean error = false;
        String message = "";
        boolean newAcquisition = false;
        NumberSeries ns = new NumberSeries(28, this.getUser());
        try {
            tAcquisitionNo = this.acquisitionNo.getText().trim();
            if (tAcquisitionNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            newAcquisition = true;
            tAcquisitionNo = ns.getNextNumber();
        }
        try {
            tAssetNo = ((FixedAssets)this.asset.getValue()).getAssetNo();
        }
        catch (Exception t) {
            error = true;
            message = "Please select the asset";
        }
        try {
            tVendorNo = ((Vendor)this.vendor.getValue()).getVendorNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the vendor selling the asset";
        }
        try {
            tPurchaseDate = Config.localDateToString((LocalDate)this.purchaseDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the purchase date of the asset";
        }
        try {
            mBuyingPrice = Double.parseDouble(this.buyingPrice.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid buying price";
        }
        try {
            tNarration = this.narration.getText().trim();
            if (tNarration.length() < 4) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid narration. Atleast 4 Characters";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("acquisitionNo", tAcquisitionNo);
                params.put("assetNo", tAssetNo);
                params.put("vendorNo", tVendorNo);
                params.put("purchaseDate", tPurchaseDate);
                params.put("buyingPrice", mBuyingPrice);
                params.put("narration", tNarration);
                String response = Config.loadDataFromPhp("mastercreate?type=assetacquisition", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus() && newAcquisition) {
                    this.acquisitionNo.setText(tAcquisitionNo);
                    ns.updateLastUsed(tAcquisitionNo);
                }
                return jr.isStatus();
            }
            catch (Exception y) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public void showImage() {
        try {
            FixedAssets myAsset = (FixedAssets)this.asset.getValue();
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(myAsset.getAssetPhoto(this.getUser()));
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            Image image = new Image((InputStream)bis);
            this.assetImage.setImage(image);
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disableFields() {
        this.save.setDisable(true);
        this.post.setDisable(true);
        this.asset.setDisable(true);
        this.vendor.setDisable(true);
        this.purchaseDate.setDisable(true);
        this.buyingPrice.setDisable(true);
        this.acquisitionNo.setDisable(true);
    }
}

