/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.AppreciationDepreciation;
import classes.Config;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class appreciationController
implements Initializable {
    private User user;
    private AppreciationDepreciation appreciationDepreciation;
    @FXML
    private VBox root;
    @FXML
    private VBox holdervbox;
    @FXML
    private AnchorPane holder;
    @FXML
    private Label voucherNo;
    @FXML
    private DatePicker computationDate;
    @FXML
    private ComboBox<String> computationType;
    @FXML
    private ComboBox<FixedAssets> asset;
    @FXML
    private Label currentBookValue;
    @FXML
    private TextField description;
    @FXML
    private ComboBox<String> computationMethod;
    @FXML
    private TextField rateAmount;
    @FXML
    private Label newBookValue;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton post;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private ImageView assetImage;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.asset.setItems(new FixedAssets().getAllAssets(this.getUser()));
    }

    public AppreciationDepreciation getAppreciationDepreciation() {
        return this.appreciationDepreciation;
    }

    public void setAppreciationDepreciation(AppreciationDepreciation appreciationDepreciation) {
        this.appreciationDepreciation = appreciationDepreciation;
        try {
            this.voucherNo.setText(appreciationDepreciation.getVoucherNo());
            this.computationDate.setValue((Object)Config.stringToLocalDate(appreciationDepreciation.getComputationDate()));
            this.computationType.setValue((Object)appreciationDepreciation.getComputationType());
            this.asset.setValue((Object)appreciationDepreciation.getAsset());
            this.description.setText(appreciationDepreciation.getDescription());
            this.computationMethod.setValue((Object)appreciationDepreciation.getComputationMethod());
            this.rateAmount.setText(Config.doubleToString(appreciationDepreciation.getRateAmount()));
            this.showImage();
            if (appreciationDepreciation.isPosted()) {
                this.disableFields();
                this.rateAmount.setText(appreciationDepreciation.getRateAmountString());
                this.currentBookValue.setText(Config.formatNumber(appreciationDepreciation.getBookValue()));
                this.newBookValue.setText(Config.formatNumber(appreciationDepreciation.getNewBookValue()));
            } else {
                this.calculateNewValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holdervbox);
        this.computationDate.setValue((Object)Config.getCurrentLocaldate());
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.computationDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.computationType, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.asset, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.description, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.computationMethod, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.rateAmount, Validator.createEmptyValidator((String)"Required"));
        ObservableList types = FXCollections.observableArrayList();
        types.add((Object)"Appreciation");
        types.add((Object)"Depreciation");
        this.computationType.setItems(types);
        ObservableList methods = FXCollections.observableArrayList();
        methods.add((Object)"Percentage");
        methods.add((Object)"Fixed amount");
        this.computationMethod.setItems(methods);
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.rateAmount = new Config().setDoubleTextField(this.rateAmount);
        this.asset.setOnAction(e -> {
            this.showImage();
            this.calculateNewValue();
        });
        this.computationType.setOnAction(e -> this.calculateNewValue());
        this.computationMethod.setOnAction(e -> this.calculateNewValue());
        this.rateAmount.textProperty().addListener((observable, oldValue, newValue) -> this.calculateNewValue());
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> this.post());
    }

    public void disableFields() {
        this.voucherNo.setDisable(true);
        this.computationDate.setDisable(true);
        this.computationType.setDisable(true);
        this.asset.setDisable(true);
        this.currentBookValue.setDisable(true);
        this.description.setDisable(true);
        this.computationMethod.setDisable(true);
        this.rateAmount.setDisable(true);
        this.newBookValue.setDisable(true);
        this.save.setDisable(true);
        this.post.setDisable(true);
    }

    public void showImage() {
        try {
            FixedAssets myAsset = (FixedAssets)this.asset.getValue();
            this.currentBookValue.setText(myAsset.getBookValueString());
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(myAsset.getAssetPhoto(this.getUser()));
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            Image image = new Image((InputStream)bis);
            this.assetImage.setImage(image);
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void calculateNewValue() {
        try {
            this.newBookValue.setText("0");
            FixedAssets myAsset = (FixedAssets)this.asset.getValue();
            double cBookValue = myAsset.getBookValue();
            double cRateAmount = 0.0;
            double change = 0.0;
            String cType = "";
            String cMethod = "";
            try {
                cRateAmount = Double.parseDouble(this.rateAmount.getText().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                cType = ((String)this.computationType.getValue()).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                cMethod = ((String)this.computationMethod.getValue()).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cMethod.equalsIgnoreCase("Percentage")) {
                if (cRateAmount > 100.0) {
                    this.notificationPane.setText("The percentage rate cannot be greater than 100");
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                    return;
                }
                this.notificationPane.hide();
                change = cBookValue * cRateAmount / 100.0;
            } else if (cMethod.equalsIgnoreCase("Fixed amount")) {
                this.notificationPane.hide();
                change = cRateAmount;
            }
            if (cType.equalsIgnoreCase("Depreciation")) {
                change *= -1.0;
            }
            double newValue = cBookValue + change;
            this.newBookValue.setText(Config.formatNumber(newValue));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Boolean save() {
        String tVoucherNo = "";
        boolean newVoucher = false;
        String tComputationDate = "";
        String tComputationType = "";
        String tAssetNo = "";
        String tDescription = "";
        String tComputationMethod = "";
        double mRateAmount = 0.0;
        String message = "";
        boolean error = false;
        NumberSeries ns = new NumberSeries(30, this.getUser());
        try {
            tVoucherNo = this.voucherNo.getText().trim();
            if (tVoucherNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            newVoucher = true;
            tVoucherNo = ns.getNextNumber();
        }
        try {
            tComputationDate = Config.localDateToString((LocalDate)this.computationDate.getValue());
        }
        catch (Exception y) {
            error = true;
            message = "Please select the computation date";
        }
        try {
            tComputationType = ((String)this.computationType.getValue()).trim();
            if (tComputationType.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the computation type";
        }
        try {
            tAssetNo = ((FixedAssets)this.asset.getValue()).getAssetNo();
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the asset";
        }
        try {
            tDescription = this.description.getText().trim();
            if (tDescription.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            LocalDate localDate = LocalDate.now();
            message = message + "Please enter the description. (E.g Appreciation for the year " + localDate.getYear() + ")";
        }
        try {
            tComputationMethod = ((String)this.computationMethod.getValue()).trim();
            if (tComputationMethod.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the computation method";
        }
        try {
            mRateAmount = Double.parseDouble(this.rateAmount.getText().trim());
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid rate/amount";
        }
        if (!error) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("voucherNo", tVoucherNo);
            params.put("computationDate", tComputationDate);
            params.put("computationType", tComputationType);
            params.put("assetNo", tAssetNo);
            params.put("description", tDescription);
            params.put("computationMethod", tComputationMethod);
            params.put("rateAmount", mRateAmount);
            String response = Config.loadDataFromPhp("mastercreate?type=appreciationdepreciation", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus() && newVoucher) {
                ns.updateLastUsed(tVoucherNo);
                this.voucherNo.setText(tVoucherNo);
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        this.notificationPane.setText(message);
        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
        this.notificationPane.show();
        return false;
    }

    public void post() {
        if (this.save().booleanValue()) {
            try {
                String tVoucherNo = this.voucherNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", tVoucherNo);
                String response = Config.loadDataFromPhp("masterpost?type=appreciationdepreciation", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.post.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

