/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.CashWithdrawal;
import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.NumberSeries;
import classes.StandardFees;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class WithdrawCashController
implements Initializable {
    private User user;
    private CashWithdrawal voucher;
    @FXML
    private TextField withdrawalFee;
    @FXML
    private ComboBox<String> withdrwalPurpose;
    @FXML
    private TextField withdrawalDescription;
    @FXML
    private TextField chequeNo;
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane holder;
    @FXML
    private Label withdrawalNo;
    @FXML
    private DatePicker withdrawalDatePicker;
    @FXML
    private ComboBox<Bank> bankName;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private Label availableFunds;
    @FXML
    private Label withdrawableFunds;
    @FXML
    private TextField amount;
    @FXML
    private Label newBalance;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton post;
    @FXML
    private JFXButton reverse;
    @FXML
    private JFXButton cancel;
    @FXML
    private Button chooseMember;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public CashWithdrawal getVoucher() {
        return this.voucher;
    }

    public void setVoucher(CashWithdrawal voucher) {
        this.voucher = voucher;
        try {
            this.bankName.setValue((Object)voucher.getBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.member.setValue((Object)voucher.getMember());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.amount.setText(voucher.getAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.withdrawalNo.setText(voucher.getVoucherNo() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.withdrawalFee.setText(voucher.getWithdrawalFee() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.withdrwalPurpose.setValue((Object)voucher.getWithdrwalPurpose());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.withdrawalDescription.setText(voucher.getWithdrawalDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.chequeNo.setText(voucher.getChequeNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-d");
            String date = voucher.getWithdrawalDate();
            try {
                LocalDate localDate = LocalDate.parse(date, formatter);
                this.withdrawalDatePicker.setValue((Object)localDate);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.calculateNewBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (voucher.isPosted()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
            this.amount.setDisable(true);
            this.withdrawalDatePicker.setDisable(true);
            this.bankName.setDisable(true);
            this.member.setDisable(true);
            this.chooseMember.setDisable(true);
            this.withdrawalFee.setDisable(true);
            this.withdrwalPurpose.setDisable(true);
            this.withdrawalDescription.setDisable(true);
            this.chequeNo.setDisable(true);
            this.reverse.setDisable(false);
        }
        if (voucher.isReversed()) {
            this.reverse.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.withdrawalDatePicker, Validator.createEmptyValidator((String)"Withdrawal date is required"));
        vs.registerValidator(this.bankName, Validator.createEmptyValidator((String)"Bank is required"));
        vs.registerValidator(this.member, Validator.createEmptyValidator((String)"Member is required"));
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Amount is required"));
        vs.registerValidator(this.withdrwalPurpose, Validator.createEmptyValidator((String)"Purpose is required"));
        vs.registerValidator((Control)this.chequeNo, Validator.createEmptyValidator((String)"Cheque No. is required"));
        ObservableList allPurposes = FXCollections.observableArrayList();
        String response = Config.loadDataFromPhp("masterfetch?type=savingspurposes", new LinkedHashMap<String, Object>(), this.getUser());
        allPurposes = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, String[].class)));
        this.withdrwalPurpose.setItems(allPurposes);
        try {
            ObservableList<StandardFees> fees = new StandardFees().getAllStandardFees(this.getUser());
            for (StandardFees fee : fees) {
                if (fee.getCode() != 4) continue;
                this.withdrawalFee.setText(fee.getAmount() + "");
            }
        }
        catch (Exception er) {
            this.withdrawalFee.setText("0");
        }
        this.withdrawalDatePicker.setValue((Object)Config.getCurrentLocaldate());
        this.bankName.requestFocus();
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.bankName.setItems(Bank.getAllBanks(this.getUser()));
        this.member.setItems(new Member().getAllMembers(this.getUser()));
        this.chooseMember.setOnAction(e -> {
            Member m = new Member().getMemberFromSelection(this.getUser());
            try {
                if (!m.getMemberNumber().equals(null) && !m.getMemberNumber().equals("")) {
                    this.member.setValue((Object)m);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.calculateNewBalance();
        });
        this.member.setOnAction(e -> {
            try {
                this.calculateNewBalance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.amount = new Config().setDoubleTextField(this.amount);
        this.withdrawalFee = new Config().setDoubleTextField(this.withdrawalFee);
        this.amount.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                this.calculateNewBalance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.withdrawalFee.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                this.calculateNewBalance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.post()) {
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.reverse.setOnAction(e -> {
            if (this.reverse()) {
                Stage stage = (Stage)this.reverse.getScene().getWindow();
                stage.close();
            }
        });
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
    }

    public void calculateNewBalance() {
        double fee = 0.0;
        try {
            try {
                fee = Double.parseDouble(this.withdrawalFee.getText().trim());
            }
            catch (Exception y) {
                fee = 0.0;
            }
            double tAmount = 0.0;
            try {
                tAmount = Double.parseDouble(this.amount.getText().trim());
            }
            catch (Exception y) {
                tAmount = 0.0;
            }
            double tSavings = 0.0;
            String memberNo = "";
            try {
                memberNo = ((Member)this.member.getValue()).getMemberNumber();
            }
            catch (Exception t) {
                memberNo = "";
            }
            if (!memberNo.equals(null) && !memberNo.equals("")) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("memberNo", memberNo);
                    params.put("transactionType", "401");
                    String response = Config.loadDataFromPhp("masterfetch?type=memberaccountbalance", params, this.getUser());
                    Double[] myValues = (Double[])new Gson().fromJson(response, Double[].class);
                    tSavings = myValues[0];
                    this.availableFunds.setText(Config.formatNumber(tSavings));
                }
                catch (NullPointerException params) {
                }
                catch (Exception t) {
                    this.notificationPane.setText("We could not be able to compute the member balance");
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                }
            }
            double tBalance = tSavings - (tAmount + fee);
            this.newBalance.setText(Config.formatNumber(tBalance));
            this.availableFunds.setText(Config.formatNumber(tSavings));
            this.withdrawableFunds.setText(Config.formatNumber(tSavings - fee));
        }
        catch (Exception t) {
            t.printStackTrace();
            double tSavings = ((Member)this.member.getValue()).getSavings();
            double tBalance = tSavings - fee;
            this.newBalance.setText(Config.formatNumber(tBalance));
        }
    }

    public boolean save() {
        String mWithdrawalDate = "";
        int bankCode = 0;
        String memberNumber = "";
        double tAmount = 0.0;
        double tWithdrawalFee = 0.0;
        String tWithdrawalPurpose = "";
        String tWithdrawalDescription = "";
        String tChequeNo = "";
        boolean error = false;
        String message = "";
        try {
            LocalDate tWithdrawalDate = (LocalDate)this.withdrawalDatePicker.getValue();
            mWithdrawalDate = tWithdrawalDate.toString();
        }
        catch (Exception t) {
            error = true;
            message = "Please select the withdrawal date";
        }
        try {
            bankCode = ((Bank)this.bankName.getValue()).getCode();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the bank ";
        }
        try {
            memberNumber = ((Member)this.member.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the member";
        }
        try {
            tAmount = Double.parseDouble(this.amount.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid value for amount";
        }
        try {
            tWithdrawalFee = Double.parseDouble(this.withdrawalFee.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid value for withdrawal fee";
        }
        try {
            tWithdrawalPurpose = ((String)this.withdrwalPurpose.getValue()).trim();
            if (tWithdrawalPurpose.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a purpose for withdrawing the funds";
        }
        try {
            tWithdrawalDescription = this.withdrawalDescription.getText().trim();
        }
        catch (Exception u) {
            tWithdrawalDescription = "";
        }
        try {
            tChequeNo = this.chequeNo.getText().trim();
            if (tChequeNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception u) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter the cheque no";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            boolean newVoucher = false;
            String tVoucherNo = "";
            NumberSeries ns = new NumberSeries(14, this.getUser());
            try {
                tVoucherNo = this.withdrawalNo.getText().trim();
                if (tVoucherNo.equals("") || tVoucherNo.equals(null)) {
                    throw new Exception();
                }
            }
            catch (Exception t) {
                tVoucherNo = ns.getNextNumber();
                newVoucher = true;
            }
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", tVoucherNo);
                params.put("withdrawalDate", mWithdrawalDate);
                params.put("bankCode", bankCode);
                params.put("memberNo", memberNumber);
                params.put("amount", tAmount);
                params.put("withdrawalFee", tWithdrawalFee);
                params.put("withdrawalPurpose", tWithdrawalPurpose);
                params.put("withdrawalDescription", tWithdrawalDescription);
                params.put("chequeNo", tChequeNo);
                String response = Config.loadDataFromPhp("mastercreate?type=savingswithdrawalvoucher", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus() && newVoucher) {
                    this.withdrawalNo.setText(tVoucherNo);
                    ns.updateLastUsed(tVoucherNo);
                }
                return jr.isStatus();
            }
            catch (Exception r) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public boolean post() {
        if (this.save()) {
            String tVoucherNo = this.withdrawalNo.getText().trim();
            try {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Confirm Post");
                alert.setHeaderText("Posting the withdrawal voucher results in a change in the financial position. ");
                alert.setContentText("Are you sure you want to post withdrawal voucher number " + tVoucherNo + "?");
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    try {
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("voucherNo", tVoucherNo);
                        String response = Config.loadDataFromPhp("masterpost?type=savingswithdrawalvoucher", params, this.getUser());
                        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                        if (jr.isStatus()) {
                            Stage stage = (Stage)this.post.getScene().getWindow();
                            stage.close();
                        }
                        return jr.isStatus();
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while processing your request.");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
            catch (Exception r) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public boolean reverse() {
        String tVoucherNo = this.withdrawalNo.getText().trim();
        try {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Confirm Post");
            alert.setHeaderText("Reversing withdrawal voucher results in a change in the financial position. ");
            alert.setContentText("Are you sure you want to reverse withdrawal voucher number " + tVoucherNo + "?");
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("voucherNo", tVoucherNo);
                    String response = Config.loadDataFromPhp("masterpost?type=reversesavingswithdrawalvoucher", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        Stage stage = (Stage)this.post.getScene().getWindow();
                        stage.close();
                    }
                    return jr.isStatus();
                }
                catch (Exception r) {
                    this.notificationPane.setText("We encountered an error while processing your request.");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        }
        catch (Exception r) {
            this.notificationPane.setText("We encountered an error while processing your request.");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        return false;
    }
}

