/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Floor;
import classes.Property;
import classes.Units;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class WaterReadingController
implements Initializable {
    private User user;
    @FXML
    private DatePicker date;
    @FXML
    private ComboBox<Property> property;
    @FXML
    private ComboBox<Floor> floor;
    @FXML
    private ComboBox<Units> unit;
    @FXML
    private TextField lastReading;
    @FXML
    private TextField currentReading;
    @FXML
    private TextField consumption;
    @FXML
    private TextField costPerUnit;
    @FXML
    private TextField totalAmount;
    @FXML
    private Button post;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.property.setItems(new Property().getAllProperties(user));
    }

    public void initialize(URL location, ResourceBundle resources) {
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.currentReading, Validator.createEmptyValidator((String)"Required"));
        this.date.setValue((Object)Config.getCurrentLocaldate());
        this.property.setOnAction(e -> {
            String propertyCode = ((Property)this.property.getValue()).getPropertyCode();
            this.unit.setItems(new Units().getAllUnits(propertyCode, this.getUser()));
            this.floor.setItems(new Floor().getAllFloors(propertyCode, this.getUser()));
            this.costPerUnit.setText(((Property)this.property.getValue()).getWaterRate() + "");
        });
        this.unit.setOnAction(e -> {
            try {
                String tUnitCode = ((Units)this.unit.getValue()).getUnitCode();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("unitCode", tUnitCode);
                String response = Config.loadDataFromPhp("masterfetch?type=lastmeterreading", params, this.getUser());
                Double[] mReadings = (Double[])new Gson().fromJson(response, Double[].class);
                this.lastReading.setText(mReadings[0] + "");
            }
            catch (Exception p) {
                this.lastReading.setText("0");
            }
        });
        this.consumption.setDisable(true);
        this.totalAmount.setDisable(true);
        this.lastReading.textProperty().addListener((observable, oldValue, newValue) -> this.calculateWaterUsage());
        this.currentReading.textProperty().addListener((observable, oldValue, newValue) -> this.calculateWaterUsage());
        this.costPerUnit.textProperty().addListener((observable, oldValue, newValue) -> this.calculateWaterUsage());
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.save.setOnAction(e -> this.saveReading());
        this.post.setOnAction(e -> {
            if (this.saveReading() && this.postReading()) {
                Stage stage = (Stage)this.cancel.getScene().getWindow();
                stage.close();
            }
        });
    }

    public void calculateWaterUsage() {
        double tLastReading = 0.0;
        double tCurrentReading = 0.0;
        double tConsumption = 0.0;
        double tCostPerUnit = 0.0;
        try {
            tLastReading = Double.parseDouble(this.lastReading.getText().trim());
        }
        catch (Exception i) {
            tLastReading = 0.0;
        }
        try {
            tCurrentReading = Double.parseDouble(this.currentReading.getText().trim());
        }
        catch (Exception i) {
            tCurrentReading = 0.0;
        }
        try {
            tCostPerUnit = Double.parseDouble(this.costPerUnit.getText().trim());
        }
        catch (Exception i) {
            tCostPerUnit = 0.0;
        }
        tConsumption = tCurrentReading - tLastReading;
        this.consumption.setText(Config.formatNumber(tConsumption));
        this.totalAmount.setText(Config.formatNumber(tConsumption * tCostPerUnit));
    }

    public boolean saveReading() {
        return false;
    }

    public boolean postReading() {
        return false;
    }
}

