/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import classes.UserRoles;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class UserRolesController
implements Initializable {
    private UserRoles userRole;
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label roleId;
    @FXML
    private TextField roleName;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public UserRoles getUserRole() {
        return this.userRole;
    }

    public void setUserRole(UserRoles userRole) {
        this.userRole = userRole;
        this.roleId.setText(userRole.getId() + "");
        this.roleName.setText(userRole.getName());
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @FXML
    void onEnter(ActionEvent event) {
        this.save();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.roleName, Validator.createEmptyValidator((String)"Required"));
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.save.setOnAction(e -> this.save());
    }

    public void save() {
        block10: {
            try {
                int tRoleId = 0;
                String tRoleName = "";
                try {
                    tRoleId = Integer.parseInt(this.roleId.getText().trim());
                }
                catch (Exception y) {
                    tRoleId = 0;
                }
                try {
                    tRoleName = this.roleName.getText().trim();
                }
                catch (Exception y) {
                    tRoleName = "";
                }
                if (tRoleName.length() < 4) {
                    this.notificationPane.setText("Role name is required");
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                    break block10;
                }
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("roleId", tRoleId);
                    params.put("roleName", tRoleName);
                    String response = Config.loadDataFromPhp("mastercreate?type=userrole", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)Config.getCheckIcon());
                        GeneralListController.publicNotificationPane.show();
                        Stage stage = (Stage)this.save.getScene().getWindow();
                        stage.close();
                        break block10;
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("Please try again");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
    }
}

