/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.NumberSeries;
import classes.TransferAccounts;
import classes.TransferFunds;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class TransferFundsController
implements Initializable {
    private User user;
    private TransferFunds transferFunds;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label transferNo;
    @FXML
    private DatePicker transferDate;
    @FXML
    private ComboBox<Member> transferFrom;
    @FXML
    private Button chooseTransferFrom;
    @FXML
    private ComboBox<TransferAccounts> fromAccount;
    @FXML
    private Label currentBalance;
    @FXML
    private ComboBox<Member> transferTo;
    @FXML
    private Button chooseTransferTo;
    @FXML
    private ComboBox<TransferAccounts> toAccount;
    @FXML
    private TextField transferAmount;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public TransferFunds getTransferFunds() {
        return this.transferFunds;
    }

    public void setTransferFunds(TransferFunds transferFunds) {
        this.transferFunds = transferFunds;
        try {
            this.transferNo.setText(transferFunds.getTransferNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferDate.setValue((Object)Config.stringToLocalDate(transferFunds.getTransferDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferFrom.setValue((Object)transferFunds.getTransferFrom());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.fromAccount.setValue((Object)transferFunds.getFromAccount());
            this.getBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferTo.setValue((Object)transferFunds.getTransferTo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.toAccount.setValue((Object)transferFunds.getToAccount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferAmount.setText(transferFunds.getTransferAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (transferFunds.isPosted()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.transferDate.setValue((Object)Config.getCurrentLocaldate());
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    TransferFundsController.this.notificationPane.setText("Loading values. Please wait....");
                    TransferFundsController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    TransferFundsController.this.notificationPane.show();
                });
                ObservableList<Member> allMembers = new Member().getAllMembers(TransferFundsController.this.getUser());
                TransferFundsController.this.transferFrom.setItems(allMembers);
                TransferFundsController.this.transferTo.setItems(allMembers);
                ObservableList<TransferAccounts> allAccounts = new TransferAccounts().getTransferAccount(TransferFundsController.this.getUser());
                TransferFundsController.this.fromAccount.setItems(allAccounts);
                TransferFundsController.this.toAccount.setItems(allAccounts);
                Platform.runLater(() -> TransferFundsController.this.notificationPane.hide());
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
        this.transferFrom.setOnAction(e -> this.getBalance());
        this.fromAccount.setOnAction(e -> this.getBalance());
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.post()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.notificationPane.setContent((Node)this.notificationHolder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.transferFrom, Validator.createEmptyValidator((String)"Transfer from is required"));
        vs.registerValidator(this.transferTo, Validator.createEmptyValidator((String)"Transfer To is required"));
        vs.registerValidator(this.fromAccount, Validator.createEmptyValidator((String)"Transfer from Account is required"));
        vs.registerValidator(this.toAccount, Validator.createEmptyValidator((String)"Transfer to Account is required"));
        vs.registerValidator((Control)this.transferAmount, Validator.createEmptyValidator((String)"Transfer Amount is required"));
        vs.registerValidator((Control)this.transferDate, Validator.createEmptyValidator((String)"Transfer Date is required"));
        this.chooseTransferFrom.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String mNo = m.getMemberNumber();
                if (!mNo.equals("") && !mNo.equals(null)) {
                    this.transferFrom.setValue((Object)m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.chooseTransferTo.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String mNo = m.getMemberNumber();
                if (!mNo.equals("") && !mNo.equals(null)) {
                    this.transferTo.setValue((Object)m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
    }

    public void getBalance() {
        String memberNo = "";
        String transcationType = "";
        try {
            memberNo = ((Member)this.transferFrom.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            memberNo = "";
        }
        try {
            transcationType = ((TransferAccounts)this.fromAccount.getValue()).getTransferCode();
        }
        catch (Exception t) {
            transcationType = "";
        }
        if (!(memberNo.equals(null) || memberNo.equals("") || transcationType.equals(null) || transcationType.equals(""))) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNo", memberNo);
                params.put("transactionType", transcationType);
                String response = Config.loadDataFromPhp("masterfetch?type=memberaccountbalance", params, this.getUser());
                Double[] myValues = (Double[])new Gson().fromJson(response, Double[].class);
                this.currentBalance.setText(Config.formatNumber(myValues[0]));
            }
            catch (NullPointerException params) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We could not be able to compute the member balance");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
    }

    public boolean save() {
        String tTransferNo = "";
        String tTransferDate = "";
        String tTransferFrom = "";
        String tFromAccount = "";
        String tTransferTo = "";
        String tToAccount = "";
        double tAmount = 0.0;
        String message = "";
        boolean error = false;
        boolean newVoucher = false;
        NumberSeries ns = new NumberSeries(16, this.getUser());
        try {
            tTransferNo = this.transferNo.getText().trim();
            if (tTransferNo.equals(null) || tTransferNo.equals("") || tTransferNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tTransferNo = ns.getNextNumber();
            newVoucher = true;
        }
        try {
            tTransferDate = Config.localDateToString((LocalDate)this.transferDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid date";
        }
        try {
            tTransferFrom = ((Member)this.transferFrom.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the member to transfer from";
        }
        try {
            tFromAccount = ((TransferAccounts)this.fromAccount.getValue()).getTransferCode();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the account to transfer from";
        }
        try {
            tTransferTo = ((Member)this.transferTo.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the member to transfer to";
        }
        try {
            tToAccount = ((TransferAccounts)this.toAccount.getValue()).getTransferCode();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the account to transfer to";
        }
        try {
            tAmount = Double.parseDouble(this.transferAmount.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid amount";
        }
        if (!error) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("transferNo", tTransferNo);
                params.put("transferDate", tTransferDate);
                params.put("transferFrom", tTransferFrom);
                params.put("fromAccount", tFromAccount);
                params.put("transferTo", tTransferTo);
                params.put("toAccount", tToAccount);
                params.put("amount", tAmount);
                String response = Config.loadDataFromPhp("mastercreate?type=transferfunds", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (newVoucher) {
                        this.transferNo.setText(tTransferNo);
                        ns.updateLastUsed(tTransferNo);
                    }
                    return true;
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        } else {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public boolean post() {
        if (this.save()) {
            try {
                String tTransferNo = this.transferNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("transferNo", tTransferNo);
                String response = Config.loadDataFromPhp("masterpost?type=transferfunds", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }
}

