/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.TransactionTypes;
import classes.User;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class TransactionTypesController
implements Initializable {
    private User user;
    @FXML
    MaskerPane masker;
    @FXML
    private TableView<TransactionTypes> transactionTypes;
    @FXML
    private TableColumn transactionCode;
    @FXML
    private TableColumn transactionDescription;
    @FXML
    private TableColumn transactionGl;
    @FXML
    private TableColumn transactionAddedOn;
    @FXML
    private TableColumn transactionAddedBy;
    @FXML
    private TableColumn transactionNoOfTransactions;
    @FXML
    private TableColumn enabled;
    @FXML
    private TextField transactionTypeCode;
    @FXML
    private TextField transactionTypedescription;
    @FXML
    private ComboBox glAccount;
    @FXML
    private Button addTransactionType;
    @FXML
    private JFXButton showEntries;
    @FXML
    private JFXButton deleteTransactionType;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton blockTransactionType;
    @FXML
    private JFXButton unblockTransactionType;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        ObservableList accountsName = FXCollections.observableArrayList();
        for (Account account : Account.getAccounts(this.getUser())) {
            accountsName.add((Object)account.getAccountName());
        }
        this.glAccount.setItems(accountsName);
        this.loadData();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.transactionCode.setCellValueFactory((Callback)new PropertyValueFactory("transactionTypeCode"));
        this.transactionDescription.setCellValueFactory((Callback)new PropertyValueFactory("transactionTypeDescription"));
        this.transactionGl.setCellValueFactory((Callback)new PropertyValueFactory("accountName"));
        this.transactionAddedOn.setCellValueFactory((Callback)new PropertyValueFactory("addedOn"));
        this.transactionAddedBy.setCellValueFactory((Callback)new PropertyValueFactory("addedBy"));
        this.transactionNoOfTransactions.setCellValueFactory((Callback)new PropertyValueFactory("noOfTransactions"));
        this.enabled.setCellValueFactory((Callback)new PropertyValueFactory("enabled"));
        this.refresh.setOnAction(e -> this.loadData());
        this.addTransactionType.setOnAction(e -> {
            Boolean error = false;
            String myTransCode = this.transactionTypeCode.getText().trim();
            String myTransDesc = this.transactionTypedescription.getText().trim();
            String transGl = "";
            try {
                transGl = this.glAccount.getValue().toString();
            }
            catch (NullPointerException p) {
                error = true;
                this.glAccount.setStyle(Config.errorStyle);
            }
            if (myTransCode.equals("") || myTransCode.equals(null)) {
                error = true;
                this.transactionTypeCode.setStyle(Config.errorStyle);
            }
            if (myTransDesc.equals("") || myTransDesc.equals(null)) {
                error = true;
                this.transactionTypedescription.setStyle(Config.errorStyle);
            }
            if (transGl.equals("") || transGl.equals(null)) {
                error = true;
                this.glAccount.setStyle(Config.errorStyle);
            }
            if (!error.booleanValue()) {
                // empty if block
            }
        });
        this.transactionTypeCode.textProperty().addListener((observable, oldValue, newValue) -> Config.resetErrorStyle((Node)this.transactionTypeCode));
        this.transactionTypedescription.textProperty().addListener((observable, oldValue, newValue) -> Config.resetErrorStyle((Node)this.transactionTypedescription));
        this.glAccount.setOnAction(e -> Config.resetErrorStyle((Node)this.glAccount));
    }

    public void loadData() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            ObservableList<TransactionTypes> allTransactionTypes = new TransactionTypes().getTransactionTypes(0, this.getUser());
            this.transactionTypes.setItems(allTransactionTypes);
            this.masker.setVisible(false);
        });
    }
}

