/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.FormattingCell;
import classes.JsonResponses;
import classes.ShopLocation;
import classes.StockTake;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class StockTakeController
implements Initializable {
    FilteredList<StockTake.StockTakeLines> filteredData = new FilteredList(FXCollections.observableArrayList(), s -> true);
    SortedList<StockTake.StockTakeLines> sortableData;
    boolean closed = false;
    private User user;
    private StockTake stockTake;
    @FXML
    private Label documentNo;
    @FXML
    private DatePicker documentDate;
    @FXML
    private ComboBox<ShopLocation> warehouse;
    @FXML
    private Label createdOn;
    @FXML
    private Label createdBy;
    @FXML
    private TextField searchItem;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableView<StockTake.StockTakeLines> allItems;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colItemName;
    @FXML
    private TableColumn colAvailable;
    @FXML
    private TableColumn colPhysical;
    @FXML
    private TableColumn colVariance;
    @FXML
    private TableColumn colUnitPrice;
    @FXML
    private TableColumn colTotalValue;
    @FXML
    private MaskerPane masker;
    @FXML
    private Button save;
    @FXML
    private Button close;
    @FXML
    private Label totalsLabel;
    @FXML
    private Label availableLabel;
    @FXML
    private Label physicalLabel;
    @FXML
    private Label varianceLabel;
    @FXML
    private Label unitPriceLabel;
    @FXML
    private Label totalValueLabel;
    @FXML
    private Button template;
    @FXML
    private Button upload;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(user);
        this.warehouse.setItems(allLocations);
        this.createdBy.setText(user.getUserName());
        this.createdOn.setText(Config.getSystemTime());
    }

    public StockTake getStockTake() {
        return this.stockTake;
    }

    public void setStockTake(StockTake stockTake) {
        this.stockTake = stockTake;
        this.save.setDisable(true);
        this.close.setDisable(stockTake.isClosed());
        this.documentNo.setText(stockTake.getDocNo());
        this.documentDate.setValue((Object)Config.stringToLocalDate(stockTake.getDate()));
        this.createdBy.setText(stockTake.getCreatedBy());
        this.createdOn.setText(stockTake.getCreatedOn());
        this.warehouse.setValue((Object)stockTake.getWarehouse());
        this.loadLines();
        this.closed = stockTake.isClosed();
        if (!this.closed) {
            this.template.setDisable(false);
            this.upload.setDisable(false);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.stackPane);
        this.documentDate.setValue((Object)Config.getCurrentLocaldate());
        this.masker.setVisible(false);
        this.close.setDisable(true);
        PrefixSelectionCustomizer.customize(this.warehouse);
        this.totalsLabel.setText("Total");
        this.unitPriceLabel.setText("");
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colItemName.setCellValueFactory((Callback)new PropertyValueFactory("item"));
        this.colAvailable.setCellValueFactory((Callback)new PropertyValueFactory("availableStock"));
        this.colAvailable.setCellFactory(column -> new FormattingCell());
        this.colVariance.setCellValueFactory((Callback)new PropertyValueFactory("variance"));
        this.colUnitPrice.setCellValueFactory((Callback)new PropertyValueFactory("unitPrice"));
        this.colTotalValue.setCellValueFactory((Callback)new PropertyValueFactory("totalValue"));
        this.colVariance.setCellFactory(column -> new FormattingCell());
        this.colUnitPrice.setCellFactory(column -> new FormattingCell());
        this.colTotalValue.setCellFactory(column -> new FormattingCell());
        Gson gson = new Gson();
        this.searchItem.textProperty().addListener((observable, oldValue, newValue) -> {
            String searchString = this.searchItem.getText().trim().toLowerCase();
            if (searchString == null || searchString.length() == 0) {
                this.filteredData.setPredicate(s -> true);
            } else {
                this.filteredData.setPredicate(s -> this.searchStrings(gson.toJson(s), searchString));
            }
        });
        Callback<TableColumn<StockTake.StockTakeLines, StockTake.StockTakeLines>, TableCell<StockTake.StockTakeLines, StockTake.StockTakeLines>> cellFactory = new Callback<TableColumn<StockTake.StockTakeLines, StockTake.StockTakeLines>, TableCell<StockTake.StockTakeLines, StockTake.StockTakeLines>>(){

            public TableCell<StockTake.StockTakeLines, StockTake.StockTakeLines> call(TableColumn<StockTake.StockTakeLines, StockTake.StockTakeLines> param) {
                TableCell<StockTake.StockTakeLines, StockTake.StockTakeLines> cell = new TableCell<StockTake.StockTakeLines, StockTake.StockTakeLines>(){
                    private final Hyperlink btn = new Hyperlink("Edit");
                    {
                        this.btn.setOnAction(e -> {
                            this.btn.setVisited(false);
                            if (StockTakeController.this.closed) {
                                StockTakeController.this.notificationPane.setText("the document has already been closed. No changes can be made");
                                StockTakeController.this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                                StockTakeController.this.notificationPane.show();
                            } else {
                                StockTake.StockTakeLines data = (StockTake.StockTakeLines)this.getTableView().getItems().get(this.getIndex());
                                TextInputDialog alert = new TextInputDialog(data.getPhysicalCount() + "");
                                alert.setHeaderText(null);
                                alert.setTitle("Edit Physical Count");
                                alert.setContentText("Edit Physical Count");
                                Optional result = alert.showAndWait();
                                result.ifPresent(physicalStock -> StockTakeController.this.editPhysicalCount(physicalStock, data));
                            }
                        });
                    }

                    public void updateItem(StockTake.StockTakeLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            Double issuedQuantity = item.getPhysicalCount();
                            this.btn.setText(Config.formatNumber(issuedQuantity));
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colPhysical.setCellFactory((Callback)cellFactory);
        this.colPhysical.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.save.setOnAction(e -> {
            boolean error = false;
            String message = "";
            int locationCode = 0;
            String selectedDate = "";
            try {
                locationCode = ((ShopLocation)this.warehouse.getValue()).getId();
            }
            catch (Exception ignored) {
                error = true;
                message = "Please select the warehouse";
            }
            try {
                selectedDate = Config.localDateToString((LocalDate)this.documentDate.getValue());
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select a document date";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("locationCode", locationCode);
                params.put("selectedDate", selectedDate);
                String response = Config.loadDataFromPhp("mastercreate?type=stock_take", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.documentNo.setText(jr.getOverLoad1());
                    this.save.setDisable(true);
                    this.close.setDisable(false);
                    this.template.setDisable(false);
                    this.upload.setDisable(false);
                    this.loadLines();
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            }
            this.notificationPane.show();
        });
        this.close.setOnAction(e -> {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Confirm Closing");
            alert.setHeaderText("Closing the Stock take cannot be undone ");
            alert.setContentText("Are you sure you want to close the stock take number " + this.documentNo.getText().trim() + "?");
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                try {
                    String docNo = this.documentNo.getText().trim();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("docNo", docNo);
                    String response = Config.loadDataFromPhp("masterpost?type=stock_take", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        ((Stage)this.close.getScene().getWindow()).close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
                catch (Exception ignored) {
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
        this.template.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
            fileChooser.setTitle("Please select location and name of template");
            fileChooser.getExtensionFilters().add((Object)extFilter);
            Stage stage = new Stage();
            File file = fileChooser.showSaveDialog((Window)stage);
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("Stock Take");
            XSSFDataFormat format = workbook.createDataFormat();
            XSSFCellStyle style = workbook.createCellStyle();
            style.setDataFormat(format.getFormat("#,##0.00"));
            XSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)12);
            font.setBold(true);
            XSSFCellStyle headerStyle = workbook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setFont((Font)font);
            XSSFCellStyle headerStyle2 = workbook.createCellStyle();
            headerStyle2.setFont((Font)font);
            XSSFCellStyle totalStyle = workbook.createCellStyle();
            totalStyle.setFont((Font)font);
            totalStyle.setDataFormat(format.getFormat("#,##0.00"));
            int rowCount = 0;
            int columnCount = 0;
            if (file != null) {
                XSSFRow row = sheet.createRow(rowCount++);
                Cell itemCode = row.createCell(columnCount++);
                itemCode.setCellValue("Item Code");
                itemCode.setCellStyle((CellStyle)headerStyle);
                Cell itemName = row.createCell(columnCount++);
                itemName.setCellValue("Item Code");
                itemName.setCellStyle((CellStyle)headerStyle);
                Cell physical = row.createCell(columnCount++);
                physical.setCellValue("Physical");
                physical.setCellStyle((CellStyle)headerStyle);
                ObservableList children = this.allItems.getItems();
                for (StockTake.StockTakeLines child : children) {
                    columnCount = 0;
                    XSSFRow row2 = sheet.createRow(rowCount++);
                    row2.createCell(columnCount++).setCellValue(child.getItemCode());
                    row2.createCell(columnCount++).setCellValue(child.getItem().getName());
                }
            }
            for (int a = 0; a < 3; ++a) {
                sheet.autoSizeColumn(a);
            }
            try (FileOutputStream outputStream2 = new FileOutputStream(file);){
                workbook.write((OutputStream)outputStream2);
            }
            catch (Exception outputStream2) {
                // empty catch block
            }
            stage.close();
            new Config();
            if (Config.showConfirmDialog("Open File", "Would you like to open the created file?", null)) {
                try {
                    if (!Desktop.isDesktopSupported()) {
                        System.out.println("not supported");
                        return;
                    }
                    Desktop desktop = Desktop.getDesktop();
                    if (file.exists()) {
                        desktop.open(file);
                    }
                }
                catch (Exception f) {
                    f.printStackTrace();
                }
            }
        });
        this.upload.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Select Excel to Import Entries From");
                chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx"})});
                try {
                    File file = chooser.showOpenDialog((Window)new Stage());
                    if (file != null) {
                        XSSFWorkbook wb = new XSSFWorkbook(file);
                        final XSSFSheet ws = wb.getSheetAt(0);
                        System.out.println("No of rows " + ws.getPhysicalNumberOfRows());
                        Platform.runLater(() -> {
                            StockTakeController.this.masker.setText("Uploading Records. Please wait");
                            StockTakeController.this.masker.setVisible(true);
                        });
                        Task<Void> task1 = new Task<Void>(){

                            public Void call() {
                                int noOfRecords = ws.getPhysicalNumberOfRows();
                                for (int b = 1; b < noOfRecords; ++b) {
                                    int c = b;
                                    this.updateProgress(c + 1, noOfRecords);
                                    Platform.runLater(() -> StockTakeController.this.masker.setText("Uploading Records. Please wait... " + (c + 1) + " of " + noOfRecords));
                                    XSSFRow myRow = ws.getRow(b);
                                    try {
                                        String tColumnDetails;
                                        Cell myCell2;
                                        String tProductCode = "";
                                        String tProductName = "";
                                        double tPhysical = 0.0;
                                        try {
                                            myCell2 = myRow.getCell(0);
                                            tProductCode = tColumnDetails = myCell2.toString().trim();
                                            tProductCode = tProductCode.replace(".0", "");
                                        }
                                        catch (Exception myCell2) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(1);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tProductName = tColumnDetails;
                                            }
                                            catch (Exception u) {
                                                tProductName = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell3) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(2);
                                            try {
                                                tPhysical = myCell2.getNumericCellValue();
                                                if (tPhysical == 0.0) {
                                                    throw new Exception();
                                                }
                                            }
                                            catch (Exception u) {
                                            }
                                        }
                                        catch (Exception t) {}
                                        continue;
                                        try {
                                            int lineId = 0;
                                            String finalTProductCode = tProductCode;
                                            ObservableList filtered = FXCollections.observableArrayList((Collection)StockTakeController.this.allItems.getItems().stream().filter(v -> v.getItem().getCode().equalsIgnoreCase(finalTProductCode)).collect(Collectors.toList()));
                                            if (filtered.size() != 1) {
                                                System.out.println(finalTProductCode + " not found");
                                                continue;
                                            }
                                            lineId = ((StockTake.StockTakeLines)filtered.get(0)).getLineId();
                                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                            params.put("physical", tPhysical);
                                            params.put("itemCode", tProductCode);
                                            params.put("header", StockTakeController.this.documentNo.getText().trim());
                                            params.put("lineId", lineId);
                                            StockTakeController.this.updateCount(params);
                                        }
                                        catch (Exception o) {
                                            o.printStackTrace();
                                        }
                                        continue;
                                    }
                                    catch (Exception u) {
                                        u.printStackTrace();
                                    }
                                }
                                StockTakeController.this.loadLines();
                                return null;
                            }
                        };
                        Thread backgroundThread = new Thread((Runnable)task1);
                        backgroundThread.setDaemon(true);
                        StockTakeController.this.masker.progressProperty().bind((ObservableValue)task1.progressProperty());
                        backgroundThread.start();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
    }

    private void editPhysicalCount(String physicalStock, StockTake.StockTakeLines data) {
        try {
            double myPhysical = Double.parseDouble(physicalStock);
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("physical", myPhysical);
            params.put("itemCode", data.getItemCode());
            params.put("header", data.getHeaderNo());
            params.put("lineId", data.getLineId());
            JsonResponses jr = this.updateCount(params);
            if (jr.isStatus()) {
                StockTake.StockTakeLines data2 = (StockTake.StockTakeLines)new Gson().fromJson(jr.getOverLoad1(), StockTake.StockTakeLines.class);
                data.setPhysicalCount(data2.getPhysicalCount());
                data.setVariance(data2.getVariance());
                data.setTotalValue(data2.getTotalValue());
                this.allItems.refresh();
                this.updateTotals();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
        catch (NumberFormatException u) {
            this.notificationPane.setText("Please enter a valid number");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        catch (Exception p) {
            this.notificationPane.setText("We encountered an error while processing your request");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public JsonResponses updateCount(Map<String, Object> params) {
        try {
            String response = Config.loadDataFromPhp("masterupdate?type=stock_take_lines", params, this.getUser());
            return (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        }
        catch (NumberFormatException u) {
            this.notificationPane.setText("Please enter a valid number");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        catch (Exception p) {
            this.notificationPane.setText("We encountered an error while processing your request");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        return null;
    }

    public void loadLines() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> StockTakeController.this.masker.setVisible(true));
                ObservableList<StockTake.StockTakeLines> myLines = new StockTake().getLines(StockTakeController.this.documentNo.getText(), StockTakeController.this.getUser());
                StockTakeController.this.filteredData = new FilteredList(FXCollections.observableArrayList(myLines), s -> true);
                StockTakeController.this.sortableData = new SortedList(StockTakeController.this.filteredData);
                Platform.runLater(() -> {
                    StockTakeController.this.allItems.setItems(StockTakeController.this.sortableData);
                    StockTakeController.this.sortableData.comparatorProperty().bind((ObservableValue)StockTakeController.this.allItems.comparatorProperty());
                    StockTakeController.this.masker.setVisible(false);
                    StockTakeController.this.updateTotals();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public boolean searchStrings(String hayStack, String needle) {
        String[] searches;
        boolean result = true;
        for (String t : searches = needle.split("[& ]")) {
            result = hayStack.contains(t) && result;
        }
        return result;
    }

    public void updateTotals() {
        ObservableList myLines = this.allItems.getItems();
        double tAvailable = myLines.stream().mapToDouble(StockTake.StockTakeLines::getAvailableStock).sum();
        double tPhysical = myLines.stream().mapToDouble(StockTake.StockTakeLines::getPhysicalCount).sum();
        double tVariance = myLines.stream().mapToDouble(StockTake.StockTakeLines::getVariance).sum();
        double tTotal = myLines.stream().mapToDouble(StockTake.StockTakeLines::getTotalValue).sum();
        Platform.runLater(() -> {
            this.availableLabel.setText(Config.formatNumber(tAvailable));
            this.physicalLabel.setText(Config.formatNumber(tPhysical));
            this.varianceLabel.setText(Config.formatNumber(tVariance));
            this.totalValueLabel.setText(Config.formatNumber(tTotal));
        });
    }
}

