/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.StaffLoan;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class StaffLoanForm
implements Initializable {
    private User user;
    @FXML
    private VBox vbStaffLoan;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelId;
    @FXML
    private ComboBox<Employee> cbEmployee;
    @FXML
    private TextField tfAmount;
    @FXML
    private TextField monthlyPayments;
    @FXML
    private TextField tfInstallments;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnPost;
    @FXML
    private Button btnReverse;
    @FXML
    private ComboBox<Bank> cbBank;
    @FXML
    private TextField tfDocNo;
    @FXML
    private DatePicker dpDate;
    @FXML
    private NotificationPane notificationPane;
    private StaffLoan staffLoan;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        this.btnSave.setDisable(false);
        this.btnPost.setDisable(false);
        Task task = new Task(){

            public Void call() {
                Platform.runLater(() -> {
                    StaffLoanForm.this.notificationPane.setText("Loading Values. Please wait...");
                    StaffLoanForm.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    StaffLoanForm.this.notificationPane.show();
                });
                StaffLoanForm.this.cbEmployee.setItems(FXCollections.observableArrayList(new Employee().getAllEmployees(user)));
                StaffLoanForm.this.cbBank.setItems(FXCollections.observableArrayList(Bank.getAllBanks(user)));
                Platform.runLater(() -> StaffLoanForm.this.notificationPane.hide());
                return null;
            }
        };
        Thread thread = new Thread((Runnable)task);
        thread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.tfAmount.textProperty().addListener((observable, oldValue, newValue) -> this.computeMonthlyInstallments());
        this.tfInstallments.textProperty().addListener((observable, oldValue, newValue) -> this.computeMonthlyInstallments());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.cbEmployee, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.tfAmount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.tfInstallments, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.dpDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbBank, Validator.createEmptyValidator((String)"Required"));
        this.btnSave.setOnAction(event -> this.save());
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbStaffLoan.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void post(ActionEvent event) {
        if (this.save()) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                String loanNo = this.labelId.getText().trim();
                params.put("loanNo", loanNo);
                String response = Config.loadDataFromPhp("masterpost?type=staffloan", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.btnPost.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
    }

    @FXML
    void reverse(ActionEvent event) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String loanNo = this.labelId.getText().trim();
            params.put("loanNo", loanNo);
            String response = Config.loadDataFromPhp("masterpost?type=reversestaffloan", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.btnPost.getScene().getWindow();
                stage.close();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
        catch (Exception y) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    private boolean save() {
        String installments = "";
        String errorMessage = "";
        String extDocNo = "";
        String date = "";
        Employee employee = null;
        double amount = 0.0;
        Bank bank = null;
        NumberSeries ns = new NumberSeries(47, this.getUser());
        String id = "";
        boolean error = false;
        try {
            employee = (Employee)this.cbEmployee.getValue();
            if (employee == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Select a valid employee";
        }
        try {
            amount = Double.parseDouble(this.tfAmount.getText().trim().replaceAll(",", ""));
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Enter a valid amount" : "\nEnter a valid amount");
        }
        try {
            installments = this.tfInstallments.getText().trim();
            if (installments.equals("")) {
                throw new Exception();
            }
            double am = Double.parseDouble(installments);
            if (am <= 0.0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Enter a valid number of installments" : "\nEnter a valid number of installments");
        }
        try {
            bank = (Bank)this.cbBank.getValue();
            if (bank == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid Bank" : "\nSelect a valid Bank");
        }
        try {
            date = Config.localDateToString((LocalDate)this.dpDate.getValue());
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid date" : "\nSelect a valid date");
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            id = !this.labelId.getText().trim().equals("") ? this.labelId.getText().trim() : ns.getNextNumber();
            extDocNo = extDocNo + this.tfDocNo.getText().trim();
            try {
                params.put("id", id);
                params.put("employee", employee.getEmployeeNumber());
                params.put("amount", amount);
                params.put("installments", installments);
                params.put("extDocNo", extDocNo);
                params.put("date", date);
                params.put("bank", bank.getCode());
                String response = Config.loadDataFromPhp("mastercreate?type=staffloan", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (this.labelId.getText().trim().equals("")) {
                        ns.updateLastUsed(id);
                    }
                    this.labelId.setText(id);
                }
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.show();
            }
        }
        return false;
    }

    public void setStaffLoan(StaffLoan loan) {
        this.staffLoan = loan;
        this.labelId.setText(loan.getId());
        this.cbEmployee.getSelectionModel().select((Object)loan.getEmployee());
        this.tfAmount.setText(loan.getAmount() + "");
        this.tfInstallments.setText(loan.getInstallments() + "");
        this.btnPost.setDisable(loan.isPosted());
        this.tfDocNo.setText(loan.getExtDocNo());
        this.cbBank.getSelectionModel().select((Object)loan.getBank());
        this.dpDate.setValue((Object)Config.stringToLocalDate(loan.getDate()));
        if (loan.isPosted()) {
            this.btnPost.setDisable(true);
            this.btnSave.setDisable(true);
            this.btnReverse.setDisable(false);
            this.cbEmployee.setDisable(true);
            this.dpDate.setDisable(true);
            this.tfAmount.setDisable(true);
            this.tfInstallments.setDisable(true);
            this.cbBank.setDisable(true);
            this.tfDocNo.setDisable(true);
        } else {
            this.btnSave.setDisable(false);
        }
        if (loan.isReversed()) {
            this.btnReverse.setDisable(true);
        }
        this.computeMonthlyInstallments();
    }

    public void computeMonthlyInstallments() {
        double amount = 0.0;
        double installments = 0.0;
        try {
            amount = Double.parseDouble(this.tfAmount.getText().trim());
            if (amount == 0.0) {
                this.monthlyPayments.setText("");
                return;
            }
        }
        catch (Exception y) {
            this.monthlyPayments.setText("");
            return;
        }
        try {
            installments = Double.parseDouble(this.tfInstallments.getText().trim());
            if (installments == 0.0) {
                this.monthlyPayments.setText("");
                return;
            }
        }
        catch (Exception y) {
            this.monthlyPayments.setText("");
            return;
        }
        double mMonthly = amount / installments;
        this.monthlyPayments.setText(Config.formatNumber(mMonthly));
    }
}

