/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Month;
import classes.ServiceFeeEntries;
import classes.ServiceFeeVoucher;
import classes.User;
import classes.Year;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ServiceFeeCardController
implements Initializable {
    private User user;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private TableView<ServiceFeeEntries> allEntries;
    @FXML
    private TableColumn vehicle;
    @FXML
    private TableColumn owner;
    @FXML
    private TableColumn daysinactive;
    @FXML
    private TableColumn feeCharged;
    @FXML
    private ComboBox<Month> month;
    @FXML
    private ComboBox<Year> year;
    @FXML
    private Label voucherNo;
    @FXML
    private Label createdOn;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton post;
    @FXML
    private JFXButton delete;
    @FXML
    private Label totalAmount;
    private ServiceFeeVoucher voucher;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.year.setItems(new Year().getAllYears(this.getUser()));
    }

    public ServiceFeeVoucher getVoucher() {
        return this.voucher;
    }

    public void setVoucher(ServiceFeeVoucher voucher) {
        this.voucher = voucher;
        this.createdOn.setText(voucher.getCreatedOn());
        this.voucherNo.setText(voucher.getId() + "");
        this.month.setValue((Object)voucher.getMonth());
        this.year.setValue((Object)voucher.getYear());
        this.loadList();
        if (voucher.isPosted()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
            this.month.setDisable(true);
            this.year.setDisable(true);
            this.delete.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.month.setItems(new Month().getAllMonths());
        this.notificationPane.setContent(this.allEntries);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.month, Validator.createEmptyValidator((String)"Month is required"));
        vs.registerValidator(this.year, Validator.createEmptyValidator((String)"Year is required"));
        this.vehicle.setCellValueFactory((Callback)new PropertyValueFactory("vehicle"));
        this.owner.setCellValueFactory((Callback)new PropertyValueFactory("owner"));
        this.daysinactive.setCellValueFactory((Callback)new PropertyValueFactory("edit"));
        this.feeCharged.setCellValueFactory((Callback)new PropertyValueFactory("feeChargedString"));
        this.save.setOnAction(e -> {
            if (this.save()) {
                this.loadList();
            }
        });
        this.post.setOnAction(e -> {
            if (this.save()) {
                try {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Confirm Post");
                    alert.setHeaderText("Posting the service fee voucher results in a change in the financial position. ");
                    alert.setContentText("Are you sure you want to post voucher number " + this.voucherNo.getText() + "?");
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.OK) {
                        int voucherCode = Integer.parseInt(this.voucherNo.getText().trim());
                        JsonResponses jr = new ServiceFeeEntries().post(voucherCode, this.getUser());
                        if (jr.isStatus()) {
                            Stage stage = (Stage)this.post.getScene().getWindow();
                            stage.close();
                        } else {
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                            this.notificationPane.show();
                        }
                    }
                }
                catch (Exception t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public boolean save() {
        this.notificationPane.setText("Please wait while we create the voucher");
        this.notificationPane.setGraphic((Node)new ProgressIndicator());
        this.notificationPane.show();
        boolean error = false;
        String message = "";
        int monthCode = 0;
        int yearCode = 0;
        try {
            monthCode = ((Month)this.month.getValue()).getCode();
            if (monthCode < 1 || monthCode > 12) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the month";
        }
        try {
            yearCode = ((Year)this.year.getValue()).getYear();
            if (yearCode < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the year";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            boolean newVoucher = false;
            try {
                int voucherCode = Integer.parseInt(this.voucherNo.getText().trim());
                params.put("voucherCode", voucherCode);
            }
            catch (Exception e) {
                newVoucher = true;
            }
            params.put("month", monthCode);
            params.put("year", yearCode);
            String response = Config.loadDataFromPhp("mastercreate?type=servicevoucher", params, this.getUser());
            Gson g = new Gson();
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                String r = jr.getMessage();
                String[] info = r.split("%");
                this.notificationPane.setText(info[0]);
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.show();
                if (!newVoucher) {
                    if (!this.saveLines()) {
                        return false;
                    }
                } else {
                    this.voucherNo.setText(info[1]);
                }
                return true;
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public void loadList() {
        String tVoucherNo = this.voucherNo.getText().trim();
        try {
            int voucherCode = Integer.parseInt(tVoucherNo);
            ObservableList<ServiceFeeEntries> allLines = new ServiceFeeEntries().getAllEntries(voucherCode, this.getUser());
            double total = 0.0;
            for (ServiceFeeEntries line : allLines) {
                total += line.getFeeCharged();
            }
            this.totalAmount.setText(Config.formatNumber(total));
            this.allEntries.setItems(allLines);
        }
        catch (Exception e) {
            this.notificationPane.setText("We experienced an error while loading the voucher lines");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            e.printStackTrace();
        }
    }

    public boolean saveLines() {
        this.notificationPane.setText("Please wait while we save the lines");
        this.notificationPane.setGraphic((Node)new ProgressIndicator());
        this.notificationPane.show();
        ObservableList myEntries = this.allEntries.getItems();
        Gson g = new Gson();
        ObservableList myEnt = FXCollections.observableArrayList();
        for (ServiceFeeEntries entry : myEntries) {
            ObservableList individual = FXCollections.observableArrayList();
            individual.add((Object)(entry.getId() + ""));
            individual.add((Object)(entry.getDaysInActive() + ""));
            myEnt.add((Object)individual);
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("data", g.toJson((Object)myEnt));
        String response = Config.loadDataFromPhp("mastercreate?type=servicefeelines", params, this.getUser());
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)Config.getCheckIcon());
            this.notificationPane.show();
            return true;
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
        this.notificationPane.show();
        return false;
    }
}

