/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.AllowancesDeductions;
import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.Month;
import classes.NumberSeries;
import classes.SalaryVoucher;
import classes.User;
import classes.Year;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class SalaryVoucherController
implements Initializable {
    private User user;
    private SalaryVoucher voucher;
    @FXML
    private VBox root;
    @FXML
    private Label voucherNo;
    @FXML
    private ComboBox<Year> payrollYear;
    @FXML
    private ComboBox<Month> payrollMonth;
    @FXML
    private Label totalNetPay;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane stackPane;
    @FXML
    private MaskerPane masker;
    @FXML
    private TableView<ObservableList<String>> allEntries;
    @FXML
    private TableColumn<ObservableList<String>, String> employeeNo;
    @FXML
    private TableColumn<ObservableList<String>, String> employeeName;
    @FXML
    private TableColumn earnings;
    @FXML
    private TableColumn deductions;
    @FXML
    private TableColumn<ObservableList<String>, String> netSalary;
    @FXML
    private Button reset;
    @FXML
    private Button save;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        double multiplier;
        TableColumn myColumn;
        this.user = user;
        this.payrollYear.setItems(new Year().getAllYears(user));
        ObservableList<AllowancesDeductions> allowances = new AllowancesDeductions().getAllAllowances(user);
        ObservableList<AllowancesDeductions> myDeductions = new AllowancesDeductions().getAllDeductions(user);
        int currentIndex = 1;
        for (AllowancesDeductions allowance : allowances) {
            try {
                int i = ++currentIndex;
                myColumn = new TableColumn();
                myColumn.setText(allowance.getName());
                int noOfAllowances = allowances.size();
                multiplier = 1.0;
                if (noOfAllowances > 0) {
                    multiplier = 0.295 / (double)noOfAllowances;
                }
                try {
                    myColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(i)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(multiplier));
                this.earnings.getColumns().add((Object)myColumn);
            }
            catch (Exception i) {}
        }
        for (AllowancesDeductions myDeduction : myDeductions) {
            try {
                int i = ++currentIndex;
                myColumn = new TableColumn();
                myColumn.setText(myDeduction.getName());
                int noOfDeductions = myDeductions.size();
                multiplier = 0.0;
                if (noOfDeductions > 0) {
                    multiplier = 0.295 / (double)noOfDeductions;
                }
                try {
                    myColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(i)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(multiplier));
                this.deductions.getColumns().add((Object)myColumn);
            }
            catch (Exception exception) {}
        }
        int i = ++currentIndex;
        this.netSalary.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(i)));
        this.save.setDisable(false);
        this.post.setDisable(false);
    }

    public SalaryVoucher getVoucher() {
        return this.voucher;
    }

    public void setVoucher(SalaryVoucher voucher) {
        this.voucher = voucher;
        try {
            this.voucherNo.setText(voucher.getVoucherNo());
            this.payrollMonth.setValue((Object)voucher.getMonth());
            this.payrollYear.setValue((Object)voucher.getYear());
            this.totalNetPay.setText(Config.formatNumber(voucher.getTotalNetPay()));
            if (voucher.isPosted()) {
                this.disableFields();
            } else {
                this.save.setDisable(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadLines();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.payrollMonth.setItems(new Month().getAllMonths());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.stackPane);
        this.employeeNo.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(0)));
        this.employeeName.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(1)));
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> this.post());
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.payrollMonth, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.payrollYear, Validator.createEmptyValidator((String)"Required"));
        LocalDate today = LocalDate.now();
        Year thisYear = new Year();
        thisYear.setYear(today.getYear());
        this.payrollYear.setValue((Object)thisYear);
        Month thisMonth = new Month();
        thisMonth.setCode(today.getMonthValue());
        for (Month myMonth : this.payrollMonth.getItems()) {
            if (myMonth.getCode() != today.getMonthValue()) continue;
            thisMonth.setMonthName(myMonth.getMonthName());
        }
        this.payrollMonth.setValue((Object)thisMonth);
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
    }

    public boolean save() {
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                Platform.runLater(() -> {
                    SalaryVoucherController.this.masker.setText("Calculating Salary");
                    SalaryVoucherController.this.masker.setVisible(true);
                });
                try {
                    SalaryVoucherController.this.save.setDisable(true);
                    SalaryVoucherController.this.post.setDisable(true);
                    SalaryVoucherController.this.reset.setDisable(true);
                    String tVoucherNo = "";
                    boolean newVoucher = false;
                    boolean error = false;
                    String message = "";
                    int monthCode = 0;
                    int yearCode = 0;
                    NumberSeries ns = new NumberSeries(31, SalaryVoucherController.this.getUser());
                    try {
                        tVoucherNo = SalaryVoucherController.this.voucherNo.getText().trim();
                        if (tVoucherNo.length() < 1) {
                            throw new Exception();
                        }
                    }
                    catch (Exception y) {
                        newVoucher = true;
                        tVoucherNo = ns.getNextNumber();
                    }
                    try {
                        monthCode = ((Month)SalaryVoucherController.this.payrollMonth.getValue()).getCode();
                    }
                    catch (Exception t) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select the payroll month";
                    }
                    try {
                        yearCode = ((Year)SalaryVoucherController.this.payrollYear.getValue()).getYear();
                    }
                    catch (Exception t) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select the payroll year";
                    }
                    if (error) {
                        String myErrorMessage = message;
                        Platform.runLater(() -> {
                            SalaryVoucherController.this.notificationPane.setText(myErrorMessage);
                            SalaryVoucherController.this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                            SalaryVoucherController.this.notificationPane.show();
                        });
                    } else {
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("voucherNo", tVoucherNo);
                        params.put("month", monthCode);
                        params.put("year", yearCode);
                        String url = newVoucher ? "mastercreate" : "masterupdate";
                        String response = Config.loadDataFromPhp(url + "?type=salaryvoucher", params, SalaryVoucherController.this.getUser());
                        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                        if (!jr.isStatus()) {
                            Platform.runLater(() -> {
                                SalaryVoucherController.this.notificationPane.setText(jr.getMessage());
                                SalaryVoucherController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                SalaryVoucherController.this.notificationPane.show();
                            });
                        } else {
                            String myVoucher = tVoucherNo;
                            Platform.runLater(() -> {
                                SalaryVoucherController.this.notificationPane.setText(jr.getMessage());
                                SalaryVoucherController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                SalaryVoucherController.this.notificationPane.show();
                                SalaryVoucherController.this.voucherNo.setText(myVoucher);
                            });
                            ns.updateLastUsed(tVoucherNo);
                            String myVoucherNo = tVoucherNo;
                            ObservableList<Employee> allEmployees = new Employee().getAllEmployees(SalaryVoucherController.this.getUser());
                            int limit = allEmployees.size();
                            for (int i = 0; i < limit; ++i) {
                                Employee employee = (Employee)allEmployees.get(i);
                                int j = i + 1;
                                this.updateProgress(j, limit);
                                Platform.runLater(() -> {
                                    String myProgressMessage = "Computing " + j + " of " + limit;
                                    myProgressMessage = myProgressMessage + "\n" + employee.getFullName();
                                    SalaryVoucherController.this.masker.setText(myProgressMessage);
                                });
                                try {
                                    String employeeNo = employee.getEmployeeNumber();
                                    LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                                    params2.put("employeeNo", employeeNo);
                                    params2.put("voucherNo", myVoucherNo);
                                    String response2 = Config.loadDataFromPhp("mastercreate?type=salaryvoucherline", params2, SalaryVoucherController.this.getUser());
                                    System.out.println(response2);
                                    JsonResponses jr2 = (JsonResponses)new Gson().fromJson(response2, JsonResponses.class);
                                    if (jr2.isStatus()) continue;
                                    Platform.runLater(() -> {
                                        SalaryVoucherController.this.notificationPane.setText(jr2.getMessage());
                                        SalaryVoucherController.this.notificationPane.setGraphic((Node)jr2.getIconFromStatus());
                                        SalaryVoucherController.this.notificationPane.show();
                                    });
                                    continue;
                                }
                                catch (Exception u) {
                                    Platform.runLater(() -> {
                                        SalaryVoucherController.this.save.setDisable(false);
                                        SalaryVoucherController.this.post.setDisable(false);
                                        SalaryVoucherController.this.reset.setDisable(false);
                                        SalaryVoucherController.this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                                        SalaryVoucherController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                                        SalaryVoucherController.this.notificationPane.show();
                                    });
                                }
                            }
                            SalaryVoucherController.this.loadLines();
                        }
                    }
                    SalaryVoucherController.this.save.setDisable(false);
                    SalaryVoucherController.this.post.setDisable(false);
                    SalaryVoucherController.this.reset.setDisable(false);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task);
        backgroundThread.setDaemon(true);
        this.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
        this.masker.progressProperty().bind((ObservableValue)task.progressProperty());
        backgroundThread.start();
        return false;
    }

    public void post() {
        block5: {
            try {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Confirm Post");
                alert.setHeaderText("Posting the salary voucher results in a change in the financial position. Kindly confirm all entries before posting");
                alert.setContentText("Are you sure you want to post salary voucher " + this.voucherNo.getText() + "?");
                Optional result = alert.showAndWait();
                if (result.get() != ButtonType.OK) break block5;
                try {
                    String tVoucherNo = this.voucherNo.getText().trim();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("voucherNo", tVoucherNo);
                    String response = Config.loadDataFromPhp("masterpost?type=salaryvoucher", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        Stage stage = (Stage)this.post.getScene().getWindow();
                        stage.close();
                        break block5;
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        }
    }

    public void loadLines() {
        ObservableList myData = FXCollections.observableArrayList();
        String tVoucherNo = this.voucherNo.getText().trim();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("voucherNo", tVoucherNo);
        String response = Config.loadDataFromPhp("masterfetch?type=salaryvoucherlines", params, this.getUser());
        System.out.println(response);
        Gson g = new Gson();
        ArrayList myEntries = (ArrayList)g.fromJson(response, ArrayList.class);
        ObservableList parsed = FXCollections.observableArrayList();
        for (ArrayList a : myEntries) {
            ObservableList row = FXCollections.observableArrayList((Collection)a);
            myData.add((Object)row);
        }
        Platform.runLater(() -> {
            this.allEntries.setItems(myData);
            this.masker.setVisible(false);
        });
    }

    public void disableFields() {
        this.save.setDisable(true);
        this.post.setDisable(true);
        this.payrollYear.setDisable(true);
        this.payrollMonth.setDisable(true);
    }
}

