/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Region;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.controlsfx.control.NotificationPane;

public class RegionsController
implements Initializable {
    private User user;
    private Region region;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label regionId;
    @FXML
    private TextField regionName;
    @FXML
    private ComboBox<Vendor> rsm;
    @FXML
    private Button addRegion;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        ObservableList<Vendor> salesReps = new Vendor().getAllVendors("Sales Rep", user);
        this.rsm.setItems(salesReps);
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
        this.regionId.setText(region.getId() + "");
        this.regionName.setText(region.getName());
        this.rsm.setValue((Object)region.getRsmManager());
        this.addRegion.setText("Save Changes");
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.addRegion.setOnAction(e -> {
            try {
                int tRegionId = 0;
                String tRegionName = "";
                String tRsmCode = "";
                boolean error = false;
                String message = "";
                try {
                    tRegionId = Integer.parseInt(this.regionId.getText().trim());
                }
                catch (Exception u) {
                    tRegionId = 0;
                }
                try {
                    tRegionName = this.regionName.getText().trim();
                    if (tRegionName.length() < 4) {
                        throw new Exception();
                    }
                }
                catch (Exception i) {
                    error = true;
                    message = "Please enter a valid region name. Atleast 3 characters";
                }
                try {
                    tRsmCode = ((Vendor)this.rsm.getValue()).getVendorNumber().trim();
                }
                catch (Exception u) {
                    tRsmCode = "";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("regionId", tRegionId);
                    params.put("regionName", tRegionName);
                    params.put("rsmCode", tRsmCode);
                    String response = Config.loadDataFromPhp("mastercreate?type=region", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    HashMap people = (HashMap)new Gson().fromJson(jr.getOverLoad2(), HashMap.class);
                    System.out.println(people);
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        this.regionId.setText(jr.getOverLoad1());
                    }
                }
            }
            catch (Exception u) {
                u.printStackTrace();
                this.notificationPane.setText("Error encountered. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }
}

