/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.Receipt;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.ReceiptController;
import filterscontrollers.AllReceiptsFilter;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class ReceiptsController
implements Initializable {
    private User user;
    ObservableList<Receipt> toSearch = FXCollections.observableArrayList();
    private boolean posted;
    private boolean reversed;
    @FXML
    NotificationPane notificationPane;
    @FXML
    MaskerPane masker;
    @FXML
    private JFXButton newReceipt;
    @FXML
    private JFXButton editReceipt;
    @FXML
    private JFXButton allReceipts;
    @FXML
    private JFXButton loansTemplate;
    @FXML
    private JFXButton deleteReceipt;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton importLoanReceipts;
    @FXML
    private JFXButton printReceipt;
    @FXML
    private TableView<Receipt> receipts;
    @FXML
    private TableColumn receiptNumber;
    @FXML
    private TableColumn member;
    @FXML
    private TableColumn paymentDate;
    @FXML
    private TableColumn paymentMethod;
    @FXML
    private TableColumn receivedFrom;
    @FXML
    private TableColumn receiptAmount;
    @FXML
    private JFXButton postReceipt;
    @FXML
    StackPane stackPane;
    @FXML
    private JFXButton viewReceipt;
    @FXML
    private TextField search;
    @FXML
    private Button clearFilter;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        this.loadReceipts();
        if (posted) {
            this.postReceipt.setDisable(true);
            this.deleteReceipt.setDisable(true);
            this.newReceipt.setDisable(true);
            this.printReceipt.setDisable(false);
            this.viewReceipt.setDisable(false);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.printReceipt.setDisable(true);
        this.viewReceipt.setDisable(true);
        this.refresh.setOnAction(e -> this.loadReceipts());
        this.receiptNumber.setCellValueFactory((Callback)new PropertyValueFactory("receiptNo"));
        this.member.setCellValueFactory((Callback)new PropertyValueFactory("member"));
        this.paymentDate.setCellValueFactory((Callback)new PropertyValueFactory("paymentDate"));
        this.paymentMethod.setCellValueFactory((Callback)new PropertyValueFactory("paymentMethod"));
        this.receivedFrom.setCellValueFactory((Callback)new PropertyValueFactory("receivedFrom"));
        this.receiptAmount.setCellValueFactory((Callback)new PropertyValueFactory("formatedAmount"));
        this.allReceipts.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/allreceipts.fxml").openStream());
                AllReceiptsFilter controller = (AllReceiptsFilter)loader.getController();
                controller.setUser(this.getUser());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("All Receipts Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.viewReceipt.setOnAction(e -> {
            try {
                Receipt rec = (Receipt)this.receipts.getSelectionModel().getSelectedItem();
                String myReceiptNo = rec.getReceiptNo();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("receiptNo", myReceiptNo);
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                new Config().getReport("Member Receipt", "masterfetch?type=memberreceipt", params, "memberreceipt.jasper", reportParams, this.getUser());
            }
            catch (NullPointerException rec) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.loansTemplate.setOnAction(e -> new Config().getReport("Loans Template", "masterfetch?type=loanstemplate", new LinkedHashMap<String, Object>(), "loanreceiptstemplate.jasper", new HashMap<String, Object>(), this.getUser()));
        this.printReceipt.setOnAction(e -> {
            try {
                Receipt rec = (Receipt)this.receipts.getSelectionModel().getSelectedItem();
                String myReceiptNo = rec.getReceiptNo();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("receiptNo", myReceiptNo);
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                new Config().printReport("Member Receipt", "masterfetch?type=memberreceipt", params, "memberreceipt.jasper", reportParams, this.getUser());
            }
            catch (NullPointerException rec) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.notificationPane.setContent((Node)this.stackPane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.refresh.setOnAction(e -> this.loadReceipts());
        this.editReceipt.setOnAction(t -> {
            Receipt receipt = (Receipt)this.receipts.getSelectionModel().getSelectedItem();
            try {
                if (!receipt.equals(null)) {
                    this.editReceipt(receipt);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.clearFilter.setOnAction(e -> this.search.setText(""));
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            String searchText = newValue.toLowerCase();
            for (int b = 0; b < this.toSearch.size(); ++b) {
                Receipt current = (Receipt)this.toSearch.get(b);
                String myAmount = current.getAmount() + "";
                if (!current.getReceiptNo().toLowerCase().contains(newValue.toLowerCase()) && !current.getMember().getFullName().toLowerCase().contains(searchText) && !current.getPaymentDate().toLowerCase().contains(searchText) && !current.getPaymentMethod().getPaymentMethod().toLowerCase().contains(searchText) && !current.getReceivedFrom().toLowerCase().contains(searchText) && !myAmount.toLowerCase().contains(searchText) && !current.getFormatedAmount().toLowerCase().contains(searchText)) continue;
                afterSearch.add((Object)current);
            }
            this.receipts.getItems().removeAll((Collection)this.receipts.getItems());
            this.receipts.setItems(afterSearch);
        });
        this.deleteReceipt.setOnAction(t -> {
            block5: {
                try {
                    Receipt receipt = (Receipt)this.receipts.getSelectionModel().getSelectedItem();
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Confirm Delete");
                    alert.setHeaderText("Deleting the item will result to loss of data. ");
                    alert.setContentText("Are you sure you want to delete receipt number " + receipt.getReceiptNo() + "?");
                    Optional result = alert.showAndWait();
                    if (result.get() != ButtonType.OK) break block5;
                    try {
                        if (receipt.deleteReceipt(receipt.getReceiptNo(), this.getUser())) {
                            this.loadReceipts();
                        }
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.postReceipt.setOnAction(t -> {
            block5: {
                try {
                    Receipt receipt = (Receipt)this.receipts.getSelectionModel().getSelectedItem();
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Confirm Post");
                    alert.setHeaderText("Posting the receipt results in a change in the financial position. ");
                    alert.setContentText("Are you sure you want to post receipt number " + receipt.getReceiptNo() + "?");
                    Optional result = alert.showAndWait();
                    if (result.get() != ButtonType.OK) break block5;
                    try {
                        JsonResponses jr = receipt.postReceipt(receipt.getReceiptNo(), this.getUser());
                        if (jr.isStatus()) {
                            this.loadReceipts();
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                            this.notificationPane.show();
                            break block5;
                        }
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.show();
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.receipts.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Receipt rowData = (Receipt)row.getItem();
                    Receipt receipt = (Receipt)this.receipts.getSelectionModel().getSelectedItem();
                    if (!receipt.equals(null)) {
                        this.editReceipt(receipt);
                    }
                }
            });
            return row;
        });
        this.newReceipt.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/receipt.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                Stage stage = new Stage();
                stage.setScene(scene);
                ReceiptController controller = (ReceiptController)loader.getController();
                controller.setUser(this.getUser());
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Create Receipt");
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ReceiptsController.this.loadReceipts();
                            }
                        });
                    }
                });
                stage.show();
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.importLoanReceipts.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Excel to Import Loan Receipts from");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx"})});
            try {
                final File file = chooser.showOpenDialog((Window)new Stage());
                NumberSeries ns = new NumberSeries(12, this.getUser());
                boolean newVoucher = false;
                if (file != null) {
                    try {
                        Task<Void> task = new Task<Void>(){

                            public Void call() throws InterruptedException {
                                Platform.runLater(() -> {
                                    ReceiptsController.this.masker.setText("Importing Receipts");
                                    ReceiptsController.this.masker.setVisible(true);
                                });
                                try {
                                    Platform.runLater(() -> ReceiptsController.this.masker.setVisible(true));
                                    ReceiptsController.this.newReceipt.setDisable(true);
                                    ReceiptsController.this.editReceipt.setDisable(true);
                                    ReceiptsController.this.deleteReceipt.setDisable(true);
                                    ReceiptsController.this.refresh.setDisable(true);
                                    ReceiptsController.this.postReceipt.setDisable(true);
                                    XSSFWorkbook wb = new XSSFWorkbook(file);
                                    XSSFSheet ws = wb.getSheetAt(0);
                                    int i = 0;
                                    int y = ws.getPhysicalNumberOfRows();
                                    int errors = 0;
                                    for (int a = 1; a < y; ++a) {
                                        Cell myCell;
                                        int j = ++i;
                                        int limit = y;
                                        this.updateProgress(i, limit);
                                        Platform.runLater(() -> ReceiptsController.this.masker.setText(" Importing " + Config.formatNumber(j) + "  of " + Config.formatNumber(limit)));
                                        String memberNo = "";
                                        String date = "";
                                        double amount = 0.0;
                                        String loanNo = "";
                                        XSSFRow myRow = ws.getRow(a);
                                        try {
                                            myCell = myRow.getCell(0);
                                            memberNo = myCell.toString();
                                            memberNo = memberNo.replace(".0", "");
                                        }
                                        catch (Exception t) {
                                            ++errors;
                                            continue;
                                        }
                                        try {
                                            myCell = myRow.getCell(2);
                                            date = myCell.toString();
                                            date = Config.excelDateToDate(date);
                                            Config.stringToLocalDate(date);
                                        }
                                        catch (Exception t) {
                                            t.printStackTrace();
                                            ++errors;
                                            continue;
                                        }
                                        try {
                                            myCell = myRow.getCell(3);
                                            amount = Double.parseDouble(myCell.toString());
                                        }
                                        catch (Exception t) {
                                            ++errors;
                                            continue;
                                        }
                                        try {
                                            myCell = myRow.getCell(4);
                                            loanNo = myCell.toString();
                                        }
                                        catch (Exception t) {
                                            ++errors;
                                            continue;
                                        }
                                        if (amount == 0.0) continue;
                                        try {
                                            NumberSeries ns = new NumberSeries(3, ReceiptsController.this.getUser());
                                            String receiptNo = ns.getNextNumber();
                                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                            params.put("receiptNo", receiptNo);
                                            params.put("memberNo", memberNo);
                                            params.put("date", date);
                                            params.put("amount", amount);
                                            params.put("loanNo", loanNo);
                                            String response = Config.loadDataFromPhp("mastercreate?type=loanreceipts", params, ReceiptsController.this.getUser());
                                            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                                            if (!jr.isStatus()) {
                                                throw new Exception();
                                            }
                                            ns.updateLastUsed(receiptNo);
                                            continue;
                                        }
                                        catch (Exception u) {
                                            ++errors;
                                        }
                                    }
                                    ReceiptsController.this.newReceipt.setDisable(false);
                                    ReceiptsController.this.editReceipt.setDisable(false);
                                    ReceiptsController.this.deleteReceipt.setDisable(false);
                                    ReceiptsController.this.refresh.setDisable(false);
                                    ReceiptsController.this.postReceipt.setDisable(false);
                                    ReceiptsController.this.loadReceipts();
                                    int myErrors = errors;
                                    Platform.runLater(() -> {
                                        if (myErrors > 0) {
                                            ReceiptsController.this.notificationPane.setText(myErrors + " Errors were found and the records were not imported");
                                            ReceiptsController.this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                                            ReceiptsController.this.notificationPane.show();
                                        }
                                        ReceiptsController.this.masker.setText("Please wait");
                                        ReceiptsController.this.masker.setVisible(false);
                                    });
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                return null;
                            }
                        };
                        Thread backgroundThread = new Thread((Runnable)task);
                        backgroundThread.setDaemon(true);
                        this.masker.progressProperty().bind((ObservableValue)task.progressProperty());
                        backgroundThread.start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        });
    }

    public void loadReceipts() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> ReceiptsController.this.masker.setVisible(true));
                    ObservableList<Receipt> allreceiptsUnposted = new Receipt().getAllReceipts(ReceiptsController.this.isPosted(), ReceiptsController.this.isReversed(), ReceiptsController.this.getUser());
                    ReceiptsController.this.toSearch = new Receipt().getAllReceipts(ReceiptsController.this.isPosted(), ReceiptsController.this.isReversed(), ReceiptsController.this.getUser());
                    ReceiptsController.this.receipts.setItems(allreceiptsUnposted);
                    Platform.runLater(() -> ReceiptsController.this.masker.setVisible(false));
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void editReceipt(Receipt receipt) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/receipt.fxml").openStream());
            Scene scene = new Scene((Parent)itemPane);
            Stage stage = new Stage();
            stage.setScene(scene);
            ReceiptController controller = (ReceiptController)loader.getController();
            controller.setUser(this.getUser());
            controller.setReceipt(receipt);
            stage.setTitle("Edit Receipt");
            stage.setResizable(false);
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ReceiptsController.this.loadReceipts();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit receipt screen. Please contact support");
            alert.showAndWait();
        }
    }
}

