/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.Loan;
import classes.Member;
import classes.NumberSeries;
import classes.PaymentMethod;
import classes.Receipt;
import classes.ReceiptLine;
import classes.TransactionTypes;
import classes.User;
import classes.Vehicle;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ReceiptController
implements Initializable {
    private User user;
    private Receipt receipt;
    @FXML
    AnchorPane holder;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private TableView<ReceiptLine> receiptLine;
    @FXML
    private TextField lineAmount;
    @FXML
    private Button addLine;
    @FXML
    private TableColumn columnTransactionType;
    @FXML
    private TableColumn columnDelete;
    @FXML
    private ComboBox<TransactionTypes> transactionType;
    @FXML
    private TableColumn columnloanNo;
    @FXML
    private TableColumn columnVehicle;
    @FXML
    private TableColumn columnAmount;
    @FXML
    private Label receiptNumber;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private Hyperlink userName;
    @FXML
    private Hyperlink amount;
    @FXML
    private DatePicker paymentDate;
    @FXML
    private TextField externalRefNo;
    @FXML
    private Button save;
    @FXML
    private JFXButton postReceipt;
    @FXML
    private JFXButton reverse;
    @FXML
    private JFXButton deleteReceipt;
    @FXML
    private JFXButton refresh;
    @FXML
    private ComboBox<Member> myMember;
    @FXML
    private ComboBox<Loan> loan;
    @FXML
    private ComboBox<PaymentMethod> paymentMethod;
    @FXML
    private ComboBox<Vehicle> vehicle;
    @FXML
    Button chooseMember;
    @FXML
    private TextField receivedFrom;
    public static TableView<ReceiptLine> myLines = new TableView();
    public static Hyperlink myAmount = new Hyperlink();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.userName.setText(user.getUserName());
        ObservableList<Bank> allbanks = Bank.getAllBanks(this.getUser());
        this.bank.setItems(allbanks);
        this.myMember.setItems(new Member().getAllMembers(this.getUser()));
        ObservableList<PaymentMethod> allPaymentmethods = new PaymentMethod().getAllPaymentMethods(this.getUser());
        this.paymentMethod.setItems(allPaymentmethods);
        ObservableList<TransactionTypes> allTransactionTypes = new TransactionTypes().getTransactionTypes(1, this.getUser());
        this.transactionType.setItems(allTransactionTypes);
        this.loadLines();
    }

    public Receipt getReceipt() {
        return this.receipt;
    }

    public void setReceipt(Receipt receipt) {
        this.receiptNumber.setText(receipt.getReceiptNo());
        this.bank.setValue((Object)receipt.getBank());
        this.amount.setText(receipt.getAmount() + "");
        try {
            LocalDate localDate = LocalDate.parse(receipt.getPaymentDate());
            this.paymentDate.setValue((Object)localDate);
        }
        catch (Exception localDate) {
            // empty catch block
        }
        this.externalRefNo.setText(receipt.getExternalRefNo());
        this.receivedFrom.setText(receipt.getReceivedFrom());
        this.receipt = receipt;
        ObservableList allMembers = this.myMember.getItems();
        for (int a = 0; a < allMembers.size(); ++a) {
            if (!((Member)allMembers.get(a)).getMemberNumber().equals(receipt.getMember().getMemberNumber())) continue;
            this.myMember.getSelectionModel().select(a);
        }
        try {
            this.vehicle.setItems(new Vehicle().getMemberVehicles(((Member)this.myMember.getValue()).getMemberNumber(), this.getUser()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.loan.setItems(new Loan().getAllLoans(true, ((Member)this.myMember.getValue()).getMemberNumber(), this.getUser()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.paymentMethod.setValue((Object)receipt.getPaymentMethod());
        this.loadLines();
        if (receipt.isPosted()) {
            this.postReceipt.setDisable(true);
            this.save.setDisable(true);
            this.deleteReceipt.setDisable(true);
            this.reverse.setDisable(false);
        }
        if (receipt.isReversed()) {
            this.postReceipt.setDisable(true);
            this.save.setDisable(true);
            this.deleteReceipt.setDisable(true);
            this.reverse.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        myLines = this.receiptLine;
        myAmount = this.amount;
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.save.setOnAction(e -> this.save());
        this.myMember.setOnAction(e -> {
            this.vehicle.setItems(new Vehicle().getMemberVehicles(((Member)this.myMember.getValue()).getMemberNumber(), this.getUser()));
            this.loan.setItems(new Loan().getAllLoans(true, ((Member)this.myMember.getValue()).getMemberNumber(), this.getUser()));
            this.loadLines();
        });
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator(this.transactionType, Validator.createEmptyValidator((String)"Transaction Type is required"));
        validationSupport.registerValidator((Control)this.lineAmount, Validator.createEmptyValidator((String)"Line amount is required"));
        this.addLine.setOnAction(e -> {
            String lAmount;
            this.notificationPane.hide();
            boolean error = false;
            String message = "";
            try {
                TransactionTypes tt = (TransactionTypes)this.transactionType.getValue();
                if (tt.getTransactionTypeCode().equals(null)) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = "Please select a transaction type";
            }
            try {
                lAmount = this.lineAmount.getText().trim();
                Double.parseDouble(lAmount);
            }
            catch (Exception t) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid line amount";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            } else if (this.save()) {
                lAmount = this.lineAmount.getText().trim();
                double myAmount = Double.parseDouble(lAmount);
                TransactionTypes tt = (TransactionTypes)this.transactionType.getValue();
                String tCode = tt.getTransactionTypeCode();
                String tLoanNo = "";
                try {
                    tLoanNo = ((Loan)this.loan.getValue()).getLoanNumber();
                    if (tLoanNo.equals("") || tLoanNo.equals(null)) {
                        tLoanNo = "";
                    }
                }
                catch (Exception t) {
                    tLoanNo = "";
                }
                String tVehicle = "";
                try {
                    tVehicle = ((Vehicle)this.vehicle.getValue()).getRegNo();
                    if (tVehicle.equals("") || tVehicle.equals(null)) {
                        tVehicle = "";
                    }
                }
                catch (Exception t) {
                    tVehicle = "";
                }
                this.addLine(tCode, tLoanNo, myAmount, tVehicle);
            }
        });
        this.chooseMember.setOnAction(e -> {
            try {
                Member mMember = new Member().getMemberFromSelection(this.getUser());
                ObservableList sMembers = this.myMember.getItems();
                for (int a = 0; a < sMembers.size(); ++a) {
                    if (!((Member)sMembers.get(a)).getMemberNumber().equals(mMember.getMemberNumber())) continue;
                    this.myMember.getSelectionModel().select(a);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.amount.setText("0");
        this.columnTransactionType.setCellValueFactory((Callback)new PropertyValueFactory("transactionType"));
        this.columnAmount.setCellValueFactory((Callback)new PropertyValueFactory("formattedAmount"));
        this.columnVehicle.setCellValueFactory((Callback)new PropertyValueFactory("vehicle"));
        this.columnloanNo.setCellValueFactory((Callback)new PropertyValueFactory("loan"));
        this.columnDelete.setCellValueFactory((Callback)new PropertyValueFactory("delete"));
        this.postReceipt.setOnAction(t -> {
            block6: {
                if (this.save()) {
                    try {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the receipt results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post receipt number " + this.receiptNumber.getText() + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block6;
                        try {
                            JsonResponses jr = new Receipt().postReceipt(this.receiptNumber.getText(), this.getUser());
                            if (jr.isStatus()) {
                                Stage stage = (Stage)this.deleteReceipt.getScene().getWindow();
                                stage.close();
                                break block6;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                            this.notificationPane.show();
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.reverse.setOnAction(t -> {
            block5: {
                try {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Confirm Receipt Reversal");
                    alert.setHeaderText("Reversing  receipt results in a change in the financial position. ");
                    alert.setContentText("Are you sure you want to reverse receipt number " + this.receiptNumber.getText() + "?");
                    Optional result = alert.showAndWait();
                    if (result.get() != ButtonType.OK) break block5;
                    try {
                        JsonResponses jr = new Receipt().reverseReceipt(this.receiptNumber.getText(), this.getUser());
                        if (jr.isStatus()) {
                            Stage stage = (Stage)this.reverse.getScene().getWindow();
                            stage.close();
                            break block5;
                        }
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.show();
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.deleteReceipt.setOnAction(e -> {
            try {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Confirm Delete");
                alert.setHeaderText("Deleting the item will result to loss of data. ");
                alert.setContentText("Are you sure you want to delete receipt number " + this.receipt.getReceiptNo() + "?");
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK && new Receipt().deleteReceipt(this.receiptNumber.getText().trim(), this.getUser())) {
                    try {
                        Stage stage = (Stage)this.deleteReceipt.getScene().getWindow();
                        stage.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public boolean save() {
        boolean newReceipt = false;
        NumberSeries ns = new NumberSeries(3, this.getUser());
        if (this.receiptNumber.getText().equals("") || this.receiptNumber.getText().equals(null)) {
            String lastNo = ns.getNextNumber();
            this.receiptNumber.setText(lastNo);
            newReceipt = true;
        }
        String tReceiptNumber = this.receiptNumber.getText();
        Member tMember = (Member)this.myMember.getValue();
        String mMemberNo = "";
        try {
            mMemberNo = tMember.equals(null) ? "" : tMember.getMemberNumber();
        }
        catch (NullPointerException y) {
            mMemberNo = "";
        }
        Vehicle tVehicle = (Vehicle)this.vehicle.getValue();
        String tVehicleNumber = "";
        try {
            tVehicleNumber = tVehicle.equals(null) ? "" : tVehicle.getFleetNumber();
        }
        catch (NullPointerException y) {
            tVehicleNumber = "";
        }
        Bank tBank = (Bank)this.bank.getValue();
        int bankCode = 0;
        try {
            bankCode = tBank.equals(null) ? 0 : tBank.getCode();
        }
        catch (NullPointerException t) {
            bankCode = 0;
        }
        PaymentMethod pMethod = (PaymentMethod)this.paymentMethod.getValue();
        int myPayMethod = 0;
        try {
            myPayMethod = pMethod.equals(null) ? 0 : pMethod.getCode();
        }
        catch (NullPointerException u) {
            myPayMethod = 0;
        }
        Date tPaymentDate = null;
        String tExternalRefNo = this.externalRefNo.getText().trim();
        try {
            LocalDate localDate = (LocalDate)this.paymentDate.getValue();
            Instant instant = Instant.from(localDate.atStartOfDay(ZoneId.systemDefault()));
            tPaymentDate = new Date(Date.from(instant).getTime());
        }
        catch (NullPointerException localDate) {
            // empty catch block
        }
        String tReceivedFrom = this.receivedFrom.getText().trim();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("memberNo", mMemberNo);
        params.put("bankCode", bankCode);
        params.put("payMethod", myPayMethod);
        params.put("externalRef", tExternalRefNo);
        params.put("paymentDate", tPaymentDate);
        params.put("receivedFrom", tReceivedFrom);
        params.put("receiptNumber", tReceiptNumber);
        String response = Config.loadDataFromPhp("mastercreate?type=receipt", params, this.getUser());
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            if (newReceipt) {
                ns.updateLastUsed(tReceiptNumber);
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)Config.getCheckIcon());
            this.notificationPane.show();
            return true;
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
        this.notificationPane.show();
        return false;
    }

    public void loadLines() {
        ObservableList<ReceiptLine> allLines = new ReceiptLine().getAllReceiptLines(this.receiptNumber.getText(), this.getUser());
        double total = 0.0;
        for (int a = 0; a < allLines.size(); ++a) {
            total += ((ReceiptLine)allLines.get(a)).getAmount();
        }
        this.amount.setText(Config.formatNumber(total));
        this.receiptLine.setItems(allLines);
    }

    public void addLine(String myTransactionType, String loanNo, double lAmount, String vRegNo) {
        try {
            String rNo = this.receiptNumber.getText();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("receiptNo", rNo);
            params.put("transactionType", myTransactionType);
            params.put("loanNo", loanNo);
            params.put("amount", lAmount);
            params.put("vehicle", vRegNo);
            String response = Config.loadDataFromPhp("mastercreate?type=receiptline", params, this.getUser());
            Gson g = new Gson();
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.show();
                this.loan.setValue(null);
                this.transactionType.setValue(null);
                this.lineAmount.setText("");
                this.vehicle.setValue(null);
                this.loadLines();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
        catch (Exception e) {
            this.notificationPane.setText("We encountered an error while adding the receipt line. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }
}

