/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.User;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class ProfitAndLossController
implements Initializable {
    private User user;
    @FXML
    private DatePicker fromDate;
    @FXML
    private DatePicker toDate;
    @FXML
    private Button generate;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableView<ObservableList<String>> allEntries;
    @FXML
    private MaskerPane masker;
    @FXML
    private Button exportToExcel;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.stackPane);
        this.generate.setOnAction(e -> {
            String tToDate;
            String tFromDate;
            try {
                this.allEntries.getColumns().removeAll((Collection)this.allEntries.getColumns());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tFromDate = Config.localDateToString((LocalDate)this.fromDate.getValue());
            }
            catch (Exception p) {
                tFromDate = "";
            }
            try {
                tToDate = Config.localDateToString((LocalDate)this.toDate.getValue());
            }
            catch (Exception p) {
                tToDate = "";
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("fromDate", tFromDate);
            params.put("toDate", tToDate);
            String response = Config.loadDataFromPhp("masterfetch?type=salesreppnl", params, this.getUser());
            System.out.println(response);
            Gson gson = new Gson();
            Map tResponse = (Map)gson.fromJson(response, Map.class);
            ObservableList myResponse = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(tResponse.get("repNames").toString(), Map[].class)));
            ArrayList myEntries = (ArrayList)gson.fromJson(tResponse.get("final").toString(), ArrayList.class);
            ObservableList parsed = FXCollections.observableArrayList();
            for (ArrayList a : myEntries) {
                ObservableList row = FXCollections.observableArrayList((Collection)a);
                parsed.add((Object)row);
            }
            int noOfRows = myResponse.size() + 2;
            int currentIndex = 0;
            for (Map current : myResponse) {
                try {
                    int i = currentIndex;
                    TableColumn myColumn = new TableColumn();
                    myColumn.setText(current.get("repname").toString());
                    int tIndex = currentIndex;
                    try {
                        myColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(tIndex)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++currentIndex;
                    myColumn.setMinWidth(200.0);
                    myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().divide(noOfRows));
                    this.allEntries.getColumns().add((Object)myColumn);
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            }
            this.allEntries.setItems(parsed);
            this.masker.setVisible(false);
        });
        this.exportToExcel.setOnAction(e -> {
            ObservableList myCustomers = this.allEntries.getItems();
            int size = myCustomers.size();
            if (size < 1) {
                this.notificationPane.setText("No data to export in the table. Please click generate first");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                FileChooser fileChooser = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
                fileChooser.getExtensionFilters().add((Object)extFilter);
                Stage stage = (Stage)this.generate.getScene().getWindow();
                File file = fileChooser.showSaveDialog((Window)stage);
                if (file != null) {
                    XSSFWorkbook workbook = new XSSFWorkbook();
                    XSSFSheet sheet = workbook.createSheet("Profit and Loss Statement");
                    XSSFRow header = sheet.createRow(0);
                    int columnIndex = 0;
                    for (TableColumn column : this.allEntries.getColumns()) {
                        header.createCell(columnIndex++).setCellValue(column.getText());
                    }
                    for (int a = 0; a < size; ++a) {
                        ObservableList current = (ObservableList)myCustomers.get(a);
                        int noOfRows = current.size();
                        XSSFRow row = sheet.createRow(a + 1);
                        for (int b = 0; b < noOfRows; ++b) {
                            try {
                                row.createCell(b).setCellValue((String)current.get(b));
                                continue;
                            }
                            catch (Exception u) {
                                row.createCell(b).setCellValue("0");
                            }
                        }
                    }
                    try (FileOutputStream outputStream = new FileOutputStream(file);){
                        workbook.write((OutputStream)outputStream);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.notificationPane.setText("Your excel document was successfully generated");
                    this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                    this.notificationPane.show();
                }
            }
        });
    }
}

