/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.CustomerReceipt;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class PrepaymentsController
implements Initializable {
    private User user;
    private CustomerReceipt receipt;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label voucherNo;
    @FXML
    private DatePicker paymentDate;
    @FXML
    private ComboBox<Customer> customer;
    @FXML
    private Button searchCustomer;
    @FXML
    private ComboBox<Bank> paymentMethod;
    @FXML
    private TextField amount;
    @FXML
    private TextField transactionRef;
    @FXML
    private Button post;

    public CustomerReceipt getReceipt() {
        return this.receipt;
    }

    public void setReceipt(CustomerReceipt receipt) {
        this.receipt = receipt;
        this.post.setDisable(true);
        this.voucherNo.setText(receipt.getReceiptNo());
        this.paymentDate.setValue((Object)Config.stringToLocalDate(receipt.getPaymentDate()));
        this.customer.setValue((Object)receipt.getCustomer());
        this.paymentMethod.setValue((Object)receipt.getBank());
        this.amount.setText(receipt.getAmountString());
        this.transactionRef.setText(receipt.getExternalRef());
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        this.loadCustomers();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    PrepaymentsController.this.notificationPane.setText("Loading Values. Please wait");
                    PrepaymentsController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    PrepaymentsController.this.notificationPane.show();
                });
                ObservableList<Bank> allBanks = Bank.getAllBanks(user);
                Platform.runLater(() -> {
                    PrepaymentsController.this.paymentMethod.setItems(allBanks);
                    PrepaymentsController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadCustomers() {
        final Node original = this.searchCustomer.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PrepaymentsController.this.searchCustomer.setGraphic((Node)Config.getLoader()));
                ObservableList<Customer> allCustomers = new Customer().getAllCustomers(PrepaymentsController.this.user);
                allCustomers.sort(Comparator.comparing(Customer::getCustomerName));
                Platform.runLater(() -> {
                    PrepaymentsController.this.customer.setItems(allCustomers);
                    PrepaymentsController.this.searchCustomer.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.paymentDate.setValue((Object)Config.getCurrentLocaldate());
        this.post.setOnAction(e -> {
            String tTransactionRef;
            String tPaymentDate = "";
            String tCustomer = "";
            String message = "";
            int tBank = 0;
            double tAmount = 0.0;
            boolean error = false;
            try {
                tPaymentDate = Config.localDateToString((LocalDate)this.paymentDate.getValue());
            }
            catch (Exception ignored) {
                error = true;
                message = "Please select the payment date";
            }
            try {
                tCustomer = ((Customer)this.customer.getValue()).getCustomerNumber();
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select a customer";
            }
            try {
                tTransactionRef = this.transactionRef.getText().trim();
            }
            catch (Exception ignored) {
                tTransactionRef = "";
            }
            try {
                tBank = ((Bank)this.paymentMethod.getValue()).getCode();
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select a payment method";
            }
            try {
                tAmount = Double.parseDouble(this.amount.getText().trim());
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid amount";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("paymentDate", tPaymentDate);
                    params.put("customer", tCustomer);
                    params.put("transactionRef", tTransactionRef);
                    params.put("bank", tBank);
                    params.put("amount", tAmount);
                    String response = Config.loadDataFromPhp("mastercreate?type=prepayment", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.show();
                        ((Stage)this.post.getScene().getWindow()).close();
                    } else {
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.show();
                    }
                }
                catch (Exception ignored) {
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.show();
                }
            }
        });
        this.searchCustomer.setOnAction(e -> {
            Gson gson = new Gson();
            String response = new Config().getObjectFromSelection("customer", gson.toJson((Object)this.customer.getItems()), this.getUser());
            this.customer.setValue(gson.fromJson(response, Customer.class));
        });
    }
}

