/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.JsonResponses;
import classes.PostingGroup;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class PostingGroupsController
implements Initializable {
    private User user;
    private int category;
    ObservableList<PostingGroup> toSearch = FXCollections.observableArrayList();
    @FXML
    private StackPane holder;
    @FXML
    private JFXButton addPostingGroup;
    @FXML
    private JFXButton editPostingGroup;
    @FXML
    private JFXButton deletePostingGroup;
    @FXML
    private JFXButton refresh;
    @FXML
    private MaskerPane masker;
    @FXML
    private TableView<PostingGroup> allPostingGroups;
    @FXML
    private TableColumn code;
    @FXML
    private TableColumn name;
    @FXML
    private TableColumn glAccount;
    @FXML
    private TableColumn count;
    @FXML
    private TextField search;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
        this.getPostingGroups();
        if (category == 1) {
            this.count.setText("No. of Customers");
        } else if (category == 2) {
            this.count.setText("No. of Vendors");
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.code.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.name.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.glAccount.setCellValueFactory((Callback)new PropertyValueFactory("account"));
        this.count.setCellValueFactory((Callback)new PropertyValueFactory("count"));
        this.refresh.setOnAction(e -> this.getPostingGroups());
        this.addPostingGroup.setOnAction(e -> {
            Dialog dialog = new Dialog();
            dialog.setTitle("Posting Group");
            dialog.setHeaderText("Create a New Posting Group");
            FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.PLUS);
            icon.setStyle("-fx-fill:  #4CAF50;");
            icon.setSize("40.0");
            dialog.setGraphic((Node)icon);
            ButtonType loginButtonType = new ButtonType("Create", ButtonBar.ButtonData.OK_DONE);
            dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{loginButtonType, ButtonType.CANCEL});
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
            TextField groupName = new TextField();
            groupName.setPromptText("Posting Group Name");
            ComboBox cGlAccount = new ComboBox();
            cGlAccount.setPromptText("G/L Account");
            cGlAccount.setItems(Account.getAccounts(this.getUser()));
            grid.add((Node)new Label("Posting Group Name:"), 0, 0);
            grid.add((Node)groupName, 1, 0);
            grid.add((Node)new Label("G/L Account:"), 0, 1);
            grid.add((Node)cGlAccount, 1, 1);
            Node loginButton = dialog.getDialogPane().lookupButton(loginButtonType);
            loginButton.setDisable(true);
            groupName.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty()));
            dialog.getDialogPane().setContent((Node)grid);
            Platform.runLater(() -> groupName.requestFocus());
            dialog.setResultConverter(dialogButton -> {
                if (dialogButton == loginButtonType) {
                    // empty if block
                }
                return null;
            });
            EventHandler filter = event -> {
                String tGroupName = groupName.getText().trim();
                String tAccountNumber = "";
                boolean error = false;
                try {
                    tAccountNumber = ((Account)cGlAccount.getValue()).getAccountNumber();
                }
                catch (Exception t) {
                    this.notificationPane.setText("Please select the G/L Account");
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                    error = true;
                }
                if (!error) {
                    try {
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("category", this.getCategory());
                        params.put("name", tGroupName);
                        params.put("glAccount", tAccountNumber);
                        String response = Config.loadDataFromPhp("mastercreate?type=postinggroup", params, this.getUser());
                        Gson g = new Gson();
                        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                        if (jr.isStatus()) {
                            this.getPostingGroups();
                        }
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                    catch (Exception t) {
                        this.notificationPane.setText("We encountered an error while adding the posting group. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            };
            loginButton.addEventFilter(ActionEvent.ACTION, filter);
            Optional result = dialog.showAndWait();
        });
        this.deletePostingGroup.setOnAction(e -> {
            try {
                PostingGroup pg = (PostingGroup)this.allPostingGroups.getSelectionModel().getSelectedItem();
                int code = pg.getCode();
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("code", code);
                    String response = Config.loadDataFromPhp("masterdelete?type=postinggroup", params, this.getUser());
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        this.getPostingGroups();
                    }
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while deleting the posting group. Please try again later.");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.editPostingGroup.setOnAction(e -> {
            try {
                PostingGroup pg = (PostingGroup)this.allPostingGroups.getSelectionModel().getSelectedItem();
                int code = pg.getCode();
                this.editPostingGroup(pg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            for (int b = 0; b < this.toSearch.size(); ++b) {
                PostingGroup current = (PostingGroup)this.toSearch.get(b);
                String tCode = current.getCode() + "";
                if (!tCode.contains(newValue.toLowerCase()) && !current.getName().toLowerCase().contains(newValue.toLowerCase()) && !current.getAccount().getAccountName().toLowerCase().contains(newValue.toLowerCase())) continue;
                afterSearch.add((Object)current);
            }
            this.allPostingGroups.getItems().removeAll((Collection)this.allPostingGroups.getItems());
            this.allPostingGroups.setItems(afterSearch);
        });
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.getPostingGroups();
        });
    }

    public void getPostingGroups() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            this.allPostingGroups.setItems(new PostingGroup().getAllPostingGroups(this.getCategory(), this.getUser()));
            this.toSearch = new PostingGroup().getAllPostingGroups(this.getCategory(), this.getUser());
            this.masker.setVisible(false);
        });
    }

    public void editPostingGroup(PostingGroup pg) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Posting Group");
        dialog.setHeaderText("Edit Posting Group");
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.EDIT);
        icon.setStyle("-fx-fill:  #4CAF50;");
        icon.setSize("40.0");
        dialog.setGraphic((Node)icon);
        ButtonType loginButtonType = new ButtonType("Edit", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{loginButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 150.0, 10.0, 10.0));
        TextField groupName = new TextField();
        groupName.setPromptText("Posting Group Name");
        groupName.setText(pg.getName());
        ComboBox cGlAccount = new ComboBox();
        cGlAccount.setPromptText("G/L Account");
        cGlAccount.setItems(Account.getAccounts(this.getUser()));
        cGlAccount.setValue((Object)pg.getAccount());
        grid.add((Node)new Label("Posting Group Name:"), 0, 0);
        grid.add((Node)groupName, 1, 0);
        grid.add((Node)new Label("G/L Account:"), 0, 1);
        grid.add((Node)cGlAccount, 1, 1);
        Node loginButton = dialog.getDialogPane().lookupButton(loginButtonType);
        loginButton.setDisable(groupName.getText().trim().isEmpty());
        groupName.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty()));
        dialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> groupName.requestFocus());
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == loginButtonType) {
                // empty if block
            }
            return null;
        });
        EventHandler filter = event -> {
            String tGroupName = groupName.getText().trim();
            String tAccountNumber = "";
            boolean error = false;
            try {
                tAccountNumber = ((Account)cGlAccount.getValue()).getAccountNumber();
            }
            catch (Exception t) {
                this.notificationPane.setText("Please select the G/L Account");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
                error = true;
            }
            if (!error) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("category", this.getCategory());
                    params.put("name", tGroupName);
                    params.put("glAccount", tAccountNumber);
                    params.put("code", pg.getCode());
                    String response = Config.loadDataFromPhp("mastercreate?type=postinggroup", params, this.getUser());
                    System.out.println(response);
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.getPostingGroups();
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception t) {
                    this.notificationPane.setText("We encountered an error while adding the posting group. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                    t.printStackTrace();
                }
            }
        };
        loginButton.addEventFilter(ActionEvent.ACTION, filter);
        Optional result = dialog.showAndWait();
    }
}

