/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.JsonResponses;
import classes.PostingGroup;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class PostingGroupController
implements Initializable {
    private int type = 0;
    private User user;
    private PostingGroup postingGroup;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label groupId;
    @FXML
    private Label glAccountlabel;
    @FXML
    private ComboBox<Account> glAcccount;
    @FXML
    private TextField groupName;
    @FXML
    private Button searchGlAccount;
    @FXML
    private HBox cogHbox;
    @FXML
    private ComboBox<Account> cogAccount;
    @FXML
    private Button searchCOG;
    @FXML
    private HBox revenueHbox;
    @FXML
    private ComboBox<Account> revenueAccount;
    @FXML
    private Button searchRevenueAccount;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    PostingGroupController.this.notificationPane.setText("Loading Values. Please wait");
                    PostingGroupController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    PostingGroupController.this.notificationPane.show();
                });
                try {
                    ObservableList<Account> allAccounts = Account.getAccounts(user);
                    System.out.println(allAccounts);
                    ObservableList assets = FXCollections.observableArrayList((Collection)allAccounts.stream().filter(v -> v.getCategory().getId() == 1).collect(Collectors.toList()));
                    ObservableList liabilities = FXCollections.observableArrayList((Collection)allAccounts.stream().filter(v -> v.getCategory().getId() == 2).collect(Collectors.toList()));
                    ObservableList expenses = FXCollections.observableArrayList((Collection)allAccounts.stream().filter(v -> v.getCategory().getId() == 4).collect(Collectors.toList()));
                    ObservableList incomes = FXCollections.observableArrayList((Collection)allAccounts.stream().filter(v -> v.getCategory().getId() == 3).collect(Collectors.toList()));
                    Platform.runLater(() -> {
                        int myType = PostingGroupController.this.getType();
                        if (myType == 3) {
                            PostingGroupController.this.glAcccount.setItems(allAccounts);
                            PostingGroupController.this.cogAccount.setItems(incomes);
                            PostingGroupController.this.revenueAccount.setItems(incomes);
                        } else if (myType == 1) {
                            PostingGroupController.this.glAcccount.setItems(assets);
                        } else if (myType == 2) {
                            PostingGroupController.this.glAcccount.setItems(liabilities);
                        }
                        PostingGroupController.this.notificationPane.hide();
                    });
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public PostingGroup getPostingGroup() {
        return this.postingGroup;
    }

    public void setPostingGroup(PostingGroup postingGroup) {
        this.postingGroup = postingGroup;
        this.groupId.setText(postingGroup.getCode() + "");
        this.groupName.setText(postingGroup.getName());
        try {
            this.glAcccount.setValue((Object)postingGroup.getAccount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.cogAccount.setValue((Object)postingGroup.getCOGAccount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.revenueAccount.setValue((Object)postingGroup.getRevenueAccount());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        if (type == 3) {
            this.cogHbox.setVisible(true);
            this.revenueHbox.setVisible(true);
            this.glAccountlabel.setText("Inventory GL Account:");
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.revenueHbox.managedProperty().bind((ObservableValue)this.revenueHbox.visibleProperty());
        this.cogHbox.managedProperty().bind((ObservableValue)this.cogHbox.visibleProperty());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.groupName, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.glAcccount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cogAccount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.revenueAccount, Validator.createEmptyValidator((String)"Required"));
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        Gson gson = new Gson();
        this.searchCOG.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.cogAccount.getItems()), this.getUser());
                Account selected = (Account)gson.fromJson(response, Account.class);
                selected.getAccountNumber();
                this.cogAccount.setValue((Object)selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchGlAccount.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.glAcccount.getItems()), this.getUser());
                Account selected = (Account)gson.fromJson(response, Account.class);
                selected.getAccountNumber();
                this.glAcccount.setValue((Object)selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchRevenueAccount.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.revenueAccount.getItems()), this.getUser());
                Account selected = (Account)gson.fromJson(response, Account.class);
                selected.getAccountNumber();
                this.revenueAccount.setValue((Object)selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.save.setOnAction(e -> {
            boolean error = false;
            String message = "";
            int tGroupId = 0;
            int selectedType = this.getType();
            String tGroupName = "";
            String tGLAccount = "";
            String tCOGAccount = "";
            String tRevenueAccount = "";
            try {
                tGroupId = Integer.parseInt(this.groupId.getText().trim());
            }
            catch (Exception u) {
                tGroupId = 0;
            }
            try {
                tGroupName = this.groupName.getText().trim();
                if (tGroupName.length() < 3) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = "Please enter a posting group name";
            }
            try {
                tGLAccount = ((Account)this.glAcccount.getValue()).getAccountNumber();
            }
            catch (Exception u) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = selectedType != 3 ? message + "Please select the G/L Account" : message + "Please select the inventory G/L Account";
            }
            if (selectedType == 3) {
                try {
                    tCOGAccount = ((Account)this.cogAccount.getValue()).getAccountNumber();
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the COG G/L Account";
                }
                try {
                    tRevenueAccount = ((Account)this.revenueAccount.getValue()).getAccountNumber();
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the Revenue G/L Account";
                }
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("code", tGroupId);
                    params.put("category", selectedType);
                    params.put("name", tGroupName);
                    params.put("glAccount", tGLAccount);
                    params.put("cogAccount", tCOGAccount);
                    params.put("revenueAccount", tRevenueAccount);
                    String url = tGroupId > 0 ? "masterupdate" : "mastercreate";
                    String response = Config.loadDataFromPhp(url + "?type=postinggroups", params, this.getUser());
                    System.out.println(response);
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        ((Stage)this.save.getScene().getWindow()).close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
                catch (Exception y) {
                    y.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }
}

