/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.PettyCashVoucher;
import classes.User;
import com.jfoenix.controls.JFXButton;
import controllers.PettyCashVoucherController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class PettyCashVouchersController
implements Initializable {
    private User user;
    private boolean posted;
    private boolean reversed;
    @FXML
    private VBox root;
    @FXML
    NotificationPane notificationPane;
    @FXML
    StackPane stackPane;
    @FXML
    private JFXButton newPCV;
    @FXML
    private JFXButton editPCV;
    @FXML
    private JFXButton deletePCV;
    @FXML
    private JFXButton voucher;
    @FXML
    private JFXButton refresh;
    @FXML
    private TextField search;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private TableView<PettyCashVoucher> allPCVs;
    @FXML
    private TableColumn pcvNo;
    @FXML
    private TableColumn bank;
    @FXML
    private TableColumn createdOn;
    @FXML
    private TableColumn total;
    @FXML
    private MaskerPane masker;
    ObservableList<PettyCashVoucher> toSearch = FXCollections.observableArrayList();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        if (posted) {
            this.newPCV.setDisable(true);
            this.deletePCV.setDisable(true);
        }
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loadItems();
        this.pcvNo.setCellValueFactory((Callback)new PropertyValueFactory("pcvNo"));
        this.bank.setCellValueFactory((Callback)new PropertyValueFactory("bank"));
        this.createdOn.setCellValueFactory((Callback)new PropertyValueFactory("pcvDate"));
        this.total.setCellValueFactory((Callback)new PropertyValueFactory("totalString"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.notificationPane.setContent((Node)this.stackPane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.deletePCV.setOnAction(e -> {
            try {
                String tPCVNo = ((PettyCashVoucher)this.allPCVs.getSelectionModel().getSelectedItem()).getPcvNo();
                JsonResponses jr = new PettyCashVoucher().deleteVoucher(tPCVNo, this.getUser());
                if (jr.isStatus()) {
                    this.loadItems();
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("")) {
                try {
                    this.loadItems();
                }
                catch (Exception exception) {}
            } else {
                String searchString = this.search.getText().trim().toLowerCase();
                ObservableList afterSearch = FXCollections.observableArrayList();
                for (PettyCashVoucher current : this.toSearch) {
                    String tPcvNo = current.getPcvNo().toLowerCase();
                    String tBank = "";
                    try {
                        tBank = current.getBank().toString().toLowerCase();
                    }
                    catch (Exception e) {
                        tBank = "";
                    }
                    String tDateCreated = current.getCreatedOn();
                    String tAmount = current.getTotal() + "";
                    String mTotal = current.getTotalString();
                    if (!tPcvNo.contains(searchString) && !tBank.contains(searchString) && !tDateCreated.contains(searchString) && !tAmount.contains(searchString) && !mTotal.contains(searchString)) continue;
                    afterSearch.add((Object)current);
                }
                this.allPCVs.getItems().clear();
                this.allPCVs.setItems(afterSearch);
            }
        });
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadItems();
        });
        this.newPCV.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/pettycashcard.fxml").openStream());
                PettyCashVoucherController controller = (PettyCashVoucherController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("New Petty Cash Voucher");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                PettyCashVouchersController.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.allPCVs.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    PettyCashVoucher rowData = (PettyCashVoucher)row.getItem();
                    PettyCashVoucher pettyCashVoucher = (PettyCashVoucher)this.allPCVs.getSelectionModel().getSelectedItem();
                    if (!pettyCashVoucher.equals(null)) {
                        this.editVoucher(pettyCashVoucher);
                    }
                }
            });
            return row;
        });
        this.voucher.setOnAction(r -> {
            try {
                PettyCashVoucher xm = (PettyCashVoucher)this.allPCVs.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getPcvNo().equals("")) {
                    this.generateVoucher(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.editPCV.setOnAction(r -> {
            try {
                PettyCashVoucher xm = (PettyCashVoucher)this.allPCVs.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getPcvNo().equals("")) {
                    this.editVoucher(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    public void loadItems() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            ObservableList<PettyCashVoucher> allVouchers = new PettyCashVoucher().getAllVouchers(this.isPosted(), this.isReversed(), this.getUser());
            this.allPCVs.setItems(allVouchers);
            this.toSearch = new PettyCashVoucher().getAllVouchers(this.isPosted(), this.isReversed(), this.getUser());
            this.masker.setVisible(false);
        });
    }

    public void generateVoucher(PettyCashVoucher pettyCashVoucher) {
        LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
        dataParams.put("pcvNo", pettyCashVoucher.getPcvNo());
        LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
        reportParams.put("saccoName", Config.saccoName);
        reportParams.put("chequeNo", pettyCashVoucher.getRefNo());
        reportParams.put("bank", pettyCashVoucher.getBank().toString());
        reportParams.put("pcvDate", pettyCashVoucher.getPcvDate());
        reportParams.put("pcvNo", pettyCashVoucher.getPcvNo());
        new Config().getReport("Petty Cash Voucher", "masterfetch?type=pcvlines", dataParams, "pettycashvoucher.jasper", reportParams, this.getUser());
    }

    public void editVoucher(PettyCashVoucher pettyCashVoucher) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/pettycashcard.fxml").openStream());
            Scene editVoucher = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
            final Stage stage = new Stage();
            editVoucher.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editVoucher);
            PettyCashVoucherController controller = (PettyCashVoucherController)loader.getController();
            controller.setUser(this.getUser());
            controller.setPcv(pettyCashVoucher);
            stage.setTitle("Edit Petty Cash Voucher");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PettyCashVouchersController.this.loadItems();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit petty cash voucher screen. Please contact support");
            alert.showAndWait();
        }
    }
}

