/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.ChargeItem;
import classes.Config;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.PettyCashVoucher;
import classes.PettyCashVoucherLines;
import classes.Region;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class PettyCashVoucherController
implements Initializable {
    private User user;
    private PettyCashVoucher pcv;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private MaskerPane masker;
    @FXML
    private VBox holder;
    @FXML
    private Label pcvNo;
    @FXML
    private DatePicker pcvDate;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private Label pcvTotal;
    @FXML
    private ComboBox<ChargeItem> chargeItem;
    @FXML
    private TextField amount;
    @FXML
    private JFXButton addLine;
    @FXML
    private TableView<PettyCashVoucherLines> allItems;
    @FXML
    private TableColumn itemCode;
    @FXML
    private TableColumn itemDescription;
    @FXML
    private TableColumn colKilometres;
    @FXML
    private TableColumn colVehicle;
    @FXML
    private TableColumn colAmount;
    @FXML
    private TableColumn delete;
    @FXML
    private JFXButton postPCV;
    @FXML
    private JFXButton deletePCV;
    @FXML
    private JFXButton reverse;
    @FXML
    private JFXButton savePCV;
    @FXML
    private TextField externalRefNo;
    @FXML
    private ComboBox<Region> region;
    @FXML
    private ComboBox<User> salesRep;
    @FXML
    private TextField description;
    @FXML
    private TextField payee;
    @FXML
    private VBox kilometresVBox;
    @FXML
    private TextField kilometres;
    @FXML
    private VBox vehicleVBox;
    @FXML
    private Button searchBank;
    @FXML
    private Button searchItem;
    @FXML
    private VBox regionVBox;
    @FXML
    private VBox salesRepVBox;
    @FXML
    private Button searchVSM;
    @FXML
    private ComboBox<FixedAssets> vehicle;
    @FXML
    private Button searchFixedAsset;
    @FXML
    private TableColumn colRegion;
    @FXML
    private TableColumn colSalesRep;

    public User getUser() {
        return this.user;
    }

    private void loadBanks() {
        final Node original = this.searchBank.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    ProgressIndicator loader = new ProgressIndicator();
                    loader.setPrefWidth(15.0);
                    loader.setPrefHeight(15.0);
                    PettyCashVoucherController.this.searchBank.setGraphic((Node)loader);
                });
                ObservableList<Bank> allBanks = Bank.getAllBanks(PettyCashVoucherController.this.getUser());
                Platform.runLater(() -> {
                    PettyCashVoucherController.this.bank.setItems(allBanks);
                    PettyCashVoucherController.this.searchBank.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadItems() {
        final Node original = this.searchItem.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    ProgressIndicator loader = new ProgressIndicator();
                    loader.setPrefWidth(15.0);
                    loader.setPrefHeight(15.0);
                    PettyCashVoucherController.this.searchItem.setGraphic((Node)Config.getLoader());
                });
                ObservableList<ChargeItem> allItems = new ChargeItem().getChargeItems(3, PettyCashVoucherController.this.getUser());
                Platform.runLater(() -> {
                    PettyCashVoucherController.this.chargeItem.setItems(allItems);
                    PettyCashVoucherController.this.searchItem.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadAssets() {
        final Node original = this.searchFixedAsset.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    ProgressIndicator loader = new ProgressIndicator();
                    loader.setPrefWidth(15.0);
                    loader.setPrefHeight(15.0);
                    PettyCashVoucherController.this.searchFixedAsset.setGraphic((Node)Config.getLoader());
                });
                ObservableList<FixedAssets> allAssets = new FixedAssets().getAllAssets(true, PettyCashVoucherController.this.getUser());
                Platform.runLater(() -> {
                    PettyCashVoucherController.this.vehicle.setItems(allAssets);
                    PettyCashVoucherController.this.searchFixedAsset.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadSalesReps() {
        final Node original = this.searchVSM.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PettyCashVoucherController.this.searchVSM.setGraphic((Node)Config.getLoader()));
                ObservableList<User> allPeps = new User().getAllUsers(true, PettyCashVoucherController.this.user);
                Platform.runLater(() -> {
                    PettyCashVoucherController.this.salesRep.setItems(allPeps);
                    PettyCashVoucherController.this.searchVSM.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadRegions() {
        Node original = this.searchVSM.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                ObservableList<Region> allRegions = new Region().getAllRegions(PettyCashVoucherController.this.user);
                Platform.runLater(() -> PettyCashVoucherController.this.region.setItems(allRegions));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void setUser(User user) {
        this.user = user;
        this.loadBanks();
        this.loadItems();
        this.loadAssets();
        this.loadSalesReps();
        this.loadRegions();
    }

    public PettyCashVoucher getPcv() {
        return this.pcv;
    }

    public void setPcv(PettyCashVoucher pcv) {
        this.pcv = pcv;
        try {
            this.pcvNo.setText(pcv.getPcvNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.externalRefNo.setText(pcv.getRefNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pcvDate.setValue((Object)Config.stringToLocalDate(pcv.getPcvDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bank.setValue((Object)pcv.getBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.payee.setText(pcv.getPayee());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadLines();
        if (pcv.isPosted()) {
            this.bank.setDisable(true);
            this.chargeItem.setDisable(true);
            this.amount.setDisable(true);
            this.addLine.setDisable(true);
            this.delete.setVisible(false);
            this.postPCV.setDisable(true);
            this.deletePCV.setDisable(true);
            this.savePCV.setDisable(true);
            this.externalRefNo.setDisable(true);
            this.pcvDate.setDisable(true);
            this.reverse.setDisable(false);
        }
        if (pcv.isReversed()) {
            this.reverse.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        PrefixSelectionCustomizer.customize(this.vehicle);
        PrefixSelectionCustomizer.customize(this.salesRep);
        PrefixSelectionCustomizer.customize(this.chargeItem);
        PrefixSelectionCustomizer.customize(this.region);
        this.regionVBox.managedProperty().bind((ObservableValue)this.regionVBox.visibleProperty());
        this.salesRepVBox.managedProperty().bind((ObservableValue)this.salesRepVBox.visibleProperty());
        this.vehicleVBox.managedProperty().bind((ObservableValue)this.vehicleVBox.visibleProperty());
        this.kilometresVBox.managedProperty().bind((ObservableValue)this.kilometresVBox.visibleProperty());
        this.masker.setVisible(false);
        this.pcvDate.setValue((Object)Config.getCurrentLocaldate());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.bank, Validator.createEmptyValidator((String)"Please select bank"));
        vs.registerValidator(this.chargeItem, Validator.createEmptyValidator((String)"Please select an item"));
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Please enter an amount"));
        this.chargeItem.setOnAction(e -> {
            try {
                ChargeItem selection = (ChargeItem)this.chargeItem.getValue();
                this.description.setText(selection.getName());
                if (selection.isRequireFixedAsset()) {
                    this.vehicleVBox.setVisible(true);
                    this.kilometresVBox.setVisible(true);
                } else {
                    this.vehicleVBox.setVisible(false);
                    this.kilometresVBox.setVisible(false);
                }
                if (selection.isRequireVSM()) {
                    this.salesRepVBox.setVisible(true);
                } else {
                    this.salesRepVBox.setVisible(false);
                }
                if (selection.isRequireRegion()) {
                    this.regionVBox.setVisible(true);
                } else {
                    this.regionVBox.setVisible(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.deletePCV.setOnAction(e -> {
            String tPCVNo = this.pcvNo.getText().trim();
            if (!tPCVNo.equals("")) {
                JsonResponses jr = new PettyCashVoucher().deleteVoucher(tPCVNo, this.getUser());
                if (jr.isStatus()) {
                    Stage stage = (Stage)this.deletePCV.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            } else {
                Stage stage = (Stage)this.deletePCV.getScene().getWindow();
                stage.close();
            }
        });
        this.savePCV.setOnAction(e -> this.save());
        this.postPCV.setOnAction(e -> {
            if (this.post()) {
                Stage stage = (Stage)this.postPCV.getScene().getWindow();
                stage.close();
            }
        });
        this.reverse.setOnAction(e -> {
            if (this.reverse()) {
                Stage stage = (Stage)this.reverse.getScene().getWindow();
                stage.close();
            }
        });
        this.itemCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.itemDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.colKilometres.setCellValueFactory((Callback)new PropertyValueFactory("kilometres"));
        this.colVehicle.setCellValueFactory((Callback)new PropertyValueFactory("vehicle"));
        this.colRegion.setCellValueFactory((Callback)new PropertyValueFactory("region"));
        this.colSalesRep.setCellValueFactory((Callback)new PropertyValueFactory("salesRep"));
        Callback<TableColumn<PettyCashVoucherLines, PettyCashVoucherLines>, TableCell<PettyCashVoucherLines, PettyCashVoucherLines>> cellFactory = new Callback<TableColumn<PettyCashVoucherLines, PettyCashVoucherLines>, TableCell<PettyCashVoucherLines, PettyCashVoucherLines>>(){

            public TableCell<PettyCashVoucherLines, PettyCashVoucherLines> call(TableColumn<PettyCashVoucherLines, PettyCashVoucherLines> param) {
                TableCell<PettyCashVoucherLines, PettyCashVoucherLines> cell = new TableCell<PettyCashVoucherLines, PettyCashVoucherLines>(){
                    private final Button btn = new Button();
                    {
                        this.btn.setOnAction(e -> {
                            PettyCashVoucherLines data = (PettyCashVoucherLines)this.getTableView().getItems().get(this.getIndex());
                            if (Config.showConfirmDialog("Delete PCV Line", "The PCV line will be permanently deleted", "Are you sure you want to remove the item " + data.getDescription() + " from this PCV?")) {
                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                params.put("code", data.getCode());
                                params.put("pcvNo", data.getPcvNo());
                                String response = Config.loadDataFromPhp("masterdelete?type=pcvlines", params, PettyCashVoucherController.this.getUser());
                                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                                if (jr.isStatus()) {
                                    PettyCashVoucherController.this.loadLines();
                                }
                                PettyCashVoucherController.this.notificationPane.setText(jr.getMessage());
                                PettyCashVoucherController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                PettyCashVoucherController.this.notificationPane.show();
                            }
                        });
                    }

                    public void updateItem(PettyCashVoucherLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setGraphic((Node)Config.getDeleteIcon());
                            this.btn.getStyleClass().add((Object)"transparent_button");
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.delete.setCellFactory((Callback)cellFactory);
        this.delete.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.searchBank.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("bank", gson.toJson((Object)this.bank.getItems()), this.getUser());
                this.bank.setValue(gson.fromJson(response, Bank.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchFixedAsset.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("fixedasset", gson.toJson((Object)this.vehicle.getItems()), this.getUser());
                this.vehicle.setValue(gson.fromJson(response, FixedAssets.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchItem.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("charge_item", gson.toJson((Object)this.chargeItem.getItems()), this.getUser());
                this.chargeItem.setValue(gson.fromJson(response, ChargeItem.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchVSM.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("user", gson.toJson((Object)this.salesRep.getItems()), this.getUser());
                this.salesRep.setValue(gson.fromJson(response, User.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.addLine.setOnAction(e -> {
            int chargeCode = 0;
            double mAmount = 0.0;
            String message = "";
            String tDescription = "";
            boolean error = false;
            int regionCode = 0;
            String tSalesRep = "";
            String tVehicle = "";
            double tKiloMetres = 0.0;
            ChargeItem selection = null;
            try {
                chargeCode = ((ChargeItem)this.chargeItem.getValue()).getCode();
                selection = (ChargeItem)this.chargeItem.getValue();
            }
            catch (Exception r) {
                message = "Please select an item";
                error = true;
            }
            try {
                mAmount = Double.parseDouble(this.amount.getText().trim());
            }
            catch (Exception r) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid amount";
            }
            try {
                tDescription = this.description.getText().trim();
                if (tDescription.length() < 4) {
                    throw new Exception();
                }
            }
            catch (Exception u) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid description. Atleast 4 characters";
            }
            if (!error) {
                if (selection.isRequireRegion()) {
                    try {
                        regionCode = ((Region)this.region.getValue()).getId();
                        if (regionCode < 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception p) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select a region for the transaction";
                    }
                }
                if (selection.isRequireVSM()) {
                    try {
                        tSalesRep = ((User)this.salesRep.getValue()).getUserName();
                        if (tSalesRep.length() < 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception p) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select a Sales rep for the Transaction";
                    }
                }
                if (selection.isRequireFixedAsset()) {
                    try {
                        tVehicle = ((FixedAssets)this.vehicle.getValue()).getAssetNo();
                        if (tVehicle.length() < 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception p) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select a vehicle for the transaction";
                    }
                    try {
                        tKiloMetres = Double.parseDouble(this.kilometres.getText().trim());
                    }
                    catch (Exception u) {
                        tKiloMetres = 0.0;
                    }
                }
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            } else if (this.save()) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("chargeItem", chargeCode);
                    params.put("pcvNo", this.pcvNo.getText().trim());
                    params.put("amount", mAmount);
                    params.put("description", tDescription);
                    params.put("regionCode", regionCode);
                    params.put("salesRep", tSalesRep);
                    params.put("vehicle", tVehicle);
                    params.put("kiloMetres", tKiloMetres);
                    String response = Config.loadDataFromPhp("mastercreate?type=pettycashvoucherlines", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.loadLines();
                        this.amount.setText(null);
                        this.chargeItem.setValue(null);
                        this.description.setText(null);
                        this.region.setValue(null);
                        this.salesRep.setValue(null);
                        this.vehicle.setValue(null);
                        this.vehicleVBox.setVisible(false);
                        this.kilometresVBox.setVisible(false);
                        this.salesRepVBox.setVisible(false);
                        this.regionVBox.setVisible(false);
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception r) {
                    this.notificationPane.setText("We encountered an error while adding the P.C.V Line");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }

    public boolean post() {
        if (this.save()) {
            try {
                String myDate = Config.localDateToString((LocalDate)this.pcvDate.getValue());
                String tPCVNo = this.pcvNo.getText().trim();
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Confirm Post");
                alert.setHeaderText("Posting the petty cash voucher results in a change in the financial position. ");
                alert.setContentText("Are you sure you want to post petty cash voucher number " + tPCVNo + "?");
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    try {
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("voucherNo", tPCVNo);
                        String response = Config.loadDataFromPhp("masterpost?type=pettycashvoucher", params, this.getUser());
                        System.out.println(response);
                        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                        return jr.isStatus();
                    }
                    catch (Exception y) {
                        this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("Please select the date of the petty cash voucher");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public boolean reverse() {
        try {
            String myDate = Config.localDateToString((LocalDate)this.pcvDate.getValue());
            String tPCVNo = this.pcvNo.getText().trim();
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Confirm Reversal");
            alert.setHeaderText("Reversing the petty cash voucher results in a change in the financial position. ");
            alert.setContentText("Are you sure you want to reverse petty cash voucher number " + tPCVNo + "?");
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("voucherNo", tPCVNo);
                    String response = Config.loadDataFromPhp("masterpost?type=reversepettycashvoucher", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    return jr.isStatus();
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        }
        catch (Exception y) {
            this.notificationPane.setText("Please select the date of the petty cash voucher");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public boolean save() {
        String tPCVNo = "";
        String tPCVDate = "";
        int bankCode = 0;
        String tRefNo = "";
        int regionCode = 0;
        String salesRepCode = "";
        String tPayee = "";
        boolean newPCV = false;
        NumberSeries nb = new NumberSeries(9, this.getUser());
        try {
            tPCVNo = this.pcvNo.getText().trim();
            if (tPCVNo.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            newPCV = true;
            tPCVNo = nb.getNextNumber();
        }
        try {
            tRefNo = this.externalRefNo.getText().trim();
        }
        catch (Exception e) {
            tRefNo = "";
        }
        try {
            bankCode = ((Bank)this.bank.getValue()).getCode();
        }
        catch (Exception e) {
            bankCode = 0;
        }
        try {
            tPCVDate = Config.localDateToString((LocalDate)this.pcvDate.getValue());
        }
        catch (Exception t) {
            tPCVDate = null;
        }
        try {
            regionCode = ((Region)this.region.getValue()).getId();
        }
        catch (Exception y) {
            regionCode = 0;
        }
        try {
            salesRepCode = ((User)this.salesRep.getValue()).getUserName();
        }
        catch (Exception u) {
            salesRepCode = "";
        }
        try {
            tPayee = this.payee.getText().trim();
        }
        catch (Exception u) {
            tPayee = "";
        }
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("pcvNo", tPCVNo);
            params.put("bankCode", bankCode);
            params.put("refNo", tRefNo);
            params.put("pcvDate", tPCVDate);
            params.put("region", regionCode);
            params.put("salesRep", salesRepCode);
            params.put("payee", tPayee);
            String response = Config.loadDataFromPhp("masterupdate?type=pettycashvoucher", params, this.getUser());
            Gson g = new Gson();
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus() && newPCV) {
                nb.updateLastUsed(tPCVNo);
                this.pcvNo.setText(jr.getOverLoad1());
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception e) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again.");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public void loadLines() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PettyCashVoucherController.this.masker.setVisible(true));
                ObservableList<PettyCashVoucherLines> myLines = new PettyCashVoucherLines().getLines(PettyCashVoucherController.this.pcvNo.getText().trim(), PettyCashVoucherController.this.getUser());
                double mTotal = myLines.stream().mapToDouble(PettyCashVoucherLines::getAmount).sum();
                int withRegion = myLines.stream().filter(v -> v.getItem().isRequireRegion()).collect(Collectors.toList()).size();
                int withVehicle = myLines.stream().filter(v -> v.getItem().isRequireFixedAsset()).collect(Collectors.toList()).size();
                int withSalesRep = myLines.stream().filter(v -> v.getItem().isRequireVSM()).collect(Collectors.toList()).size();
                Platform.runLater(() -> {
                    PettyCashVoucherController.this.allItems.setItems(myLines);
                    PettyCashVoucherController.this.pcvTotal.setText(Config.formatNumber(mTotal));
                    if (withRegion > 0) {
                        PettyCashVoucherController.this.colRegion.setVisible(true);
                    } else {
                        PettyCashVoucherController.this.colRegion.setVisible(false);
                    }
                    if (withSalesRep > 0) {
                        PettyCashVoucherController.this.colSalesRep.setVisible(true);
                    } else {
                        PettyCashVoucherController.this.colSalesRep.setVisible(false);
                    }
                    if (withVehicle > 0) {
                        PettyCashVoucherController.this.colVehicle.setVisible(true);
                        PettyCashVoucherController.this.colKilometres.setVisible(true);
                    } else {
                        PettyCashVoucherController.this.colVehicle.setVisible(false);
                        PettyCashVoucherController.this.colKilometres.setVisible(false);
                    }
                    PettyCashVoucherController.this.masker.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

