/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Employee;
import classes.User;
import com.jfoenix.controls.JFXButton;
import controllers.AllocateAllowanceDeduction;
import controllers.EmployeeCardController;
import filterscontrollers.MasterRollFilter;
import filterscontrollers.PayslipFilter;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class PayrollEmployeesController
implements Initializable {
    private boolean careteker;
    private User user;
    ObservableList<Employee> myEmployees = FXCollections.observableArrayList();
    @FXML
    private JFXButton earnings;
    @FXML
    private JFXButton deductions;
    @FXML
    private JFXButton processPayroll;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton edit;
    @FXML
    private JFXButton sendPayslips;
    @FXML
    private JFXButton masterRoll;
    @FXML
    private JFXButton bankExport;
    @FXML
    private JFXButton payeExport;
    @FXML
    private JFXButton nhifExport;
    @FXML
    private JFXButton nssfExport;
    @FXML
    private JFXButton payslip;
    @FXML
    private JFXButton p9;
    @FXML
    private TableView<Employee> allEmployees;
    @FXML
    private TableColumn employeeNumber;
    @FXML
    private TableColumn employeeName;
    @FXML
    private TableColumn basicSalary;
    @FXML
    private TableColumn employeePhone;
    @FXML
    private TableColumn employeeProperty;
    @FXML
    private TableColumn employeeEmail;
    @FXML
    private TableColumn jobTitle;
    @FXML
    private MaskerPane masker;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;

    public boolean isCareteker() {
        return this.careteker;
    }

    public void setCareteker(boolean careteker) {
        this.careteker = careteker;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadEmployees();
    }

    @FXML
    void onEnter(ActionEvent event) {
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.edit.setOnAction(r -> {
            try {
                Employee xm = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getEmployeeNumber().equals("")) {
                    this.editEmployee(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.deductions.setOnAction(e -> {
            try {
                Employee employee = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                String employeeNo = employee.getEmployeeNumber();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allocateAllowanceDeduction.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                AllocateAllowanceDeduction controller = (AllocateAllowanceDeduction)loader.getController();
                controller.setCaretaker(this.isCareteker());
                controller.setType("Deduction");
                controller.setUser(this.getUser());
                controller.setEmployee(employee);
                stage.setTitle("Allocate Deductions");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (NullPointerException employee) {
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your allocate deductions screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.earnings.setOnAction(e -> {
            try {
                Employee employee = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                String employeeNo = employee.getEmployeeNumber();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allocateAllowanceDeduction.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 1167.0, 432.0);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                AllocateAllowanceDeduction controller = (AllocateAllowanceDeduction)loader.getController();
                controller.setCaretaker(this.isCareteker());
                controller.setType("Earning");
                controller.setUser(this.getUser());
                controller.setEmployee(employee);
                stage.setTitle("Allocate Allowances");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (NullPointerException employee) {
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your allocate deductions screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.payslip.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/payslipfilter.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                PayslipFilter controller = (PayslipFilter)loader.getController();
                controller.setCaretaker(this.isCareteker());
                controller.setUser(this.getUser());
                try {
                    Employee emp = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                    controller.setMyEmployee(emp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setTitle("Generate Payslip");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your payslip filter screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.masterRoll.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/masterrollfilter.fxml").openStream());
                MasterRollFilter controller = (MasterRollFilter)loader.getController();
                controller.setUser(this.getUser());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Generate Master Roll");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your master roll filter screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.bankExport.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/masterrollfilter.fxml").openStream());
                MasterRollFilter controller = (MasterRollFilter)loader.getController();
                controller.setUser(this.getUser());
                controller.setReportName("bankexport");
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Generate Master Roll");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your master roll filter screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.payeExport.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/masterrollfilter.fxml").openStream());
                MasterRollFilter controller = (MasterRollFilter)loader.getController();
                controller.setUser(this.getUser());
                controller.setReportName("payeexport");
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Generate PAYE Export");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your paye filter screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.nhifExport.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/masterrollfilter.fxml").openStream());
                MasterRollFilter controller = (MasterRollFilter)loader.getController();
                controller.setUser(this.getUser());
                controller.setReportName("nhifexport");
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Generate NHIF Export");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your nhif filter screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.nssfExport.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/masterrollfilter.fxml").openStream());
                MasterRollFilter controller = (MasterRollFilter)loader.getController();
                controller.setUser(this.getUser());
                controller.setReportName("nssfexport");
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Generate NSSF Export");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your nssf filter screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.allEmployees.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                // empty if block
            }
        });
        this.employeeName.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
        this.basicSalary.setCellValueFactory((Callback)new PropertyValueFactory("basicSalaryString"));
        this.employeeNumber.setCellValueFactory((Callback)new PropertyValueFactory("employeeNumber"));
        this.employeePhone.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.employeeProperty.setCellValueFactory((Callback)new PropertyValueFactory("property"));
        this.employeeEmail.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.jobTitle.setCellValueFactory((Callback)new PropertyValueFactory("jobTitle"));
        this.refresh.setOnAction(e -> this.loadEmployees());
        this.clearFilter.setOnAction(e -> {
            this.searchBar.setText("");
            this.loadEmployees();
        });
        this.searchBar.textProperty().addListener((observable, oldValue, newValue) -> {
            String searchString = newValue.trim().toLowerCase();
            ObservableList allEmployeesList = FXCollections.observableArrayList();
            for (int b = 0; b < this.myEmployees.size(); ++b) {
                Employee current = (Employee)this.myEmployees.get(b);
                String tEmployeeNo = "";
                String tEmployeeName = "";
                String tEmployeePhone = "";
                String tEmailAddress = "";
                String tJobTitle = "";
                try {
                    tEmployeeNo = current.getEmployeeNumber().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tEmployeeName = current.getFullName().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tEmployeePhone = current.getPhoneNumber().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tEmailAddress = current.getEmail().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tJobTitle = current.getJobTitle().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String myId = current.getIdNumber() + "";
                if (!tEmployeeNo.contains(searchString) && !tEmployeeName.contains(searchString) && !tEmployeePhone.contains(searchString) && !tEmailAddress.contains(searchString) && !tJobTitle.contains(searchString) && !myId.contains(searchString)) continue;
                allEmployeesList.add((Object)current);
            }
            this.allEmployees.getItems().removeAll((Collection)this.allEmployees.getItems());
            this.allEmployees.setItems(allEmployeesList);
        });
        this.allEmployees.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Employee rowData = (Employee)row.getItem();
                    Employee member = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                    if (!member.equals(null)) {
                        this.editEmployee(member);
                    }
                }
            });
            return row;
        });
    }

    public void loadEmployees() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> PayrollEmployeesController.this.masker.setVisible(true));
                Platform.runLater(() -> {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("exited", 0);
                    params.put("caretaker", PayrollEmployeesController.this.isCareteker() ? 1 : 0);
                    PayrollEmployeesController.this.allEmployees.setItems(new Employee().getAllEmployees(params, PayrollEmployeesController.this.getUser()));
                    PayrollEmployeesController.this.myEmployees = new Employee().getAllEmployees(params, PayrollEmployeesController.this.getUser());
                });
                Platform.runLater(() -> PayrollEmployeesController.this.masker.setVisible(false));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void editEmployee(Employee employee) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/employeeCard.fxml").openStream());
            EmployeeCardController controller = (EmployeeCardController)loader.getController();
            controller.setPayroll(true);
            controller.setUser(this.getUser());
            controller.setEmployee(employee);
            Scene scene = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
            final Stage stage = new Stage();
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            stage.setTitle("Edit Employee");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PayrollEmployeesController.this.loadEmployees();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit employee screen. Please contact support");
            alert.showAndWait();
        }
    }
}

