/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.PaymentVoucher;
import classes.User;
import com.jfoenix.controls.JFXButton;
import controllers.PaymentVoucherController;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class PaymentVouchersController
implements Initializable {
    private User user;
    private boolean posted;
    ObservableList<PaymentVoucher> toSearch = FXCollections.observableArrayList();
    @FXML
    private VBox root;
    @FXML
    private JFXButton newPV;
    @FXML
    private JFXButton postPV;
    @FXML
    private JFXButton editPV;
    @FXML
    private JFXButton deletePV;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton viewPV;
    @FXML
    private JFXButton printPV;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private TextField search;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private StackPane holder;
    @FXML
    private TableView<PaymentVoucher> allPVs;
    @FXML
    private TableColumn pvNo;
    @FXML
    private TableColumn vendorName;
    @FXML
    private TableColumn paymentDate;
    @FXML
    private TableColumn paymentMethod;
    @FXML
    private TableColumn bank;
    @FXML
    private TableColumn amount;
    @FXML
    private MaskerPane masker;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        if (posted) {
            this.deletePV.setDisable(true);
            this.postPV.setDisable(true);
            this.newPV.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.splitPane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.pvNo.setCellValueFactory((Callback)new PropertyValueFactory("pvNo"));
        this.vendorName.setCellValueFactory((Callback)new PropertyValueFactory("vendor"));
        this.paymentDate.setCellValueFactory((Callback)new PropertyValueFactory("paymentDate"));
        this.paymentMethod.setCellValueFactory((Callback)new PropertyValueFactory("paymentMethod"));
        this.bank.setCellValueFactory((Callback)new PropertyValueFactory("bank"));
        this.amount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.refresh.setOnAction(e -> this.loadVouchers());
        this.viewPV.setOnAction(e -> {
            PaymentVoucher voucher = (PaymentVoucher)this.allPVs.getSelectionModel().getSelectedItem();
            new PaymentVoucher().showPaymentVoucher(voucher);
        });
        this.printPV.setOnAction(e -> {
            PaymentVoucher voucher = (PaymentVoucher)this.allPVs.getSelectionModel().getSelectedItem();
            new PaymentVoucher().printPaymentVoucher(voucher);
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            for (int b = 0; b < this.toSearch.size(); ++b) {
                PaymentVoucher current = (PaymentVoucher)this.toSearch.get(b);
                String tVendorName = "";
                try {
                    tVendorName = current.getVendor().getFullName();
                    if (tVendorName.equals(null)) {
                        tVendorName = "";
                    }
                }
                catch (Exception t) {
                    tVendorName = "";
                }
                String tBankName = "";
                try {
                    tBankName = current.getBank().getBankName();
                    if (tBankName.equals(null)) {
                        tBankName = "";
                    }
                }
                catch (Exception t) {
                    tBankName = "";
                }
                String tPaymentMethodName = "";
                try {
                    tPaymentMethodName = current.getPaymentMethod().getPaymentMethod();
                    if (tPaymentMethodName.equals(null)) {
                        tPaymentMethodName = "";
                    }
                }
                catch (Exception t) {
                    tPaymentMethodName = "";
                }
                String tTotal = current.getAmount() + "";
                if (!current.getPvNo().toLowerCase().contains(newValue.toLowerCase()) && !tVendorName.toLowerCase().contains(newValue.toLowerCase()) && !tPaymentMethodName.toLowerCase().contains(newValue.toLowerCase()) && !current.getPaymentDate().toLowerCase().contains(newValue.toLowerCase()) && !tBankName.toLowerCase().contains(newValue.toLowerCase()) && !tTotal.contains(newValue.toLowerCase())) continue;
                afterSearch.add((Object)current);
            }
            this.allPVs.getItems().removeAll((Collection)this.allPVs.getItems());
            this.allPVs.setItems(afterSearch);
        });
        this.postPV.setOnAction(e -> {
            block7: {
                try {
                    PaymentVoucher ci = (PaymentVoucher)this.allPVs.getSelectionModel().getSelectedItem();
                    String voucherNo = ci.getPvNo();
                    try {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the payment voucher results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post cpayment voucher number " + voucherNo + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block7;
                        try {
                            JsonResponses jr = new PaymentVoucher().postPV(voucherNo, this.getUser());
                            if (jr.isStatus()) {
                                this.loadVouchers();
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the Payment Voucher. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the Payment Voucher. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.newPV.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/paymentvoucher.fxml").openStream());
                PaymentVoucherController controller = (PaymentVoucherController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Create Payment Voucher");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                PaymentVouchersController.this.loadVouchers();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.allPVs.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    PaymentVoucher rowData = (PaymentVoucher)row.getItem();
                    PaymentVoucher voucher = (PaymentVoucher)this.allPVs.getSelectionModel().getSelectedItem();
                    if (!voucher.equals(null)) {
                        this.editVoucher(voucher);
                    }
                }
            });
            return row;
        });
        this.editPV.setOnAction(r -> {
            try {
                PaymentVoucher xm = (PaymentVoucher)this.allPVs.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getPvNo().equals("")) {
                    this.editVoucher(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.deletePV.setOnAction(e -> {
            try {
                PaymentVoucher ci = (PaymentVoucher)this.allPVs.getSelectionModel().getSelectedItem();
                String tVoucherNo = ci.getPvNo();
                JsonResponses jr = new PaymentVoucher().deletePV(tVoucherNo, this.getUser());
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    this.loadVouchers();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadVouchers();
        });
        this.loadVouchers();
    }

    public void loadVouchers() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            this.allPVs.setItems(new PaymentVoucher().getAllPaymentVouchers(this.posted, this.getUser()));
            this.toSearch = new PaymentVoucher().getAllPaymentVouchers(this.posted, this.getUser());
            this.masker.setVisible(false);
        });
    }

    public void editVoucher(PaymentVoucher voucher) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/paymentvoucher.fxml").openStream());
            Scene editVoucher = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editVoucher.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editVoucher);
            PaymentVoucherController controller = (PaymentVoucherController)loader.getController();
            controller.setUser(this.getUser());
            controller.setPaymentVoucher(voucher);
            stage.setTitle("Edit Payment Voucher");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PaymentVouchersController.this.loadVouchers();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit payment voucher screen. Please contact support");
            alert.showAndWait();
        }
    }
}

