/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.PaymentMethod;
import classes.PaymentTypes;
import classes.PaymentVoucher;
import classes.PaymentVoucherLines;
import classes.Region;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class PaymentVoucherController
implements Initializable {
    private User user;
    ObservableList<PaymentVoucherLines> myLines = FXCollections.observableArrayList();
    PaymentVoucher paymentVoucher;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label voucherNumber;
    @FXML
    private ComboBox<Vendor> myVendor;
    @FXML
    private Button chooseVendor;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private ComboBox<PaymentMethod> paymentMethod;
    @FXML
    private TextField externalRefNo;
    @FXML
    private DatePicker paymentDate;
    @FXML
    private ComboBox<PaymentTypes> withholdingTax;
    @FXML
    private TextField amount;
    @FXML
    private Hyperlink incomeWHT;
    @FXML
    private Hyperlink vatWHT;
    @FXML
    private Hyperlink unUppliedAmount;
    @FXML
    private TableView<PaymentVoucherLines> allLines;
    @FXML
    private TableColumn colDate;
    @FXML
    private TableColumn colInvoice;
    @FXML
    private TableColumn colInvoiceAmount;
    @FXML
    private TableColumn colPaidAmount;
    @FXML
    private TableColumn colNewOutstanding;
    @FXML
    private ComboBox<Region> region;
    @FXML
    private JFXButton deleteVoucher;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton postVoucher;
    @FXML
    private JFXButton voidPayment;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadData();
        this.loadVendors();
        this.loadRegions();
    }

    public PaymentVoucher getPaymentVoucher() {
        return this.paymentVoucher;
    }

    public void setPaymentVoucher(PaymentVoucher paymentVoucher) {
        this.paymentVoucher = paymentVoucher;
        try {
            this.voucherNumber.setText(paymentVoucher.getPvNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myVendor.setValue((Object)paymentVoucher.getVendor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bank.setValue((Object)paymentVoucher.getBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.paymentMethod.setValue((Object)paymentVoucher.getPaymentMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.region.setValue((Object)paymentVoucher.getRegion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.externalRefNo.setText(paymentVoucher.getExternalRef());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LocalDate localDate = LocalDate.parse(paymentVoucher.getPaymentDate());
            this.paymentDate.setValue((Object)localDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.amount.setText(paymentVoucher.getAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (paymentVoucher.isPosted()) {
            this.deleteVoucher.setDisable(true);
            this.chooseVendor.setDisable(true);
            this.postVoucher.setDisable(true);
            this.voidPayment.setDisable(false);
            this.save.setDisable(true);
        }
        if (paymentVoucher.isReversed()) {
            this.voidPayment.setDisable(true);
        }
        this.loadVendorInvoices();
        this.loadVoucherLines();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.voidPayment.setDisable(true);
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.myVendor, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.bank, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.paymentMethod, Validator.createEmptyValidator((String)"Required"));
        if (Config.showRegionReports) {
            vs.registerValidator(this.region, Validator.createEmptyValidator((String)"Required"));
        }
        vs.registerValidator((Control)this.paymentDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.withholdingTax, Validator.createEmptyValidator((String)"Required"));
        this.myVendor.setOnAction(e -> this.loadVendorInvoices());
        this.voidPayment.setOnAction(e -> {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Void Receipt");
            alert.setHeaderText("Voiding the payment results in a change in financial position");
            alert.setContentText("Please select a reason for voiding the payment");
            ButtonType buttonTypeOne = new ButtonType("Wrong Entry");
            ButtonType buttonTypeTwo = new ButtonType("Bounced Cheque");
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo, new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE)});
            Optional result = alert.showAndWait();
            if (result.get() == buttonTypeOne) {
                this.voidPayment(0);
            } else if (result.get() == buttonTypeTwo) {
                this.voidPayment(1);
            }
        });
        Callback<TableColumn<PaymentVoucherLines, PaymentVoucherLines>, TableCell<PaymentVoucherLines, PaymentVoucherLines>> confirmCellFactory = new Callback<TableColumn<PaymentVoucherLines, PaymentVoucherLines>, TableCell<PaymentVoucherLines, PaymentVoucherLines>>(){

            public TableCell<PaymentVoucherLines, PaymentVoucherLines> call(TableColumn<PaymentVoucherLines, PaymentVoucherLines> param) {
                TableCell<PaymentVoucherLines, PaymentVoucherLines> cell = new TableCell<PaymentVoucherLines, PaymentVoucherLines>(){
                    private final Hyperlink btn = new Hyperlink("Edit");
                    {
                        this.btn.setOnAction(e -> {
                            PaymentVoucherLines data = (PaymentVoucherLines)this.getTableView().getItems().get(this.getIndex());
                            String quantity = data.getAmountToApply();
                            TextInputDialog alert = new TextInputDialog(quantity);
                            alert.setHeaderText(null);
                            alert.setTitle("Edit Paid Amount");
                            alert.setContentText("Edit Paid Amount");
                            Optional result = alert.showAndWait();
                            result.ifPresent(confirmedAmount -> {
                                try {
                                    double balance = data.getBalanceDouble() + data.getAmountToApplyDouble();
                                    double apply = Double.parseDouble(confirmedAmount.replace(",", ""));
                                    data.setAmountToApply(apply);
                                    data.setBalance(balance - apply);
                                    data.setManualApplication(true);
                                    PaymentVoucherController.this.autoApply();
                                }
                                catch (Exception y) {
                                    PaymentVoucherController.this.notificationPane.setText("Please enter a valid amount");
                                    PaymentVoucherController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                                    PaymentVoucherController.this.notificationPane.show();
                                }
                            });
                        });
                    }

                    public void updateItem(PaymentVoucherLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setText(item.getAmountToApply());
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colInvoice.setCellValueFactory((Callback)new PropertyValueFactory("invoiceNo"));
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("invoiceDate"));
        this.colInvoiceAmount.setCellValueFactory((Callback)new PropertyValueFactory("invoiceAmount"));
        this.colNewOutstanding.setCellValueFactory((Callback)new PropertyValueFactory("balance"));
        this.colPaidAmount.setCellFactory((Callback)confirmCellFactory);
        this.colPaidAmount.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.amount.textProperty().addListener((observable, oldValue, newValue) -> this.autoApply());
        this.withholdingTax.setOnAction(e -> this.autoApply());
        this.chooseVendor.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("vendor", gson.toJson((Object)this.myVendor.getItems()), this.getUser());
                this.myVendor.setValue(gson.fromJson(response, Vendor.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.save.setOnAction(e -> this.save());
        this.deleteVoucher.setOnAction(e -> {
            String tVoucherNo = this.voucherNumber.getText().trim();
            if (!tVoucherNo.equals(null) && !tVoucherNo.equals("")) {
                JsonResponses jr = new PaymentVoucher().deletePV(tVoucherNo, this.getUser());
                if (jr.isStatus()) {
                    Stage stage = (Stage)this.deleteVoucher.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            } else {
                Stage stage = (Stage)this.deleteVoucher.getScene().getWindow();
                stage.close();
            }
        });
        this.postVoucher.setOnAction(e -> {
            block6: {
                if (this.save()) {
                    try {
                        String tVoucherNo = this.voucherNumber.getText().trim();
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the payment voucher results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post payment voucher number " + tVoucherNo + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block6;
                        try {
                            JsonResponses jr = new PaymentVoucher().postPV(tVoucherNo, this.getUser());
                            if (jr.isStatus()) {
                                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                                GeneralListController.publicNotificationPane.show();
                                Stage stage = (Stage)this.postVoucher.getScene().getWindow();
                                stage.close();
                                break block6;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                            t.printStackTrace();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
        this.amount.addEventFilter(KeyEvent.KEY_TYPED, event -> {
            if (!event.getCharacter().matches("[0123456789.]")) {
                event.consume();
            }
        });
    }

    private void loadVendors() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Node original = PaymentVoucherController.this.chooseVendor.getGraphic();
                Platform.runLater(() -> {
                    ProgressIndicator progressIndicator = new ProgressIndicator();
                    progressIndicator.setPrefWidth(20.0);
                    progressIndicator.setPrefHeight(20.0);
                    PaymentVoucherController.this.chooseVendor.setGraphic((Node)progressIndicator);
                });
                ObservableList<Vendor> allVendors = new Vendor().getAllVendors(PaymentVoucherController.this.user);
                Platform.runLater(() -> {
                    PaymentVoucherController.this.myVendor.setItems(allVendors);
                    PaymentVoucherController.this.chooseVendor.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void loadData() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    PaymentVoucherController.this.notificationPane.setText("Loading Values, Please wait");
                    PaymentVoucherController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    PaymentVoucherController.this.notificationPane.show();
                });
                ObservableList<Bank> allBanks = Bank.getAllBanks(PaymentVoucherController.this.user);
                ObservableList<PaymentMethod> allPaymentMethods = new PaymentMethod().getAllPaymentMethods(PaymentVoucherController.this.user);
                ObservableList<PaymentTypes> allTypes = new PaymentTypes().getAllPaymentTypes(PaymentVoucherController.this.user);
                Platform.runLater(() -> {
                    PaymentVoucherController.this.withholdingTax.setItems(allTypes);
                    PaymentVoucherController.this.bank.setItems(allBanks);
                    PaymentVoucherController.this.paymentMethod.setItems(allPaymentMethods);
                    PaymentVoucherController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public boolean save() {
        int regionCode;
        double mAmount;
        String tPaymentDate;
        String tPaymentRef;
        int tPaymentMethod;
        int tBank;
        int tPaymentType;
        String tVendor;
        boolean newVoucher;
        NumberSeries nb;
        String tVoucherNo;
        block23: {
            tVoucherNo = "";
            nb = new NumberSeries(11, this.getUser());
            try {
                tVoucherNo = this.voucherNumber.getText().trim();
            }
            catch (Exception e) {
                tVoucherNo = "";
            }
            newVoucher = false;
            if (tVoucherNo.equals("")) {
                tVoucherNo = nb.getNextNumber();
                newVoucher = true;
            }
            tVendor = "";
            try {
                tVendor = ((Vendor)this.myVendor.getValue()).getVendorNumber();
                if (tVendor.equals(null) || tVendor.trim().equals("")) {
                    tVendor = "";
                }
            }
            catch (Exception p) {
                tVendor = "";
            }
            tPaymentType = 0;
            try {
                tPaymentType = ((PaymentTypes)this.withholdingTax.getValue()).getId();
                if (tPaymentType < 1) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("Please select the withholding tax");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                return false;
            }
            tBank = 0;
            try {
                tBank = ((Bank)this.bank.getValue()).getCode();
            }
            catch (Exception e) {
                tBank = 0;
            }
            tPaymentMethod = 0;
            try {
                tPaymentMethod = ((PaymentMethod)this.paymentMethod.getValue()).getCode();
            }
            catch (Exception e) {
                tPaymentMethod = 0;
            }
            tPaymentRef = this.externalRefNo.getText().trim();
            tPaymentDate = "";
            try {
                tPaymentDate = ((LocalDate)this.paymentDate.getValue()).toString();
            }
            catch (Exception r) {
                tPaymentDate = "";
            }
            String tAmount = this.amount.getText().trim();
            mAmount = 0.0;
            try {
                mAmount = Double.parseDouble(tAmount);
            }
            catch (Exception r) {
                this.notificationPane.setText("Please enter a valid value for amount");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                return false;
            }
            regionCode = 0;
            try {
                regionCode = ((Region)this.region.getValue()).getId();
                if (regionCode < 1) {
                    throw new Exception();
                }
            }
            catch (Exception ignored) {
                if (!Config.showRegionReports) break block23;
                this.notificationPane.setText("Please select a region for the payment");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                return false;
            }
        }
        try {
            Gson gson = new Gson();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("voucherNo", tVoucherNo);
            params.put("vendorNo", tVendor);
            params.put("bankCode", tBank);
            params.put("paymentMethod", tPaymentMethod);
            params.put("regionCode", regionCode);
            params.put("paymentRef", tPaymentRef);
            params.put("paymentDate", tPaymentDate);
            params.put("amount", mAmount);
            params.put("paymentType", tPaymentType);
            params.put("withholdingVAT", this.vatWHT.getText().replace(",", ""));
            params.put("withholdingIncome", this.incomeWHT.getText().replace(",", ""));
            params.put("lines", gson.toJson((Object)this.allLines.getItems()));
            String response = Config.loadDataFromPhp("mastercreate?type=paymentvoucher", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)gson.fromJson(response, JsonResponses.class);
            if (newVoucher) {
                nb.updateLastUsed(tVoucherNo);
                this.voucherNumber.setText(jr.getOverLoad1());
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notificationPane.setText("We encountered an error while saving the receipt. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public void loadVendorInvoices() {
        try {
            String vendorNo = ((Vendor)this.myVendor.getValue()).getVendorNumber();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("vendorNo", vendorNo);
            String response = Config.loadDataFromPhp("masterfetch?type=vendor_outstanding_invoices", params, this.getUser());
            ObservableList lines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, PaymentVoucherLines[].class)));
            this.myLines = FXCollections.observableArrayList((Collection)lines.stream().filter(v -> v.getBalanceDouble() > 0.0).collect(Collectors.toList()));
            this.allLines.setItems(this.myLines);
            this.autoApply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadVoucherLines() {
        this.allLines.setItems(new PaymentVoucherLines().getLines(this.voucherNumber.getText().trim(), this.getUser()));
    }

    public void autoApply() {
        try {
            double paidAmount = 0.0;
            try {
                paidAmount = Double.parseDouble(this.amount.getText().trim());
                try {
                    PaymentTypes selectedType = (PaymentTypes)this.withholdingTax.getValue();
                    int taxRate = 16;
                    if (selectedType.getWithholdingVatPercentage() > 0.0) {
                        paidAmount = paidAmount * (double)(100 + taxRate) / (100.0 + ((double)taxRate - selectedType.getWithholdingVatPercentage()));
                    }
                    paidAmount = Config.roundNumber(paidAmount);
                    double whtIncome = selectedType.getWithholdingTaxPercentage() * paidAmount / 100.0;
                    double whtVAT = selectedType.getWithholdingVatPercentage() * (paidAmount / (double)(100 + taxRate));
                    whtIncome = Config.roundNumber(whtIncome);
                    whtVAT = Config.roundNumber(whtVAT);
                    this.incomeWHT.setText(Config.formatNumber(whtIncome));
                    this.vatWHT.setText(Config.formatNumber(whtVAT));
                }
                catch (Exception selectedType) {}
            }
            catch (Exception selectedType) {
                // empty catch block
            }
            ObservableList returnedLines = FXCollections.observableArrayList();
            double mBalance = paidAmount;
            for (PaymentVoucherLines currentLine : this.myLines) {
                double amountToApply = 0.0;
                double tBalance = currentLine.getBalanceDouble() + currentLine.getAmountToApplyDouble();
                amountToApply = !currentLine.isManualApplication() ? ((amountToApply = Math.min(tBalance, mBalance)) < 0.0 ? 0.0 : amountToApply) : currentLine.getAmountToApplyDouble();
                amountToApply = (double)Math.round(amountToApply * 100.0) / 100.0;
                mBalance -= amountToApply;
                currentLine.setAmountToApply(amountToApply);
                currentLine.setBalance(tBalance - amountToApply);
                returnedLines.add((Object)currentLine);
            }
            this.unUppliedAmount.setText(Config.formatNumber(mBalance));
            if (mBalance > 0.0) {
                PaymentVoucherLines entry = new PaymentVoucherLines();
                entry.setInvoiceDate(Config.localDateToString((LocalDate)this.paymentDate.getValue()));
                entry.setInvoiceNo("Advance Payment");
                entry.setInvoiceAmount(0.0);
                entry.setAmountToApply(mBalance);
                returnedLines.add((Object)entry);
            }
            this.allLines.setItems(returnedLines);
            this.allLines.refresh();
        }
        catch (Exception u) {
            u.printStackTrace();
        }
    }

    private void voidPayment(int bouncedCheque) {
        String tVoucherNo = this.voucherNumber.getText().trim();
        JsonResponses jr = new PaymentVoucher().voidPV(tVoucherNo, this.getUser(), bouncedCheque);
        if (jr.isStatus()) {
            GeneralListController.publicNotificationPane.setText(jr.getMessage());
            GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
            GeneralListController.publicNotificationPane.show();
            Stage stage = (Stage)this.voidPayment.getScene().getWindow();
            stage.close();
        } else {
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        }
    }

    private void loadRegions() {
        if (Config.showRegionReports) {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    ObservableList<Region> allRegions = new Region().getAllRegions(PaymentVoucherController.this.getUser());
                    Platform.runLater(() -> PaymentVoucherController.this.region.setItems(FXCollections.observableArrayList((Collection)allRegions)));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
    }
}

