/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.NumberSeries;
import classes.User;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class NumberSeriesController
implements Initializable {
    private User user;
    ObservableList<NumberSeries> toSearch = FXCollections.observableArrayList();
    @FXML
    private TableView<NumberSeries> allNumbers;
    @FXML
    private TableColumn colCode;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colPrefix;
    @FXML
    private TableColumn colLength;
    @FXML
    private TableColumn colLastNumber;
    @FXML
    private TableColumn edit;
    @FXML
    private MaskerPane maskerPane;
    @FXML
    private TextField search;
    @FXML
    private Button clearFilter;
    public static TableView myTable = new TableView();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadNumberSeries(this.getUser());
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.colCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colPrefix.setCellValueFactory((Callback)new PropertyValueFactory("prefix"));
        this.colLength.setCellValueFactory((Callback)new PropertyValueFactory("length"));
        this.colLastNumber.setCellValueFactory((Callback)new PropertyValueFactory("lastNumberUsed"));
        this.edit.setCellValueFactory((Callback)new PropertyValueFactory("edit"));
        myTable = this.allNumbers;
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadNumberSeries(this.getUser());
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            for (int b = 0; b < this.toSearch.size(); ++b) {
                NumberSeries current = (NumberSeries)this.toSearch.get(b);
                String myCode = current.getCode() + "";
                String myLength = current.getLength() + "";
                newValue = newValue.toLowerCase();
                if (!myCode.toLowerCase().contains((CharSequence)newValue) && !current.getName().toLowerCase().contains((CharSequence)newValue) && !current.getPrefix().toLowerCase().contains((CharSequence)newValue) && !current.getLastNumberUsed().toLowerCase().contains((CharSequence)newValue) && !myLength.toLowerCase().contains((CharSequence)newValue)) continue;
                afterSearch.add((Object)current);
            }
            this.allNumbers.getItems().removeAll((Collection)this.allNumbers.getItems());
            this.allNumbers.setItems(afterSearch);
        });
    }

    public void loadNumberSeries(User user) {
        this.maskerPane.setVisible(true);
        this.allNumbers.setItems(new NumberSeries().getAllNumberSeries(user));
        this.toSearch = new NumberSeries().getAllNumberSeries(user);
        this.maskerPane.setVisible(false);
    }
}

