/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.NextofKin;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class NextOfKinController
implements Initializable {
    private User user;
    private Member member;
    @FXML
    private StackPane stackpane;
    @FXML
    private VBox root;
    @FXML
    private ComboBox<Member> selectMember;
    @FXML
    private Button searchMember;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TableView<NextofKin> allNextofKin;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colAge;
    @FXML
    private TableColumn colRelationship;
    @FXML
    private TableColumn colAddress;
    @FXML
    private TableColumn colPercentage;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colDelete;
    @FXML
    private MaskerPane maskerPane;
    @FXML
    private TextField name;
    @FXML
    private TextField age;
    @FXML
    private ComboBox<String> relationship;
    @FXML
    private TextField address;
    @FXML
    private TextField percentage;
    @FXML
    private Button addKin;
    public static NotificationPane publicNotificationPane = new NotificationPane();
    public static TableView<NextofKin> publicKinTable = new TableView();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.selectMember.setItems(new Member().getAllMembers(this.getUser()));
        String response1 = Config.loadDataFromPhp("masterfetch?type=nextofkinrelationships", new LinkedHashMap<String, Object>(), this.getUser());
        this.relationship.setItems(FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response1, String[].class))));
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
        this.selectMember.setValue((Object)member);
        this.loadNextOfKin();
    }

    public void initialize(URL location, ResourceBundle resources) {
        publicKinTable = this.allNextofKin;
        publicNotificationPane = this.notificationPane;
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.stackpane);
        this.allNextofKin.setPlaceholder((Node)new Label("No Next of Kin added for this member"));
        this.searchMember.setOnAction(e -> {
            try {
                Member member = new Member().getMemberFromSelection(this.getUser());
                String mNo = member.getMemberNumber();
                this.selectMember.setValue((Object)member);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.name, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.relationship, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.percentage, Validator.createEmptyValidator((String)"Required"));
        this.age = new Config().setDoubleTextField(this.age);
        this.percentage = new Config().setDoubleTextField(this.percentage);
        this.selectMember.setOnAction(e -> this.loadNextOfKin());
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colAge.setCellValueFactory((Callback)new PropertyValueFactory("age"));
        this.colRelationship.setCellValueFactory((Callback)new PropertyValueFactory("relationship"));
        this.colAddress.setCellValueFactory((Callback)new PropertyValueFactory("address"));
        this.colPercentage.setCellValueFactory((Callback)new PropertyValueFactory("percentage"));
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory("edit"));
        this.colDelete.setCellValueFactory((Callback)new PropertyValueFactory("delete"));
        this.addKin.setOnAction(e -> {
            try {
                String tName = this.name.getText().trim();
                String tAge = this.age.getText().trim();
                String tRelationship = (String)this.relationship.getValue();
                String tAddress = this.address.getText().trim();
                String tPercentage = this.percentage.getText().trim();
                String tMemberNo = ((Member)this.selectMember.getValue()).getMemberNumber();
                double nAge = 0.0;
                double nAllocation = 0.0;
                String message = "";
                boolean error = false;
                if (tName.length() < 1) {
                    error = true;
                    message = "Please enter the next of kin name";
                }
                try {
                    if (tRelationship.length() < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the relationship";
                }
                if (tAge.length() > 0) {
                    try {
                        nAge = Double.parseDouble(tAge);
                    }
                    catch (Exception y) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter a valid next of kin age";
                    }
                }
                try {
                    nAllocation = Double.parseDouble(tPercentage);
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid Percentage";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("name", tName);
                    params.put("age", nAge);
                    params.put("relationship", tRelationship);
                    params.put("address", tAddress);
                    params.put("percentage", nAllocation);
                    params.put("memberNo", tMemberNo);
                    String response = Config.loadDataFromPhp("mastercreate?type=nextofkin", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.name.setText("");
                        this.age.setText("");
                        this.address.setText("");
                        this.percentage.setText("");
                        this.relationship.getSelectionModel().select(0);
                        this.loadNextOfKin();
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception r) {
                r.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }

    public void loadNextOfKin() {
        Platform.runLater(() -> {
            this.maskerPane.setVisible(true);
            this.allNextofKin.setItems(new NextofKin().getKin(((Member)this.selectMember.getValue()).getMemberNumber(), this.getUser()));
            this.maskerPane.setVisible(false);
        });
    }
}

