/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.GLEntry;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class NavigationController
implements Initializable {
    private User user;
    private String documentNo;
    private String documentDate;
    @FXML
    private VBox root;
    @FXML
    private Label docNumber;
    @FXML
    private Label docDate;
    @FXML
    private TableView<GLEntry> allGlEntries;
    @FXML
    private TableColumn glColDocNo;
    @FXML
    private TableColumn glColExtNo;
    @FXML
    private TableColumn glColAccountName;
    @FXML
    private TableColumn glColTransactionDate;
    @FXML
    private TableColumn glColDescription;
    @FXML
    private TableColumn glColAmount;
    @FXML
    private MaskerPane glMasker;
    @FXML
    private TableView<GLEntry> allMemberEntries;
    @FXML
    private TableColumn memberColDocNo;
    @FXML
    private TableColumn memberColExtNo;
    @FXML
    private TableColumn memberColMember;
    @FXML
    private TableColumn memberColMemberAccount;
    @FXML
    private TableColumn memberColTransactionDate;
    @FXML
    private TableColumn memberColDescription;
    @FXML
    private TableColumn memberColAmount;
    @FXML
    private MaskerPane memberMasker;
    @FXML
    private TableView<GLEntry> allLoanEntries;
    @FXML
    private TableColumn loanColDocNo;
    @FXML
    private TableColumn loanColExtNo;
    @FXML
    private TableColumn loanColAccount;
    @FXML
    private TableColumn loanColTransactionDate;
    @FXML
    private TableColumn loanColDescription;
    @FXML
    private TableColumn loanColAmount;
    @FXML
    private MaskerPane loanMasker;
    @FXML
    private TableView<GLEntry> allBankEntries;
    @FXML
    private TableColumn bankColDocNo;
    @FXML
    private TableColumn bankColExtNo;
    @FXML
    private TableColumn bankColAccount;
    @FXML
    private TableColumn bankColTransactionDate;
    @FXML
    private TableColumn bankColDescription;
    @FXML
    private TableColumn bankColAmount;
    @FXML
    private MaskerPane bankMasker;
    @FXML
    private TableView<GLEntry> allStaffEntries;
    @FXML
    private TableColumn staffColDocNo;
    @FXML
    private TableColumn staffColExtNo;
    @FXML
    private TableColumn staffColAccount;
    @FXML
    private TableColumn staffColTransType;
    @FXML
    private TableColumn staffColTransactionDate;
    @FXML
    private TableColumn staffColDescription;
    @FXML
    private TableColumn staffColAmount;
    @FXML
    private MaskerPane staffMasker;
    @FXML
    private TableView<GLEntry> allItemEntries;
    @FXML
    private TableColumn itemColDocNo;
    @FXML
    private TableColumn itemColExtNo;
    @FXML
    private TableColumn itemColAccount;
    @FXML
    private TableColumn itemColTransactionDate;
    @FXML
    private TableColumn itemColDescription;
    @FXML
    private TableColumn itemColAmount;
    @FXML
    private MaskerPane itemMasker;
    @FXML
    private TableView<GLEntry> allCustomerEntries;
    @FXML
    private TableColumn customerColDocNo;
    @FXML
    private TableColumn customerColExtNo;
    @FXML
    private TableColumn customerColAccount;
    @FXML
    private TableColumn customerColTransactionDate;
    @FXML
    private TableColumn customerColDescription;
    @FXML
    private TableColumn customerColAmount;
    @FXML
    private MaskerPane customerMasker;
    @FXML
    private TableView<GLEntry> allVendorEntries;
    @FXML
    private TableColumn vendorColDocNo;
    @FXML
    private TableColumn vendorColExtNo;
    @FXML
    private TableColumn vendorColAccount;
    @FXML
    private TableColumn vendorColTransactionDate;
    @FXML
    private TableColumn vendorColDescription;
    @FXML
    private TableColumn vendorColAmount;
    @FXML
    private MaskerPane vendorMasker;
    @FXML
    private Button cancel;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getDocumentNo() {
        return this.documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
        this.docNumber.setText(documentNo);
    }

    public String getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(String documentDate) {
        this.documentDate = documentDate;
        this.docDate.setText(documentDate);
        this.loadGl();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.glColDocNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.glColExtNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.glColAccountName.setCellValueFactory((Callback)new PropertyValueFactory("account"));
        this.glColTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.glColDescription.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.glColAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.memberColDocNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.memberColExtNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.memberColMember.setCellValueFactory((Callback)new PropertyValueFactory("member"));
        this.memberColMemberAccount.setCellValueFactory((Callback)new PropertyValueFactory("transactionType"));
        this.memberColTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.memberColDescription.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.memberColAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.loanColDocNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.loanColExtNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.loanColAccount.setCellValueFactory((Callback)new PropertyValueFactory("loan"));
        this.loanColTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.loanColDescription.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.loanColAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.bankColDocNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.bankColExtNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.bankColAccount.setCellValueFactory((Callback)new PropertyValueFactory("bank"));
        this.bankColTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.bankColDescription.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.bankColAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.staffColDocNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.staffColExtNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.staffColAccount.setCellValueFactory((Callback)new PropertyValueFactory("staff"));
        this.staffColTransType.setCellValueFactory((Callback)new PropertyValueFactory("transactionType"));
        this.staffColTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.staffColDescription.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.staffColAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.itemColDocNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.itemColExtNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.itemColAccount.setCellValueFactory((Callback)new PropertyValueFactory("item"));
        this.itemColTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.itemColDescription.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.itemColAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.customerColDocNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.customerColExtNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.customerColAccount.setCellValueFactory((Callback)new PropertyValueFactory("customer"));
        this.customerColTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.customerColDescription.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.customerColAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.vendorColDocNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.vendorColExtNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.vendorColAccount.setCellValueFactory((Callback)new PropertyValueFactory("vendor"));
        this.vendorColTransactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.vendorColDescription.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.vendorColAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
    }

    public void loadValues() {
    }

    public void loadGl() {
        Task<Void> glTask = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> NavigationController.this.glMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("docNo", NavigationController.this.docNumber.getText().trim());
                params.put("docDate", NavigationController.this.docDate.getText().trim());
                String response = Config.loadDataFromPhp("masterfetch?type=glnavigate", params, NavigationController.this.getUser());
                ObservableList mEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GLEntry[].class)));
                Platform.runLater(() -> {
                    NavigationController.this.allGlEntries.setItems(mEntries);
                    NavigationController.this.glMasker.setVisible(false);
                });
                NavigationController.this.loadMembers();
                return null;
            }
        };
        Thread glThread = new Thread((Runnable)glTask);
        glThread.setDaemon(true);
        glThread.start();
    }

    public void loadMembers() {
        Task<Void> memberTask = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> NavigationController.this.memberMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("docNo", NavigationController.this.docNumber.getText().trim());
                params.put("docDate", NavigationController.this.docDate.getText().trim());
                String response = Config.loadDataFromPhp("masterfetch?type=membernavigate", params, NavigationController.this.getUser());
                ObservableList mEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GLEntry[].class)));
                Platform.runLater(() -> {
                    NavigationController.this.allMemberEntries.setItems(mEntries);
                    NavigationController.this.memberMasker.setVisible(false);
                });
                NavigationController.this.loadLoans();
                return null;
            }
        };
        Thread memberThread = new Thread((Runnable)memberTask);
        memberThread.setDaemon(true);
        memberThread.start();
    }

    public void loadLoans() {
        Task<Void> loanTask = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> NavigationController.this.loanMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("docNo", NavigationController.this.docNumber.getText().trim());
                params.put("docDate", NavigationController.this.docDate.getText().trim());
                String response = Config.loadDataFromPhp("masterfetch?type=loannavigate", params, NavigationController.this.getUser());
                ObservableList mEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GLEntry[].class)));
                Platform.runLater(() -> {
                    NavigationController.this.allLoanEntries.setItems(mEntries);
                    NavigationController.this.loanMasker.setVisible(false);
                });
                NavigationController.this.loadBanks();
                return null;
            }
        };
        Thread loanThread = new Thread((Runnable)loanTask);
        loanThread.setDaemon(true);
        loanThread.start();
    }

    public void loadBanks() {
        Task<Void> bankTask = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> NavigationController.this.bankMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("docNo", NavigationController.this.docNumber.getText().trim());
                params.put("docDate", NavigationController.this.docDate.getText().trim());
                String response = Config.loadDataFromPhp("masterfetch?type=banknavigate", params, NavigationController.this.getUser());
                ObservableList mEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GLEntry[].class)));
                Platform.runLater(() -> {
                    NavigationController.this.allBankEntries.setItems(mEntries);
                    NavigationController.this.bankMasker.setVisible(false);
                });
                NavigationController.this.loadStaff();
                return null;
            }
        };
        Thread bankThread = new Thread((Runnable)bankTask);
        bankThread.setDaemon(true);
        bankThread.start();
    }

    public void loadStaff() {
        Task<Void> staffTask = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> NavigationController.this.staffMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("docNo", NavigationController.this.docNumber.getText().trim());
                params.put("docDate", NavigationController.this.docDate.getText().trim());
                String response = Config.loadDataFromPhp("masterfetch?type=staffnavigate", params, NavigationController.this.getUser());
                System.out.println(response + " staff response");
                ObservableList mEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GLEntry[].class)));
                Platform.runLater(() -> {
                    NavigationController.this.allStaffEntries.setItems(mEntries);
                    NavigationController.this.staffMasker.setVisible(false);
                });
                NavigationController.this.loadItems();
                return null;
            }
        };
        Thread staffThread = new Thread((Runnable)staffTask);
        staffThread.setDaemon(true);
        staffThread.start();
    }

    public void loadItems() {
        Task<Void> itemTask = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> NavigationController.this.itemMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("docNo", NavigationController.this.docNumber.getText().trim());
                params.put("docDate", NavigationController.this.docDate.getText().trim());
                String response = Config.loadDataFromPhp("masterfetch?type=itemnavigate", params, NavigationController.this.getUser());
                ObservableList mEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GLEntry[].class)));
                Platform.runLater(() -> {
                    NavigationController.this.allItemEntries.setItems(mEntries);
                    NavigationController.this.itemMasker.setVisible(false);
                });
                NavigationController.this.loadCustomer();
                return null;
            }
        };
        Thread itemThread = new Thread((Runnable)itemTask);
        itemThread.setDaemon(true);
        itemThread.start();
    }

    public void loadCustomer() {
        Task<Void> customerTask = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> NavigationController.this.customerMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("docNo", NavigationController.this.docNumber.getText().trim());
                params.put("docDate", NavigationController.this.docDate.getText().trim());
                String response = Config.loadDataFromPhp("masterfetch?type=customernavigate", params, NavigationController.this.getUser());
                System.out.println(response + " customer response");
                ObservableList mEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GLEntry[].class)));
                Platform.runLater(() -> {
                    NavigationController.this.allCustomerEntries.setItems(mEntries);
                    NavigationController.this.customerMasker.setVisible(false);
                });
                NavigationController.this.loadVendors();
                return null;
            }
        };
        Thread customerThread = new Thread((Runnable)customerTask);
        customerThread.setDaemon(true);
        customerThread.start();
    }

    public void loadVendors() {
        Task<Void> vendorTask = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> NavigationController.this.vendorMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("docNo", NavigationController.this.docNumber.getText().trim());
                params.put("docDate", NavigationController.this.docDate.getText().trim());
                String response = Config.loadDataFromPhp("masterfetch?type=vendornavigate", params, NavigationController.this.getUser());
                System.out.println(response + " vendor response");
                ObservableList mEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GLEntry[].class)));
                Platform.runLater(() -> {
                    NavigationController.this.allVendorEntries.setItems(mEntries);
                    NavigationController.this.vendorMasker.setVisible(false);
                });
                return null;
            }
        };
        Thread vendorThread = new Thread((Runnable)vendorTask);
        vendorThread.setDaemon(true);
        vendorThread.start();
    }
}

