/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.MobitillVoucher;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.MobitillCardController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class MobitillVouchersController
implements Initializable {
    private User user;
    private boolean posted;
    @FXML
    private VBox root;
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane details;
    @FXML
    private JFXButton createVoucher;
    @FXML
    private JFXButton editVoucher;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXButton refresh;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableView<MobitillVoucher> allVouchers;
    @FXML
    private TableColumn voucherNo;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TableColumn createdOn;
    @FXML
    private TableColumn totalAmount;
    @FXML
    private MaskerPane masker;
    @FXML
    private HBox searchBox;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        this.loadItems();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.stackPane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.delete.setOnAction(e -> {
            try {
                MobitillVoucher voucher = (MobitillVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                String voucherNo = voucher.getVoucherNo();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucherNo);
                String response = Config.loadDataFromPhp("masterdelete?type=mobitillvoucher", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.loadItems();
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (NullPointerException voucher) {
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.createVoucher.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/mobitillcard.fxml").openStream());
                MobitillCardController controller = (MobitillCardController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setTitle("Create new Mobitill Voucher");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MobitillVouchersController.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.voucherNo.setCellValueFactory((Callback)new PropertyValueFactory("voucherNo"));
        this.createdOn.setCellValueFactory((Callback)new PropertyValueFactory("createdOn"));
        this.totalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalString"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.allVouchers.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    MobitillVoucher rowData = (MobitillVoucher)row.getItem();
                    MobitillVoucher voucher = (MobitillVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                    if (!voucher.equals(null)) {
                        this.editVoucher(voucher);
                    }
                }
            });
            return row;
        });
        this.editVoucher.setOnAction(r -> {
            try {
                MobitillVoucher xm = (MobitillVoucher)this.allVouchers.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getVoucherNo().equals("")) {
                    this.editVoucher(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    public void loadItems() {
        try {
            Platform.runLater(() -> {
                this.masker.setVisible(true);
                this.allVouchers.setItems(new MobitillVoucher().getAllVouchers(this.isPosted(), this.getUser()));
                this.masker.setVisible(false);
            });
        }
        catch (Exception ty) {
            ty.printStackTrace();
        }
    }

    public void editVoucher(MobitillVoucher voucher) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/mobitillcard.fxml").openStream());
            Scene editVoucher = new Scene((Parent)itemPane, 1189.0, 583.0);
            final Stage stage = new Stage();
            editVoucher.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editVoucher);
            MobitillCardController controller = (MobitillCardController)loader.getController();
            controller.setUser(this.getUser());
            controller.setVoucher(voucher);
            stage.setTitle("Edit Mobitill Voucher");
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MobitillVouchersController.this.loadItems();
                        }
                    });
                }
            });
            stage.show();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit mobitill voucher screen. Please contact support");
            alert.showAndWait();
        }
    }
}

