/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Member;
import classes.User;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class MemberSelectionController
implements Initializable {
    private User user;
    @FXML
    MaskerPane masker;
    @FXML
    private JFXTextField search;
    @FXML
    private TableView<Member> allMembers;
    @FXML
    private TableColumn memberNumber;
    @FXML
    private TableColumn memberName;
    @FXML
    private TableColumn phoneNumber;
    @FXML
    private TableColumn email;
    @FXML
    private TableColumn idNumber;
    @FXML
    private TableColumn totalShares;
    @FXML
    private TableColumn totalContributions;
    @FXML
    private JFXButton ok;
    @FXML
    private JFXButton cancel;
    Member member;
    @FXML
    private JFXButton clear;
    ObservableList<Member> myMembers = FXCollections.observableArrayList();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.memberNumber.setCellValueFactory((Callback)new PropertyValueFactory("memberNumber"));
        this.memberName.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
        this.phoneNumber.setCellValueFactory((Callback)new PropertyValueFactory("PhoneNumber"));
        this.email.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.idNumber.setCellValueFactory((Callback)new PropertyValueFactory("idNumber"));
        this.totalShares.setCellValueFactory((Callback)new PropertyValueFactory("shareCapitalString"));
        this.totalContributions.setCellValueFactory((Callback)new PropertyValueFactory("contributionsString"));
        this.clear.setOnAction(e -> this.search.setText(""));
        this.allMembers.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Member rowData = (Member)row.getItem();
                    this.setMember(rowData);
                    Stage stage = (Stage)this.allMembers.getScene().getWindow();
                    stage.close();
                }
            });
            return row;
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            for (int b = 0; b < this.myMembers.size(); ++b) {
                try {
                    Member current = (Member)this.myMembers.get(b);
                    String memberNo = "";
                    try {
                        memberNo = current.getMemberNumber().toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String fullName = "";
                    try {
                        fullName = current.getFullName().toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String idNumber = "";
                    try {
                        idNumber = current.getIdNumber() + "";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String phone = "";
                    try {
                        phone = current.getPhoneNumber().toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String email = "";
                    try {
                        email = current.getEmail().toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String searched = "";
                    try {
                        searched = newValue.toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!fullName.contains(searched) && !idNumber.contains(searched) && !phone.contains(searched) && !email.contains(searched) && !memberNo.contains(searched)) continue;
                    afterSearch.add((Object)current);
                    continue;
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            }
            this.allMembers.getItems().removeAll((Collection)this.allMembers.getItems());
            this.allMembers.setItems(afterSearch);
        });
        this.cancel.setOnAction(e -> {
            try {
                Stage stage = (Stage)this.cancel.getScene().getWindow();
                stage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.ok.setOnAction(e -> {
            try {
                Member myMember = (Member)this.allMembers.getSelectionModel().getSelectedItem();
                String mNumber = myMember.getMemberNumber();
                if (!mNumber.equals(null) && !mNumber.equals("")) {
                    this.setMember(myMember);
                }
                Stage stage = (Stage)this.ok.getScene().getWindow();
                stage.close();
            }
            catch (NullPointerException p) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Please select member");
                alert.setContentText("Please select a member to confirm your selection");
                alert.showAndWait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> MemberSelectionController.this.masker.setVisible(true));
                ObservableList<Member> setMembers = new Member().getAllMembers(MemberSelectionController.this.getUser());
                MemberSelectionController.this.myMembers = new Member().getAllMembers(MemberSelectionController.this.getUser());
                MemberSelectionController.this.allMembers.setItems(setMembers);
                Platform.runLater(() -> MemberSelectionController.this.masker.setVisible(false));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }
}

