/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.LoanSetups;
import classes.Member;
import classes.MemberExit;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class MemberExitController
implements Initializable {
    private User user;
    private MemberExit exit;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label exitNo;
    @FXML
    private DatePicker exitDate;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private Button chooseMember;
    @FXML
    private Label contributions;
    @FXML
    private TextField withdrawalCharge;
    @FXML
    private TextField chequeCommission;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private TextField refundableContributions;
    @FXML
    private TextField chequeNo;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public MemberExit getExit() {
        return this.exit;
    }

    public void setExit(MemberExit exit) {
        this.exit = exit;
        try {
            this.exitNo.setText(exit.getExitNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.exitDate.setValue((Object)Config.stringToLocalDate(exit.getExitDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.member.setValue((Object)exit.getMember());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.withdrawalCharge.setText(exit.getWithdrawalCharge() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.chequeCommission.setText(exit.getChequeCommission() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.refundableContributions.setText(exit.getRefundableContributions() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.chequeNo.setText(exit.getChequeNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bank.setValue((Object)exit.getPayingBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (exit.isPosted()) {
                this.post.setDisable(true);
                this.save.setDisable(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.exitDate.setValue((Object)Config.getCurrentLocaldate());
        LoanSetups ls = new LoanSetups().populate(this.getUser());
        this.withdrawalCharge.setText(ls.getWithdrawalCharge() + "");
        this.chequeCommission.setText(ls.getChequeCommission() + "");
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    MemberExitController.this.notificationPane.setText("Loading values. Please wait....");
                    MemberExitController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    MemberExitController.this.notificationPane.show();
                });
                ObservableList<Member> allMembers = new Member().getAllMembers(MemberExitController.this.getUser());
                MemberExitController.this.member.setItems(allMembers);
                ObservableList<Bank> allBanks = Bank.getAllBanks(MemberExitController.this.getUser());
                MemberExitController.this.bank.setItems(allBanks);
                Platform.runLater(() -> MemberExitController.this.notificationPane.hide());
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
        this.member.setOnAction(e -> {
            try {
                String memberNo = ((Member)this.member.getValue()).getMemberNumber();
                this.getBalance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.post()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.notificationPane.setContent((Node)this.notificationHolder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.member, Validator.createEmptyValidator((String)"Member is required"));
        vs.registerValidator((Control)this.exitDate, Validator.createEmptyValidator((String)"Exit Date is required"));
        this.chooseMember.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String mNo = m.getMemberNumber();
                if (!mNo.equals("") && !mNo.equals(null)) {
                    this.member.setValue((Object)m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
    }

    public void getBalance() {
        String memberNo = "";
        String transcationType = "202";
        try {
            memberNo = ((Member)this.member.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            memberNo = "";
        }
        if (!memberNo.equals(null) && !memberNo.equals("")) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNo", memberNo);
                params.put("transactionType", transcationType);
                String response = Config.loadDataFromPhp("masterfetch?type=memberaccountbalance", params, this.getUser());
                Double[] myValues = (Double[])new Gson().fromJson(response, Double[].class);
                double myContributions = myValues[0];
                this.contributions.setText(Config.formatNumber(myContributions));
                double cCommission = 0.0;
                double wCharge = 0.0;
                try {
                    cCommission = Double.parseDouble(this.chequeCommission.getText().trim());
                }
                catch (Exception r) {
                    cCommission = 0.0;
                }
                try {
                    wCharge = Double.parseDouble(this.withdrawalCharge.getText().trim());
                }
                catch (Exception r) {
                    wCharge = 0.0;
                }
                double refundable = myContributions - (cCommission + wCharge);
                this.refundableContributions.setText(refundable + "");
            }
            catch (NullPointerException params) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We could not be able to compute the member balance");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
    }

    public boolean save() {
        String tExitNo = "";
        String tExitDate = "";
        String tMemberNo = "";
        double tWithdrawalCharge = 0.0;
        double tChequeCommission = 0.0;
        double tRefundableContributions = 0.0;
        String tChequeNo = this.chequeNo.getText().trim();
        int tBankCode = 0;
        boolean error = false;
        boolean newExit = false;
        String message = "";
        NumberSeries ns = new NumberSeries(22, this.getUser());
        try {
            tExitNo = this.exitNo.getText().trim();
            if (tExitNo.equals(null) || tExitNo.equals("") || tExitNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tExitNo = ns.getNextNumber();
            newExit = true;
        }
        try {
            tExitDate = Config.localDateToString((LocalDate)this.exitDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid exit date";
        }
        try {
            tMemberNo = ((Member)this.member.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the member exiting";
        }
        try {
            tBankCode = ((Bank)this.bank.getValue()).getCode();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the bank paying the refundable contributions";
        }
        try {
            tWithdrawalCharge = Double.parseDouble(this.withdrawalCharge.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid Amount for withdrawal charge";
        }
        try {
            tChequeCommission = Double.parseDouble(this.chequeCommission.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid Amount for cheque commission";
        }
        try {
            tRefundableContributions = Double.parseDouble(this.refundableContributions.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid Amount for refundable contributions";
        }
        if (!error) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exitNo", tExitNo);
                params.put("exitDate", tExitDate);
                params.put("memberNo", tMemberNo);
                params.put("withdrawalCharge", tWithdrawalCharge);
                params.put("bankCode", tBankCode);
                params.put("chequeCommission", tChequeCommission);
                params.put("refundableContributions", tRefundableContributions);
                params.put("chequeNo", tChequeNo);
                String response = Config.loadDataFromPhp("mastercreate?type=memberexit", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (newExit) {
                        this.exitNo.setText(tExitNo);
                        ns.updateLastUsed(tExitNo);
                    }
                    return true;
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        } else {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public boolean post() {
        if (this.save()) {
            try {
                String tExitNo = this.exitNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exitNo", tExitNo);
                String response = Config.loadDataFromPhp("masterpost?type=memberexit", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }
}

