/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Loan;
import classes.LoanImport;
import classes.User;
import com.jfoenix.controls.JFXButton;
import controllers.ConfirmLoanImport;
import controllers.LoanApplication;
import controllers.LoanCardController;
import filterscontrollers.LoanMonthlyRepayment;
import filterscontrollers.LoanScheduleFilter;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;

public class LoansRegister
implements Initializable {
    private User user;
    ObservableList<Loan> loansToSearch = FXCollections.observableArrayList();
    private Map<String, Object> params;
    public static Stage confirmImport = new Stage();
    public static Stage stage;
    @FXML
    MaskerPane masker;
    @FXML
    private JFXButton addApplication;
    @FXML
    private JFXButton monthlyStatement;
    @FXML
    private JFXButton loanSchedule;
    @FXML
    private JFXButton repaymentSchedule;
    @FXML
    private JFXButton monthlyLoanRepayment;
    @FXML
    private JFXButton editApplication;
    @FXML
    private JFXButton loanStatement;
    @FXML
    private JFXButton allLoans;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton excelImport;
    @FXML
    private TableView<Loan> allApplicationTable;
    @FXML
    private TableColumn applicationNo;
    @FXML
    private TableColumn applicantName;
    @FXML
    private TableColumn loanBalance;
    @FXML
    private TableColumn applicationLoanProduct;
    @FXML
    private TableColumn applicationAmount;
    @FXML
    private TableColumn applicationDisbursementMethode;
    @FXML
    private TableColumn applicationPayingBank;
    @FXML
    private TableColumn applicationDate;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @FXML
    void onEnter(ActionEvent event) {
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void initialize(URL location, ResourceBundle resources) {
        stage = new Stage();
        this.applicationNo.setCellValueFactory((Callback)new PropertyValueFactory("loanNumber"));
        this.applicantName.setCellValueFactory((Callback)new PropertyValueFactory("member"));
        this.loanBalance.setCellValueFactory((Callback)new PropertyValueFactory("loanBalanceString"));
        this.applicationLoanProduct.setCellValueFactory((Callback)new PropertyValueFactory("loanProduct"));
        this.applicationAmount.setCellValueFactory((Callback)new PropertyValueFactory("loanAmountString"));
        this.applicationDisbursementMethode.setCellValueFactory((Callback)new PropertyValueFactory("loanDisbursementMode"));
        this.applicationPayingBank.setCellValueFactory((Callback)new PropertyValueFactory("payingBank"));
        this.applicationDate.setCellValueFactory((Callback)new PropertyValueFactory("issuedOn"));
        this.clearFilter.setOnAction(e -> {
            this.searchBar.setText("");
            this.loadItems();
        });
        this.searchBar.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("")) {
                try {
                    this.loadItems();
                }
                catch (Exception exception) {}
            } else {
                String searchString = this.searchBar.getText().trim().toLowerCase();
                ObservableList allLoans = FXCollections.observableArrayList();
                for (Loan currentLoan : this.loansToSearch) {
                    String loanAmount = currentLoan.getLoanAmount() + "";
                    String loanBalanceAmount = currentLoan.getLoanBalance() + "";
                    if (!currentLoan.getLoanNumber().toLowerCase().contains(searchString) && !currentLoan.getMember().getFullName().toLowerCase().contains(searchString) && !currentLoan.getLoanAmountString().contains(searchString) && !loanAmount.contains(searchString) && !loanBalanceAmount.contains(searchString) && !currentLoan.getLoanBalanceString().contains(searchString)) continue;
                    allLoans.add((Object)currentLoan);
                }
                this.allApplicationTable.getItems().clear();
                this.allApplicationTable.setItems(allLoans);
            }
        });
        this.allLoans.setOnAction(e -> new Loan().generateAllLoansStatement(this.getUser()));
        this.loanSchedule.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/loanschedulefilter.fxml").openStream());
                LoanScheduleFilter controller = (LoanScheduleFilter)loader.getController();
                controller.setUser(this.getUser());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Loan Schedule Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.monthlyLoanRepayment.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/loanmonthlyrepayment.fxml").openStream());
                LoanMonthlyRepayment controller = (LoanMonthlyRepayment)loader.getController();
                controller.setUser(this.getUser());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Loan Repayment Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.loanStatement.setOnAction(e -> {
            try {
                Loan loan = (Loan)this.allApplicationTable.getSelectionModel().getSelectedItem();
                if (!loan.getLoanNumber().equals("") && !loan.getLoanNumber().equals(null)) {
                    this.loadStatement(loan);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.monthlyStatement.setOnAction(e -> {
            try {
                Loan loan = (Loan)this.allApplicationTable.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("loanNo", loan.getLoanNumber());
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("amountGranted", Config.formatNumber(loan.getLoanAmount()));
                reportParams.put("applicationDate", loan.getApplicationDate());
                reportParams.put("chequeNumber", loan.getCheckNumber());
                reportParams.put("disbursementMode", loan.getLoanDisbursementMode().getDisbursementMethod());
                reportParams.put("loanType", loan.getLoanProduct().getLoanProductName());
                reportParams.put("memberName", loan.getMember().getFullName());
                reportParams.put("memberNumber", loan.getMember().getMemberNumber());
                reportParams.put("loanNo", loan.getLoanNumber());
                new Config().getReport("Loan Monthly Statement", "masterfetch?type=monthlyloanstatement", dataParams, "loanmonthlystatement.jasper", reportParams, this.getUser());
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.repaymentSchedule.setOnAction(e -> {
            try {
                Loan loan = (Loan)this.allApplicationTable.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("loanNo", loan.getLoanNumber());
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("amountGranted", Config.formatNumber(loan.getLoanAmount()));
                reportParams.put("applicationDate", loan.getApplicationDate());
                reportParams.put("chequeNumber", loan.getCheckNumber());
                reportParams.put("disbursementMode", loan.getLoanDisbursementMode().getDisbursementMethod());
                reportParams.put("loanType", loan.getLoanProduct().getLoanProductName());
                reportParams.put("memberName", loan.getMember().getFullName());
                reportParams.put("memberNumber", loan.getMember().getMemberNumber());
                reportParams.put("loanNo", loan.getLoanNumber());
                new Config().getReport("Loan Repayment Schedule", "masterfetch?type=loanrepaymentschedule", dataParams, "loanrepaymentschedule.jasper", reportParams, this.getUser());
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.editApplication.setOnAction(e -> {
            try {
                Loan loan = (Loan)this.allApplicationTable.getSelectionModel().getSelectedItem();
                if (!loan.equals(null)) {
                    this.editLoan(loan, this.getUser());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.allApplicationTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Loan rowData = (Loan)row.getItem();
                    this.editLoan(rowData, this.getUser());
                }
            });
            return row;
        });
        this.excelImport.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                block34: {
                    FileChooser chooser = new FileChooser();
                    File file2 = new File("F:\\IMPORTANT\\kuza\\likana\\");
                    chooser.setInitialDirectory(file2);
                    chooser.setTitle("Select Excel to Import Loans from");
                    chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx", "*.csv"})});
                    try {
                        File file = chooser.showOpenDialog((Window)new Stage());
                        if (file == null) break block34;
                        XSSFWorkbook wb = new XSSFWorkbook(file);
                        XSSFSheet ws = wb.getSheetAt(0);
                        ObservableList toImport = FXCollections.observableArrayList();
                        for (int a = 1; a < ws.getPhysicalNumberOfRows(); ++a) {
                            XSSFRow myRow = ws.getRow(a);
                            try {
                                Cell myCell;
                                LoanImport myImport = new LoanImport();
                                try {
                                    myCell = myRow.getCell(0);
                                    myImport.setLoanNo(myCell.toString());
                                }
                                catch (NullPointerException t) {
                                    continue;
                                }
                                catch (Exception t) {
                                    t.printStackTrace();
                                    myImport.setLoanNo("");
                                }
                                try {
                                    myCell = myRow.getCell(1);
                                    myImport.setMemberNo(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setMemberNo("");
                                }
                                try {
                                    myCell = myRow.getCell(2);
                                    myImport.setMemberName(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setMemberName("");
                                }
                                try {
                                    myCell = myRow.getCell(3);
                                    myImport.setDate(LoansRegister.this.editDate(myCell.toString()));
                                }
                                catch (Exception t) {
                                    myImport.setDate("");
                                }
                                try {
                                    myCell = myRow.getCell(4);
                                    myImport.setPrincipal(Double.parseDouble(myCell.toString()));
                                }
                                catch (Exception t) {
                                    myImport.setPrincipal(0.0);
                                }
                                try {
                                    myCell = myRow.getCell(5);
                                    myImport.setAmountPaid(Double.parseDouble(myCell.toString()));
                                }
                                catch (Exception t) {
                                    myImport.setAmountPaid(0.0);
                                }
                                try {
                                    myCell = myRow.getCell(6);
                                    myImport.setInterest(Double.parseDouble(myCell.toString()));
                                }
                                catch (Exception t) {
                                    myImport.setInterest(0.0);
                                }
                                try {
                                    myCell = myRow.getCell(7);
                                    myImport.setPenalty(Double.parseDouble(myCell.toString()));
                                }
                                catch (Exception t) {
                                    myImport.setPenalty(0.0);
                                }
                                try {
                                    myCell = myRow.getCell(8);
                                    myImport.setPrincipalPaid(Double.parseDouble(myCell.toString()));
                                }
                                catch (Exception t) {
                                    myImport.setPrincipalPaid(0.0);
                                }
                                try {
                                    myCell = myRow.getCell(9);
                                    myImport.setInterestPaid(myImport.getAmountPaid() - myImport.getPrincipalPaid());
                                }
                                catch (Exception t) {
                                    myImport.setInterestPaid(0.0);
                                }
                                try {
                                    myCell = myRow.getCell(11);
                                    myImport.setIssuedOn(LoansRegister.this.editDate(myCell.toString()));
                                }
                                catch (Exception t) {
                                    myImport.setIssuedOn("");
                                }
                                try {
                                    myCell = myRow.getCell(10);
                                    String amountIsued = myCell.toString();
                                    if (!amountIsued.equals("") && !amountIsued.equals(null)) {
                                        myImport.setPrincipal(Double.parseDouble(amountIsued));
                                    }
                                }
                                catch (NullPointerException myCell2) {
                                }
                                catch (Exception t) {
                                    t.printStackTrace();
                                }
                                if (myImport.getLoanNo().trim().equals("") || myImport.getLoanNo().trim().equals(null)) continue;
                                toImport.add((Object)myImport);
                                continue;
                            }
                            catch (NullPointerException myImport) {
                                // empty catch block
                            }
                        }
                        try {
                            FXMLLoader loader = new FXMLLoader();
                            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/confirmLoanImport.fxml").openStream());
                            Scene confirmImportScene = new Scene((Parent)itemPane, 1288.0, 600.0);
                            confirmImportScene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                                public void handle(KeyEvent t) {
                                    KeyCode key = t.getCode();
                                    if (key == KeyCode.ESCAPE) {
                                        confirmImport.close();
                                    }
                                }
                            });
                            confirmImport.setScene(confirmImportScene);
                            ConfirmLoanImport controller = (ConfirmLoanImport)loader.getController();
                            controller.setUser(LoansRegister.this.getUser());
                            controller.setDataSource((ObservableList<LoanImport>)toImport);
                            confirmImport.setTitle("Confirm Loan Import");
                            confirmImport.setResizable(false);
                            confirmImport.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                                public void handle(WindowEvent event) {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            LoansRegister.this.loadItems();
                                        }
                                    });
                                }
                            });
                            confirmImport.showAndWait();
                        }
                        catch (Exception p) {
                            p.printStackTrace();
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle("An error occurred");
                            alert.setHeaderText("An error occurred while loading your confirm  loan import screen. Please contact support");
                            alert.showAndWait();
                        }
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }));
        this.refresh.setOnAction(e -> this.loadItems());
        this.loadItems();
        this.addApplication.setDisable(true);
        this.excelImport.setDisable(true);
        this.delete.setDisable(true);
        this.addApplication.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/loanapplication.fxml").openStream());
                LoanApplication controller = (LoanApplication)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                try {
                    stage.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setScene(scene);
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setTitle("New Loan Application");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LoansRegister.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
    }

    public void loadItems() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LoansRegister.this.masker.setVisible(true);
                LoansRegister.this.allApplicationTable.setItems(new Loan().getAllLoans(LoansRegister.this.getParams(), LoansRegister.this.getUser()));
                LoansRegister.this.loansToSearch = new Loan().getAllLoans(LoansRegister.this.getParams(), LoansRegister.this.getUser());
                LoansRegister.this.masker.setVisible(false);
            }
        });
    }

    public void editLoan(Loan loan, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/loancard.fxml").openStream());
            LoanCardController controller = (LoanCardController)loader.getController();
            controller.setUser(user);
            controller.setLoan(loan);
            Scene addItemScene = new Scene((Parent)itemPane, 912.0, 508.0);
            try {
                stage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setScene(addItemScene);
            stage.setTitle("Edit loan application");
            stage.setResizable(false);
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LoansRegister.this.loadItems();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit loans application screen. Please contact support");
            p.printStackTrace();
            alert.showAndWait();
        }
    }

    public String editDate(String myDate) {
        myDate = myDate.replace("Jan", "01");
        myDate = myDate.replace("Feb", "01");
        myDate = myDate.replace("Mar", "01");
        myDate = myDate.replace("Apr", "01");
        myDate = myDate.replace("May", "01");
        myDate = myDate.replace("Jun", "01");
        myDate = myDate.replace("Jul", "01");
        myDate = myDate.replace("Aug", "01");
        myDate = myDate.replace("Sep", "01");
        myDate = myDate.replace("Oct", "01");
        myDate = myDate.replace("Nov", "01");
        myDate = myDate.replace("Dec", "01");
        String[] info = myDate.split("-");
        myDate = info[2] + "-" + info[1] + "-" + info[0];
        myDate = myDate + (myDate.length() < 1 ? "" : " 00:00:00");
        return myDate;
    }

    public void loadStatement(Loan loan) {
        Platform.runLater(() -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("loanNumber", loan.getLoanNumber());
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", Config.saccoName);
                new Config().getReport("Loan Statement", "masterfetch?type=loanstatement", params, "loanstatement.jasper", parameters2, this.getUser());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

