/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.LoanDisbursementMethods;
import classes.LoanSetups;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class LoanSetupController
implements Initializable {
    private User user;
    @FXML
    private TableView<LoanDisbursementMethods> disbursementModes;
    @FXML
    private TableColumn disbursementMode;
    @FXML
    private TextField defaultPenalty;
    @FXML
    private TextField withdrawalCharge;
    @FXML
    private TextField balancingCharge;
    @FXML
    private TextField crb;
    @FXML
    private TextField chequeCommission;
    @FXML
    private TextField loanForm;
    @FXML
    private TextField gracePeriod;
    @FXML
    AnchorPane paneRoot;
    @FXML
    private TextField insurance;
    @FXML
    private JFXButton saveChanges;
    @FXML
    NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.refresh();
        this.notificationPane.setContent((Node)this.paneRoot);
        this.disbursementMode.setCellValueFactory((Callback)new PropertyValueFactory("disbursementMethod"));
        this.disbursementMode.setCellFactory(TextFieldTableCell.forTableColumn());
        this.disbursementMode.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<LoanDisbursementMethods, String>>(){

            public void handle(TableColumn.CellEditEvent<LoanDisbursementMethods, String> t) {
                block5: {
                    LoanDisbursementMethods pl = (LoanDisbursementMethods)t.getTableView().getItems().get(t.getTablePosition().getRow());
                    int id = pl.getId();
                    String mode = (String)t.getNewValue();
                    try {
                        String path = System.getProperty("user.dir");
                        path = path.replace("\\", "/");
                        String fileLocation = path + "/loading.gif";
                        File file = new File(fileLocation);
                        Image image = new Image(file.toURI().toString());
                        try {
                            Image image2 = new Image(file.toURI().toString());
                            ImageView loader = new ImageView(image2);
                            loader.setFitHeight(30.0);
                            loader.setFitWidth(30.0);
                            LoanSetupController.this.notificationPane.setGraphic((Node)loader);
                            LoanSetupController.this.notificationPane.getStyleClass().add((Object)"dark");
                            LoanSetupController.this.notificationPane.setText("Updating disbursement modes. Please wait...");
                            LoanSetupController.this.notificationPane.show();
                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                            params.put("id", id);
                            params.put("mode", mode);
                            String response2 = Config.loadDataFromPhp("masterupdate?type=disbursementmodes", params, LoanSetupController.this.getUser());
                            Gson g = new Gson();
                            JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                            if (myResponse.isStatus()) {
                                LoanSetupController.this.notificationPane.setText(myResponse.getMessage());
                                LoanSetupController.this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                                LoanSetupController.this.refresh();
                                break block5;
                            }
                            LoanSetupController.this.notificationPane.setText(myResponse.getMessage());
                            LoanSetupController.this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        }
                        catch (Exception p) {
                            p.printStackTrace();
                            LoanSetupController.this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                            FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                            icon.setStyle("-fx-fill: #d32f2f;");
                            icon.setSize("24.0");
                            LoanSetupController.this.notificationPane.setGraphic((Node)icon);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.saveChanges.setOnAction(e -> this.saveGeneralChanges());
    }

    public void refresh() {
        Platform.runLater(() -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                String response2 = Config.loadDataFromPhp("masterfetch?type=loansetups", params, this.getUser());
                Gson g = new Gson();
                LoanSetups ls = (LoanSetups)g.fromJson(response2, LoanSetups.class);
                this.disbursementModes.setItems(FXCollections.observableArrayList(ls.getDisbursementMethods()));
                LoanDisbursementMethods mode = new LoanDisbursementMethods("");
                this.defaultPenalty.setText(ls.getDefaultPenalty() + "");
                this.withdrawalCharge.setText(ls.getWithdrawalCharge() + "");
                this.balancingCharge.setText(ls.getBalancingCharge() + "");
                this.gracePeriod.setText(ls.getGracePeriod() + "");
                this.crb.setText(ls.getCrb() + "");
                this.chequeCommission.setText(ls.getChequeCommission() + "");
                this.loanForm.setText(ls.getLoanForm() + "");
                String myFormula = ls.getInsurance();
                this.insurance.setText(myFormula);
                mode.setId(0);
                this.disbursementModes.getItems().add((Object)mode);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        });
    }

    public void saveGeneralChanges() {
        block5: {
            String tDefaultPenalty = this.defaultPenalty.getText().trim();
            String tWithdrawalCharge = this.withdrawalCharge.getText().trim();
            String tBalancingCharge = this.balancingCharge.getText().trim();
            String tCrb = this.crb.getText().trim();
            String tChequeCommission = this.chequeCommission.getText().trim();
            String tLoanForm = this.loanForm.getText().trim();
            String tInsurance = this.insurance.getText().trim();
            String tGracePeriod = this.gracePeriod.getText().trim();
            try {
                String path = System.getProperty("user.dir");
                path = path.replace("\\", "/");
                String fileLocation = path + "/loading.gif";
                File file = new File(fileLocation);
                Image image = new Image(file.toURI().toString());
                try {
                    Image image2 = new Image(file.toURI().toString());
                    ImageView loader = new ImageView(image2);
                    loader.setFitHeight(30.0);
                    loader.setFitWidth(30.0);
                    this.notificationPane.setGraphic((Node)loader);
                    this.notificationPane.getStyleClass().add((Object)"dark");
                    this.notificationPane.setText("Updating general fees. Please wait...");
                    this.notificationPane.show();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("defaultPenalty", tDefaultPenalty);
                    params.put("withdrawalCharge", tWithdrawalCharge);
                    params.put("balancingCharge", tBalancingCharge);
                    params.put("crb", tCrb);
                    params.put("chequeCommission", tChequeCommission);
                    params.put("loanForm", tLoanForm);
                    params.put("insurance", tInsurance);
                    params.put("graceperiod", tGracePeriod);
                    Gson g = new Gson();
                    String response2 = Config.loadDataFromPhp("masterupdate?type=generalloanfees", params, this.getUser());
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    if (myResponse.isStatus()) {
                        this.notificationPane.setText(myResponse.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                        break block5;
                    }
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                }
                catch (Exception t) {
                    t.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                    icon.setStyle("-fx-fill: #d32f2f;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

