/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.LoanProduct;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import org.controlsfx.control.NotificationPane;

public class LoanProductController
implements Initializable {
    private User user;
    @FXML
    private TextField productCode;
    @FXML
    private TextField productName;
    @FXML
    private TextField minimumAmount;
    @FXML
    private TextField maximumAmount;
    @FXML
    private TextField interestRate;
    @FXML
    private TextField minimumNoOfGuarantors;
    @FXML
    private TextField maximumNoOfGuarantors;
    @FXML
    private TextField contributionMultiplier;
    @FXML
    private TextField minimumInstallments;
    @FXML
    private TextField maximumInstallments;
    @FXML
    private ComboBox<String> calculationMethod;
    @FXML
    private JFXButton addProduct;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private AnchorPane notificationHolder;
    private LoanProduct loanProduct;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public LoanProduct getLoanProduct() {
        return this.loanProduct;
    }

    public void setLoanProduct(LoanProduct loanProduct) {
        this.loanProduct = loanProduct;
        this.productCode.setDisable(true);
        try {
            this.productCode.setText(loanProduct.getLoanProductCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.productName.setText(loanProduct.getLoanProductName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.minimumAmount.setText(loanProduct.getLoanMinimumAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.maximumAmount.setText(loanProduct.getLoanMaximumAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.interestRate.setText(loanProduct.getLoanInterestRate() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.minimumNoOfGuarantors.setText(loanProduct.getLoanMinimumGuarantors() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.maximumNoOfGuarantors.setText(loanProduct.getLoanMaximumGuarantors() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.contributionMultiplier.setText(loanProduct.getLoanShareMultiplicationFactor() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.minimumInstallments.setText(loanProduct.getLoanMinimumInstallments() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.maximumInstallments.setText(loanProduct.getLoanMaximumInstallments() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.calculationMethod.setValue((Object)loanProduct.getLoanCalculationMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        ObservableList calculationMethods = FXCollections.observableArrayList();
        calculationMethods.add((Object)"Reducing Balance");
        calculationMethods.add((Object)"Flat Rate");
        this.calculationMethod.setItems(calculationMethods);
        this.notificationPane.setContent((Node)this.notificationHolder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.addProduct.setOnAction(e -> {
            Boolean error = false;
            String message = "We found the following errors in your form. Please rectify and try again. ";
            String tProductCode = this.productCode.getText().toString().trim();
            try {
                if (tProductCode.equals("") || tProductCode.equals(null)) {
                    throw new NullPointerException();
                }
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid product code";
            }
            String tProductName = this.productName.getText().toString().trim();
            try {
                if (tProductName.equals("") || tProductName.equals(null)) {
                    throw new NullPointerException();
                }
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid product name";
            }
            String tMinimumAmount = this.minimumAmount.getText().trim();
            double mMinimumAmount = 0.0;
            try {
                if (tMinimumAmount.equals("") || tMinimumAmount.equals(null)) {
                    throw new NullPointerException();
                }
                mMinimumAmount = Double.parseDouble(tMinimumAmount);
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid minimum amount";
            }
            catch (NumberFormatException r) {
                error = true;
                message = message + "\n Please provide a valid minimum amount";
            }
            String tMaximumAmount = this.maximumAmount.getText().trim();
            double mMaximumAmount = 0.0;
            try {
                if (tMaximumAmount.equals("") || tMaximumAmount.equals(null)) {
                    throw new NullPointerException();
                }
                mMaximumAmount = Double.parseDouble(tMaximumAmount);
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid maximum amount";
            }
            catch (NumberFormatException r) {
                error = true;
                message = message + "\n Please provide a valid maximum amount";
            }
            String tInterestRate = this.interestRate.getText().trim();
            double mInterestRate = 0.0;
            try {
                if (tInterestRate.equals("") || tInterestRate.equals(null)) {
                    throw new NullPointerException();
                }
                mInterestRate = Double.parseDouble(tInterestRate);
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid interest rate";
            }
            catch (NumberFormatException r) {
                error = true;
                message = message + "\n Please provide a valid interest rate";
            }
            String tMinimumNoOfGuarantors = this.minimumNoOfGuarantors.getText().trim();
            int mMinimumGuarantors = 0;
            try {
                if (tMinimumNoOfGuarantors.equals("") || tMinimumNoOfGuarantors.equals(null)) {
                    throw new NullPointerException();
                }
                mMinimumGuarantors = Integer.parseInt(tMinimumNoOfGuarantors);
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid minimum No. of guarantors";
            }
            catch (NumberFormatException r) {
                error = true;
                message = message + "\n Please provide a valid minimum No. of guarantors";
            }
            String tMaximumNoOfGuarantors = this.maximumNoOfGuarantors.getText().trim();
            int mMaximumGuarantors = 0;
            try {
                if (tMaximumNoOfGuarantors.equals("") || tMaximumNoOfGuarantors.equals(null)) {
                    throw new NullPointerException();
                }
                mMaximumGuarantors = Integer.parseInt(tMaximumNoOfGuarantors);
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid maximum No. of guarantors";
            }
            catch (NumberFormatException r) {
                error = true;
                message = message + "\n Please provide a valid maximum No. of guarantors";
            }
            String tContributionMultiplier = this.contributionMultiplier.getText().trim();
            double mContributionMultiplier = 0.0;
            try {
                if (tContributionMultiplier.equals("") || tContributionMultiplier.equals(null)) {
                    throw new NullPointerException();
                }
                mContributionMultiplier = Double.parseDouble(tContributionMultiplier);
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid share contribution multiplier";
            }
            catch (NumberFormatException r) {
                error = true;
                message = message + "\n Please provide a valid share contribution multiplier";
            }
            String tCalculationMethod = (String)this.calculationMethod.getValue();
            try {
                if (tCalculationMethod.equals("") || tCalculationMethod.equals(null)) {
                    throw new NullPointerException();
                }
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid calculation method";
            }
            String tMinimumInstallments = this.minimumInstallments.getText().trim();
            int mMinimumInstallments = 0;
            try {
                if (tMinimumInstallments.equals("") || tMinimumInstallments.equals(null)) {
                    throw new NullPointerException();
                }
                mMinimumInstallments = Integer.parseInt(tMinimumInstallments);
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid minimum installments";
            }
            catch (NumberFormatException r) {
                error = true;
                message = message + "\n Please provide a valid minimum installments";
            }
            String tMaximumInstallments = this.maximumInstallments.getText().trim();
            int mMaximumInstallments = 0;
            try {
                if (tMaximumInstallments.equals("") || tMaximumInstallments.equals(null)) {
                    throw new NullPointerException();
                }
                mMaximumInstallments = Integer.parseInt(tMaximumInstallments);
            }
            catch (NullPointerException y) {
                error = true;
                message = message + "\n Please provide a valid maximum installments";
            }
            catch (NumberFormatException r) {
                error = true;
                message = message + "\n Please provide a valid maximum installments";
            }
            if (mMinimumAmount > mMaximumAmount) {
                error = true;
                message = message + "\n Minimum amount cannot be greater than maximum amount";
            }
            if (mMinimumInstallments > mMaximumInstallments) {
                error = true;
                message = message + "\n Minimum installments cannot be greater than maximum installments";
            }
            if (mMinimumGuarantors > mMaximumGuarantors) {
                error = true;
                message = message + "\n Minimum guarantors cannot be greater than maximum guarantors";
            }
            if (error.booleanValue()) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            } else {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("productCode", tProductCode);
                    params.put("productName", tProductName);
                    params.put("minimumAmount", mMinimumAmount);
                    params.put("maximumAmount", mMaximumAmount);
                    params.put("minimumInstallments", mMinimumInstallments);
                    params.put("maximumInstallments", mMaximumInstallments);
                    params.put("interestRate", mInterestRate);
                    params.put("calculationMethod", tCalculationMethod);
                    params.put("minimumGuarantors", mMinimumGuarantors);
                    params.put("maximumGuarantors", mMaximumGuarantors);
                    params.put("contributionMultiplier", mContributionMultiplier);
                    String response = Config.loadDataFromPhp("mastercreate?type=loanProduct", params, this.getUser());
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        this.clear();
                    }
                }
                catch (Exception f) {
                    this.notificationPane.setText("We encountered an error while adding the loan product. Please try again later.");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }

    public void clear() {
        this.productCode.setText(null);
        this.productName.setText(null);
        this.minimumAmount.setText(null);
        this.maximumAmount.setText(null);
        this.interestRate.setText(null);
        this.minimumNoOfGuarantors.setText(null);
        this.maximumNoOfGuarantors.setText(null);
        this.contributionMultiplier.setText(null);
        this.calculationMethod.setValue(null);
        this.minimumInstallments.setText(null);
        this.maximumInstallments.setText(null);
    }
}

