/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Guarantor;
import classes.Loan;
import classes.LoanCollateral;
import classes.LoanDisbursementMethods;
import classes.LoanLines;
import classes.LoanProduct;
import classes.Member;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.LoansRegister;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class LoanCardController
implements Initializable {
    private User user;
    @FXML
    TabPane tab2;
    @FXML
    TitledPane generalDetails;
    @FXML
    ScrollPane holder;
    @FXML
    private JFXButton recoverFromShares;
    @FXML
    private JFXButton recoverFromGuarantors;
    @FXML
    private JFXButton recoverFromCollateral;
    @FXML
    TabPane tab;
    @FXML
    private JFXButton loanStatement;
    @FXML
    private JFXButton loanMonthlyStatement;
    @FXML
    private JFXButton loanSchedule;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private AnchorPane notificationRoot;
    @FXML
    private Hyperlink loanNumber;
    @FXML
    private TextField loanAmount;
    @FXML
    private TextField installments;
    @FXML
    private TextField chequeNumber;
    @FXML
    private Hyperlink qualifyingAmount;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private ComboBox<LoanProduct> loanProduct;
    @FXML
    private ComboBox<Bank> payingBank;
    @FXML
    private ComboBox<LoanDisbursementMethods> disbursementMode;
    @FXML
    private TitledPane quarantors;
    @FXML
    private TableView<Guarantor> guarantors;
    @FXML
    private TableColumn colMemberNumber;
    @FXML
    private TableColumn colMemberName;
    @FXML
    private TableColumn colFreeShares;
    @FXML
    private TableColumn colAmountToGuarantee;
    @FXML
    private TableColumn colPercentage;
    @FXML
    private TitledPane collateral;
    @FXML
    private TableView<LoanCollateral> vehicles1;
    @FXML
    private TableColumn colVehicleNumber1;
    @FXML
    private TableColumn colVehicleValue1;
    @FXML
    private TableColumn colLogbookReceived1;
    @FXML
    private TableView<LoanLines> allLedgerEntries;
    @FXML
    private TableColumn transactionDate;
    @FXML
    private TableColumn description;
    @FXML
    private TableColumn debit;
    @FXML
    private TableColumn credit;
    @FXML
    private Button cancel;
    private Loan loan;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        Platform.runLater(() -> {
            ObservableList<LoanLines> allLines = new LoanLines().getLoanLines(loan.getLoanNumber(), this.getUser());
            this.allLedgerEntries.setItems(allLines);
            this.loan = loan;
            this.loanNumber.setText(loan.getLoanNumber());
            this.loanAmount.setText(Config.formatNumber(loan.getLoanAmount()));
            this.installments.setText(loan.getLoanInstallments() + "");
            this.chequeNumber.setText(loan.getCheckNumber());
            this.member.setValue((Object)loan.getMember());
            this.loanProduct.setValue((Object)loan.getLoanProduct());
            this.payingBank.setValue((Object)loan.getPayingBank());
            try {
                this.disbursementMode.setValue((Object)loan.getLoanDisbursementMode());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.qualifyingAmount.setText(Config.formatNumber(loan.getLoanBalance()));
            this.loadCollateral(this.getUser());
            this.loadGuarantors(this.getUser());
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.description.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.credit.setCellValueFactory((Callback)new PropertyValueFactory("creditString"));
        this.debit.setCellValueFactory((Callback)new PropertyValueFactory("debitString"));
        this.transactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDate"));
        this.colMemberName.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
        this.colFreeShares.setCellValueFactory((Callback)new PropertyValueFactory("freeShares"));
        this.colMemberNumber.setCellValueFactory((Callback)new PropertyValueFactory("memberNumber"));
        this.colAmountToGuarantee.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.colPercentage.setCellValueFactory((Callback)new PropertyValueFactory("percentage"));
        this.colVehicleNumber1.setCellValueFactory((Callback)new PropertyValueFactory("regNumber"));
        this.colLogbookReceived1.setCellValueFactory((Callback)new PropertyValueFactory("LogReceived"));
        this.colVehicleValue1.setCellValueFactory((Callback)new PropertyValueFactory("vehicleValueString"));
        this.recoverFromShares.setOnAction(e -> this.recoverLoan(1));
        this.recoverFromGuarantors.setOnAction(e -> this.recoverLoan(2));
        this.recoverFromCollateral.setOnAction(e -> this.recoverLoan(3));
        this.loanStatement.setOnAction(e -> new LoansRegister().loadStatement(this.loan));
        this.loanMonthlyStatement.setOnAction(e -> {
            try {
                Loan loan = this.getLoan();
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("loanNo", loan.getLoanNumber());
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("amountGranted", Config.formatNumber(loan.getLoanAmount()));
                reportParams.put("applicationDate", loan.getApplicationDate());
                reportParams.put("chequeNumber", loan.getCheckNumber());
                reportParams.put("disbursementMode", loan.getLoanDisbursementMode().getDisbursementMethod());
                reportParams.put("loanType", loan.getLoanProduct().getLoanProductName());
                reportParams.put("memberName", loan.getMember().getFullName());
                reportParams.put("memberNumber", loan.getMember().getMemberNumber());
                reportParams.put("loanNo", loan.getLoanNumber());
                new Config().getReport("Loan Monthly Statement", "masterfetch?type=monthlyloanstatement", dataParams, "loanmonthlystatement.jasper", reportParams, this.getUser());
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.loanSchedule.setOnAction(e -> {
            try {
                Loan loan = this.getLoan();
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("loanNo", loan.getLoanNumber());
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("amountGranted", Config.formatNumber(loan.getLoanAmount()));
                reportParams.put("applicationDate", loan.getApplicationDate());
                reportParams.put("chequeNumber", loan.getCheckNumber());
                reportParams.put("disbursementMode", loan.getLoanDisbursementMode().getDisbursementMethod());
                reportParams.put("loanType", loan.getLoanProduct().getLoanProductName());
                reportParams.put("memberName", loan.getMember().getFullName());
                reportParams.put("memberNumber", loan.getMember().getMemberNumber());
                reportParams.put("loanNo", loan.getLoanNumber());
                new Config().getReport("Loan Repayment Schedule", "masterfetch?type=loanrepaymentschedule", dataParams, "loanrepaymentschedule.jasper", reportParams, this.getUser());
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.notificationPane.setContent((Node)this.tab2);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
    }

    public void recoverLoan(int method) {
    }

    public void loadGuarantors(User user) {
        ObservableList allGuarantors = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("loanNumber", this.loanNumber.getText().trim());
            String response2 = Config.loadDataFromPhp("masterfetch?type=loanguarantors", params, user);
            Gson g = new Gson();
            Object[] myGuarantors = (Guarantor[])g.fromJson(response2, Guarantor[].class);
            allGuarantors.addAll((Collection)FXCollections.observableArrayList((Object[])myGuarantors));
        }
        catch (Exception t) {
            t.printStackTrace();
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
            icon.setStyle("-fx-fill: #d32f2f;");
            icon.setSize("24.0");
            this.notificationPane.setGraphic((Node)icon);
        }
        this.guarantors.setItems(allGuarantors);
    }

    public void loadCollateral(User user) {
        ObservableList allCollateral = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("loanNumber", this.loanNumber.getText().trim());
            String response2 = Config.loadDataFromPhp("masterfetch?type=loancollateral", params, user);
            Gson g = new Gson();
            Object[] myCollateral = (LoanCollateral[])g.fromJson(response2, LoanCollateral[].class);
            allCollateral.addAll((Collection)FXCollections.observableArrayList((Object[])myCollateral));
        }
        catch (Exception t) {
            t.printStackTrace();
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
            icon.setStyle("-fx-fill: #d32f2f;");
            icon.setSize("24.0");
            this.notificationPane.setGraphic((Node)icon);
        }
        this.vehicles1.setItems(allCollateral);
    }
}

