/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Loan;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.LoanApplication;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class LoanApplicationList
implements Initializable {
    private User user;
    ObservableList<Loan> loansToSearch = FXCollections.observableArrayList();
    public static Stage stage;
    @FXML
    JFXButton allApplications;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private JFXButton addApplication;
    @FXML
    private JFXButton editApplication;
    @FXML
    private JFXButton deleteLoan;
    @FXML
    private JFXButton refresh;
    @FXML
    private TableView<Loan> allApplicationTable;
    @FXML
    private TableColumn applicationNo;
    @FXML
    private TableColumn applicantName;
    @FXML
    private TableColumn applicantPhoneNo;
    @FXML
    private TableColumn applicationLoanProduct;
    @FXML
    private TableColumn applicationAmount;
    @FXML
    private TableColumn applicationDisbursementMethode;
    @FXML
    private TableColumn applicationPayingBank;
    @FXML
    private TableColumn applicationDate;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @FXML
    void onEnter(ActionEvent event) {
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent(this.allApplicationTable);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        stage = new Stage();
        this.applicationNo.setCellValueFactory((Callback)new PropertyValueFactory("loanNumber"));
        this.applicantName.setCellValueFactory((Callback)new PropertyValueFactory("member"));
        this.applicantPhoneNo.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.applicationLoanProduct.setCellValueFactory((Callback)new PropertyValueFactory("loanProduct"));
        this.applicationAmount.setCellValueFactory((Callback)new PropertyValueFactory("loanAmountString"));
        this.applicationDisbursementMethode.setCellValueFactory((Callback)new PropertyValueFactory("loanDisbursementMode"));
        this.applicationPayingBank.setCellValueFactory((Callback)new PropertyValueFactory("payingBank"));
        this.applicationDate.setCellValueFactory((Callback)new PropertyValueFactory("ApplicationDate"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.clearFilter.setOnAction(e -> {
            this.searchBar.setText("");
            this.loadItems();
        });
        this.searchBar.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("")) {
                try {
                    this.loadItems();
                }
                catch (Exception exception) {}
            } else {
                String searchString = this.searchBar.getText().trim().toLowerCase();
                ObservableList allLoans = FXCollections.observableArrayList();
                for (Loan currentLoan : this.loansToSearch) {
                    String loanAmount = currentLoan.getLoanAmount() + "";
                    String loanBalanceAmount = currentLoan.getLoanBalance() + "";
                    if (!currentLoan.getLoanNumber().toLowerCase().contains(searchString) && !currentLoan.getMember().getFullName().toLowerCase().contains(searchString) && !currentLoan.getLoanAmountString().contains(searchString) && !loanAmount.contains(searchString) && !loanBalanceAmount.contains(searchString) && !currentLoan.getLoanBalanceString().contains(searchString)) continue;
                    allLoans.add((Object)currentLoan);
                }
                this.allApplicationTable.getItems().clear();
                this.allApplicationTable.setItems(allLoans);
            }
        });
        this.allApplications.setOnAction(e -> {
            LinkedHashMap<String, Object> dataVariables = new LinkedHashMap<String, Object>();
            dataVariables.put("issued", 0);
            LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
            reportVariables.put("saccoName", Config.saccoName);
            new Config().getReport("Loan Applications List", "masterfetch?type=loans", dataVariables, "loanapplications.jasper", reportVariables, this.getUser());
        });
        this.editApplication.setOnAction(e -> {
            try {
                Loan loan = (Loan)this.allApplicationTable.getSelectionModel().getSelectedItem();
                if (!loan.equals(null)) {
                    this.editLoan(loan);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.allApplicationTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Loan rowData = (Loan)row.getItem();
                    this.editLoan(rowData);
                }
            });
            return row;
        });
        this.loadItems();
        this.deleteLoan.setOnAction(e -> {
            try {
                String tLoanNo = ((Loan)this.allApplicationTable.getSelectionModel().getSelectedItem()).getLoanNumber();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("loanNo", tLoanNo);
                String response = Config.loadDataFromPhp("masterdelete?type=loanApplication", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.loadItems();
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (NullPointerException tLoanNo) {
            }
            catch (Exception r) {
                this.notificationPane.setText("We encountered an error while processing your request. ");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.addApplication.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/loanapplication.fxml").openStream());
                LoanApplication controller = (LoanApplication)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
                try {
                    stage.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setScene(scene);
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setTitle("New Loan Application");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LoanApplicationList.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
    }

    public void loadItems() {
        Platform.runLater(() -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("issued", 0);
            this.allApplicationTable.setItems(new Loan().getAllLoans(params, this.getUser()));
            this.loansToSearch = new Loan().getAllLoans(params, this.getUser());
        });
    }

    public void editLoan(Loan loan) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/loanapplication.fxml").openStream());
            LoanApplication controller = (LoanApplication)loader.getController();
            controller.setUser(this.getUser());
            controller.setLoan(loan);
            Scene addItemScene = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
            try {
                stage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setScene(addItemScene);
            stage.setTitle("Edit loan application");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LoanApplicationList.this.loadItems();
                        }
                    });
                }
            });
            stage.showAndWait();
            controller.getQualifyingAmount();
        }
        catch (Exception p) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit loans application screen. Please contact support");
            p.printStackTrace();
            alert.showAndWait();
        }
    }
}

