/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Guarantor;
import classes.JsonResponses;
import classes.Loan;
import classes.LoanCollateral;
import classes.LoanDisbursementMethods;
import classes.LoanProduct;
import classes.LoanSetups;
import classes.Member;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import controllers.LoanApplicationList;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class LoanApplication
implements Initializable {
    private User user;
    @FXML
    private ComboBox<String> applicationType;
    @FXML
    private ComboBox<Loan> loanToTopUp;
    @FXML
    Button choosemember;
    @FXML
    Button choosememberGeneral;
    @FXML
    private ComboBox<Member> guarantorMember;
    @FXML
    private DatePicker issuedOn;
    @FXML
    private TextField guarantorAmount;
    @FXML
    private Button addGuarantor;
    @FXML
    TabPane tabpane;
    @FXML
    private NotificationPane notificationPane;
    public static NotificationPane publicNotificationPane = new NotificationPane();
    @FXML
    private Hyperlink loanNumber;
    @FXML
    private TextField loanAmount;
    @FXML
    private TextField installments;
    @FXML
    private TextField chequeNumber;
    @FXML
    private Hyperlink qualifyingAmount;
    @FXML
    private Hyperlink monthlyRepayment;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private TableView<Guarantor> guarantors;
    @FXML
    private TableColumn colMemberNumber;
    @FXML
    private TableColumn colMemberName;
    @FXML
    private TextField vehicleNo;
    @FXML
    private TextField vehicleValue;
    @FXML
    private CheckBox logBookReceived;
    @FXML
    private Button addCollateral;
    @FXML
    private TableColumn colFreeShares;
    @FXML
    private TableColumn colAmountToGuarantee;
    @FXML
    private TableColumn colPercentage;
    @FXML
    private TableView<LoanCollateral> vehicles1;
    @FXML
    private TableColumn colVehicleNumber1;
    @FXML
    private TableColumn colVehicleValue1;
    @FXML
    private TableColumn colLogbookReceived1;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button issue;
    @FXML
    private ComboBox<LoanProduct> loanProduct;
    @FXML
    private ComboBox<Bank> payingBank;
    @FXML
    private ComboBox<LoanDisbursementMethods> disbursementMode;
    @FXML
    private TextField crbCharge;
    @FXML
    private TextField loanForm;
    @FXML
    private TextField chequeCommission;
    @FXML
    private TextField insurance;
    @FXML
    private Label totalCharges;
    @FXML
    private TextField externalDocNo;
    @FXML
    private ComboBox<Bank> receivingBank;
    private Loan loan;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        ObservableList<Member> allMembers = new Member().getAllMembers(this.getUser());
        this.member.setItems(allMembers);
        this.guarantorMember.setItems(allMembers);
        ObservableList<LoanProduct> allProducts = new LoanProduct().getAllLoanProducts(this.getUser());
        this.loanProduct.setItems(allProducts);
        ObservableList<Bank> allBanks = Bank.getAllBanks(this.getUser());
        this.payingBank.setItems(allBanks);
        this.receivingBank.setItems(allBanks);
        LoanSetups ls = new LoanSetups().populate(this.getUser());
        this.loanForm.setText(ls.getLoanForm() + "");
        this.crbCharge.setText(ls.getCrb() + "");
        this.chequeCommission.setText(ls.getChequeCommission() + "");
        ObservableList<LoanDisbursementMethods> methods = new LoanDisbursementMethods().getAllLoanDisbursementMethods(this.getUser());
        this.disbursementMode.setItems(methods);
    }

    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
        this.loanAmount.setText(loan.getLoanAmount() + "");
        this.installments.setText(loan.getLoanInstallments() + "");
        this.chequeNumber.setText(loan.getCheckNumber() + "");
        this.member.setValue((Object)loan.getMember());
        this.populateLoans();
        this.loanProduct.setValue((Object)loan.getLoanProduct());
        this.payingBank.setValue((Object)loan.getPayingBank());
        this.disbursementMode.setValue((Object)loan.getLoanDisbursementMode());
        this.loanNumber.setText(loan.getLoanNumber());
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-d");
            String date = loan.getIssuedOn();
            try {
                LocalDate localDate = LocalDate.parse(date, formatter);
                this.issuedOn.setValue((Object)localDate);
            }
            catch (Exception localDate) {}
        }
        catch (Exception formatter) {
            // empty catch block
        }
        this.loadCollateral();
        this.loadGuarantors();
        this.getQualifyingAmount();
        try {
            double tLoanAmount = loan.getLoanAmount();
            double tInstallments = loan.getLoanInstallments();
            this.insurance.setText(new LoanSetups().computeInsurance(tLoanAmount, tInstallments, this.getUser()) + "");
            this.getMonthlyRepayment();
        }
        catch (Exception tLoanAmount) {
            // empty catch block
        }
        this.crbCharge.setText(loan.getCrbCharge() + "");
        this.chequeCommission.setText(loan.getChequeCommission() + "");
        this.insurance.setText(loan.getInsurance() + "");
        this.loanForm.setText(loan.getLoanForm() + "");
        this.getMonthlyRepayment();
        this.receivingBank.setValue((Object)loan.getChargesReceivingBank());
        this.externalDocNo.setText(loan.getChargesExternalDocNo());
        try {
            if (loan.isLoanTopUp()) {
                this.applicationType.getSelectionModel().select(1);
                this.loanToTopUp.setDisable(false);
            }
        }
        catch (Exception tLoanAmount) {
            // empty catch block
        }
        try {
            String tLNo = loan.getLoanTopUpNo();
            ObservableList loans = this.loanToTopUp.getItems();
            for (Loan loan1 : loans) {
                if (!loan1.getLoanNumber().equalsIgnoreCase(tLNo)) continue;
                this.loanToTopUp.setValue((Object)loan1);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        ObservableList applicationTypes = FXCollections.observableArrayList();
        applicationTypes.add((Object)"New Loan");
        applicationTypes.add((Object)"Loan Top Up");
        this.applicationType.setItems(applicationTypes);
        this.applicationType.getSelectionModel().select(0);
        this.applicationType.setOnAction(e -> {
            String mySelection = ((String)this.applicationType.getValue()).trim();
            if (mySelection.equalsIgnoreCase("New Loan")) {
                this.loanToTopUp.setDisable(true);
            } else {
                this.loanToTopUp.setDisable(false);
            }
        });
        publicNotificationPane = this.notificationPane;
        this.issuedOn.setValue((Object)Config.getCurrentLocaldate());
        this.choosemember.setOnAction(e -> {
            try {
                Member member = new Member().getMemberFromSelection(this.getUser());
                String mNo = member.getMemberNumber();
                this.guarantorMember.setValue((Object)member);
                this.populateLoans();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.choosememberGeneral.setOnAction(e -> {
            try {
                Member member1 = new Member().getMemberFromSelection(this.getUser());
                String mmberNo = member1.getMemberNumber();
                this.member.setValue((Object)member1);
                this.getQualifyingAmount();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.crbCharge, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.loanForm, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.insurance, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.chequeCommission, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.receivingBank, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.member, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.loanProduct, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.loanAmount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.installments, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.disbursementMode, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.payingBank, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.issuedOn, Validator.createEmptyValidator((String)"Required"));
        this.crbCharge = new Config().setDoubleTextField(this.crbCharge);
        this.chequeCommission = new Config().setDoubleTextField(this.chequeCommission);
        this.loanForm = new Config().setDoubleTextField(this.loanForm);
        this.insurance = new Config().setDoubleTextField(this.insurance);
        this.calculateTotalLoanCharges();
        this.insurance.textProperty().addListener((observable, oldValue, newValue) -> this.calculateTotalLoanCharges());
        this.crbCharge.textProperty().addListener((observable, oldValue, newValue) -> this.calculateTotalLoanCharges());
        this.chequeCommission.textProperty().addListener((observable, oldValue, newValue) -> this.calculateTotalLoanCharges());
        this.loanForm.textProperty().addListener((observable, oldValue, newValue) -> this.calculateTotalLoanCharges());
        this.loanAmount.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                double tLoanAmount = Double.parseDouble(newValue.trim());
                double tInstallments = Double.parseDouble(this.installments.getText().trim());
                this.insurance.setText(new LoanSetups().computeInsurance(tLoanAmount, tInstallments, this.getUser()) + "");
                this.getMonthlyRepayment();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.installments.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                double tLoanAmount = Double.parseDouble(this.loanAmount.getText().trim());
                double tInstallments = Double.parseDouble(newValue.trim());
                this.insurance.setText(new LoanSetups().computeInsurance(tLoanAmount, tInstallments, this.getUser()) + "");
                this.getMonthlyRepayment();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.loanProduct.setOnAction(e -> {
            this.getQualifyingAmount();
            this.getMonthlyRepayment();
        });
        this.colMemberName.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
        this.colFreeShares.setCellValueFactory((Callback)new PropertyValueFactory("freeShares"));
        this.colMemberNumber.setCellValueFactory((Callback)new PropertyValueFactory("memberNumber"));
        this.colAmountToGuarantee.setCellValueFactory((Callback)new PropertyValueFactory("editAmount"));
        this.colPercentage.setCellValueFactory((Callback)new PropertyValueFactory("percentage"));
        this.colVehicleNumber1.setCellValueFactory((Callback)new PropertyValueFactory("regNumber"));
        this.colLogbookReceived1.setCellValueFactory((Callback)new PropertyValueFactory("LogReceived"));
        this.colVehicleValue1.setCellValueFactory((Callback)new PropertyValueFactory("vehicleValueString"));
        this.addCollateral.setOnAction(e -> {
            try {
                String tRegNo = this.vehicleNo.getText().trim();
                tRegNo = tRegNo.replace(" ", "");
                double vValue = 0.0;
                boolean error = false;
                String message = "";
                if (!tRegNo.toUpperCase().matches("K[A-Z][A-Z]\\d\\d\\d[A-Z]")) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please provide a valid car registration number";
                }
                try {
                    vValue = Double.parseDouble(this.vehicleValue.getText().trim());
                }
                catch (Exception re) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please provide a valid car value";
                }
                if (!this.logBookReceived.isSelected()) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "To be used as collateral, vehicle logbook must be received";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                } else if (this.saveLoan()) {
                    String loanNo = this.loanNumber.getText().trim();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("loanNo", loanNo);
                    params.put("regNo", tRegNo);
                    params.put("vehicleValue", vValue);
                    params.put("logbookreceived", this.logBookReceived.isSelected() ? 1 : 0);
                    String response = Config.loadDataFromPhp("mastercreate?type=collateral", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.loadCollateral();
                        this.vehicleNo.setText(null);
                        this.vehicleValue.setText(null);
                        this.logBookReceived.setSelected(false);
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception r) {
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                r.printStackTrace();
            }
        });
        ContextMenu menu = new ContextMenu();
        FontAwesomeIconView deleteIcon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        deleteIcon.setStyle("-fx-fill: #d32f2f;");
        deleteIcon.setSize("18.0");
        MenuItem delete = new MenuItem("Delete");
        delete.setGraphic((Node)deleteIcon);
        menu.getItems().add((Object)delete);
        delete.setOnAction(e -> this.updateGuarantor((Guarantor)this.guarantors.getSelectionModel().getSelectedItem(), "delete"));
        this.guarantors.setContextMenu(menu);
        ContextMenu collateralMenu = new ContextMenu();
        MenuItem deleteCollateral = new MenuItem("Delete");
        deleteCollateral.setGraphic((Node)deleteIcon);
        collateralMenu.getItems().add((Object)deleteCollateral);
        deleteCollateral.setOnAction(e -> this.updateCollateral((LoanCollateral)this.vehicles1.getSelectionModel().getSelectedItem(), "delete"));
        this.vehicles1.setContextMenu(collateralMenu);
        this.addGuarantor.setOnAction(e -> {
            try {
                boolean error = false;
                String message = "";
                String guarantorMemberNo = "";
                double amountToGuarantee = 0.0;
                try {
                    guarantorMemberNo = ((Member)this.guarantorMember.getValue()).getMemberNumber();
                    if (guarantorMemberNo.equals(null) || guarantorMemberNo.equals("")) {
                        throw new Exception();
                    }
                }
                catch (Exception f) {
                    error = true;
                    message = "Please select the member guaranteeing the loan";
                }
                try {
                    amountToGuarantee = Double.parseDouble(this.guarantorAmount.getText().trim());
                    if (amountToGuarantee == 0.0 || amountToGuarantee < 0.0) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please enter a valid amount the  member is guaranteeing";
                    }
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter the amount the  member is guaranteeing";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else if (this.saveLoan()) {
                    String loanNo = this.loanNumber.getText().trim();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("loanNo", loanNo);
                    params.put("guarantor", guarantorMemberNo);
                    params.put("amountToGuarantee", amountToGuarantee);
                    String response = Config.loadDataFromPhp("mastercreate?type=guarantor", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.loadGuarantors();
                        this.guarantorMember.setValue(null);
                        this.guarantorAmount.setText("");
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception r) {
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                r.printStackTrace();
            }
        });
        this.save.setOnAction(e -> this.saveLoan());
        this.issue.setOnAction(e -> {
            if (this.saveLoan()) {
                this.issueLoan();
            }
        });
        this.notificationPane.setContent((Node)this.tabpane);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.loanProduct.setOnAction(e -> this.getQualifyingAmount());
        this.member.setOnAction(e -> {
            try {
                Member m = (Member)this.member.getValue();
                this.getQualifyingAmount();
                this.checkMemberActive();
                this.populateLoans();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    public void loadGuarantors() {
        ObservableList allGuarantors = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("loanNumber", this.loanNumber.getText().trim());
            String response2 = Config.loadDataFromPhp("masterfetch?type=loanguarantors", params, this.getUser());
            Gson g = new Gson();
            Object[] myGuarantors = (Guarantor[])g.fromJson(response2, Guarantor[].class);
            allGuarantors.addAll((Collection)FXCollections.observableArrayList((Object[])myGuarantors));
        }
        catch (Exception t) {
            t.printStackTrace();
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
            icon.setStyle("-fx-fill: #d32f2f;");
            icon.setSize("24.0");
            this.notificationPane.setGraphic((Node)icon);
        }
        this.guarantors.setItems(allGuarantors);
        this.getQualifyingAmount();
    }

    public void loadCollateral() {
        ObservableList allCollateral = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("loanNumber", this.loanNumber.getText().trim());
            String response2 = Config.loadDataFromPhp("masterfetch?type=loancollateral", params, this.getUser());
            Gson g = new Gson();
            Object[] myCollateral = (LoanCollateral[])g.fromJson(response2, LoanCollateral[].class);
            allCollateral.addAll((Collection)FXCollections.observableArrayList((Object[])myCollateral));
        }
        catch (Exception t) {
            t.printStackTrace();
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
        }
        this.vehicles1.setItems(allCollateral);
        this.getQualifyingAmount();
    }

    public void getQualifyingAmount() {
        try {
            ObservableList myGuarantors = this.guarantors.getItems();
            ObservableList myCollateral = this.vehicles1.getItems();
            double myContributions = 0.0;
            double myQualifying = 0.0;
            try {
                Member selectedMember = (Member)this.member.getValue();
                myContributions = selectedMember.getShareDeposit();
            }
            catch (Exception e) {
                myContributions = 0.0;
            }
            myQualifying = myContributions;
            double multiplier = 1.0;
            try {
                multiplier = ((LoanProduct)this.loanProduct.getValue()).getLoanShareMultiplicationFactor();
            }
            catch (Exception r) {
                multiplier = 1.0;
            }
            double contWithMultiplier = myContributions * multiplier;
            for (Guarantor g : myGuarantors) {
                myQualifying += g.getAmountDouble();
            }
            if (myCollateral.size() > 0) {
                myQualifying = contWithMultiplier;
            }
            if (myQualifying > contWithMultiplier) {
                myQualifying = contWithMultiplier;
            }
            double toSubtract = 0.0;
            double balancingCharge = 0.0;
            LoanSetups ls = new LoanSetups();
            try {
                balancingCharge = ls.getBalancingCharge();
            }
            catch (Exception e0) {
                balancingCharge = 0.0;
            }
            double penalty = 0.0;
            double interest = 0.0;
            try {
                penalty = ls.getDefaultPenalty() / 100.0;
            }
            catch (Exception r) {
                penalty = 0.0;
            }
            try {
                interest = ((LoanProduct)this.loanProduct.getValue()).getLoanInterestRate() / 100.0;
            }
            catch (Exception r) {
                interest = 0.0;
            }
            double myLoanAmount = 1.0;
            try {
                myLoanAmount = Double.parseDouble(this.loanAmount.getText().trim());
            }
            catch (Exception t) {
                myLoanAmount = 0.0;
            }
            double interestPenalty = (interest + penalty) * 3.0 * myLoanAmount;
            this.qualifyingAmount.setText(Config.formatNumber(myQualifying -= (toSubtract += balancingCharge + interestPenalty)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkMemberActive() {
        this.notificationPane.hide();
        try {
            Member selectedMember = (Member)this.member.getValue();
            String tMemberNo = selectedMember.getMemberNumber();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("memberNo", tMemberNo);
            String response = Config.loadDataFromPhp("masterfetch?type=memberstatus", params, this.getUser());
            JsonResponses[] jr = (JsonResponses[])new Gson().fromJson(response, JsonResponses[].class);
            JsonResponses jr1 = jr[0];
            if (!jr1.isStatus()) {
                this.notificationPane.setText(jr1.getMessage());
                this.notificationPane.setGraphic((Node)jr1.getIconFromStatus());
                this.notificationPane.show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean saveLoan() {
        String tIssuedOn = "";
        String myLoanNumber = "";
        Boolean newLoan = false;
        NumberSeries ns = new NumberSeries(4, this.getUser());
        try {
            myLoanNumber = this.loanNumber.getText().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (myLoanNumber.equals("")) {
            myLoanNumber = ns.getNextNumber();
            newLoan = true;
        }
        String myLoanAmount = "";
        try {
            myLoanAmount = this.loanAmount.getText().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String myinstallments = "";
        try {
            myinstallments = this.installments.getText().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String mychequeNumber = "";
        try {
            mychequeNumber = this.chequeNumber.getText().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String mymember = "";
        try {
            mymember = ((Member)this.member.getValue()).getMemberNumber();
        }
        catch (Exception e) {
            mymember = "";
        }
        String myloanProduct = "";
        try {
            myloanProduct = ((LoanProduct)this.loanProduct.getValue()).getLoanProductCode();
        }
        catch (Exception e) {
            myloanProduct = "";
        }
        String mypayingBank = "";
        try {
            mypayingBank = ((Bank)this.payingBank.getValue()).getCode() + "";
        }
        catch (Exception e) {
            mypayingBank = "";
        }
        String mydisbursementMode = "";
        try {
            mydisbursementMode = ((LoanDisbursementMethods)this.disbursementMode.getValue()).getId() + "";
        }
        catch (Exception e) {
            mydisbursementMode = "";
        }
        try {
            tIssuedOn = ((LocalDate)this.issuedOn.getValue()).toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        double mCrbCharge = 0.0;
        double mChequeCommission = 0.0;
        double mLoanForm = 0.0;
        double mInsurance = 0.0;
        double mMonthlyRepayment = 0.0;
        int mReceivingBankCode = 0;
        String mChargesExternalAccount = "";
        try {
            mCrbCharge = Double.parseDouble(this.crbCharge.getText().trim());
        }
        catch (Exception y) {
            mCrbCharge = 0.0;
        }
        try {
            mChequeCommission = Double.parseDouble(this.chequeCommission.getText().trim());
        }
        catch (Exception y) {
            mChequeCommission = 0.0;
        }
        try {
            mLoanForm = Double.parseDouble(this.loanForm.getText().trim());
        }
        catch (Exception y) {
            mLoanForm = 0.0;
        }
        try {
            mInsurance = Double.parseDouble(this.insurance.getText().trim());
        }
        catch (Exception y) {
            mInsurance = 0.0;
        }
        try {
            mReceivingBankCode = ((Bank)this.receivingBank.getValue()).getCode();
        }
        catch (Exception y) {
            mReceivingBankCode = 0;
        }
        try {
            mMonthlyRepayment = this.getMonthlyRepaymentAmount();
        }
        catch (Exception y) {
            mMonthlyRepayment = 0.0;
        }
        try {
            mChargesExternalAccount = this.externalDocNo.getText().trim();
        }
        catch (Exception y) {
            mChargesExternalAccount = "";
        }
        int tTop = 0;
        String tLoanToTopUp = "";
        try {
            tTop = this.applicationType.getSelectionModel().getSelectedIndex();
        }
        catch (Exception y) {
            tTop = 0;
        }
        try {
            tLoanToTopUp = ((Loan)this.loanToTopUp.getValue()).getLoanNumber();
        }
        catch (Exception y) {
            tLoanToTopUp = "";
        }
        try {
            String path = System.getProperty("user.dir");
            path = path.replace("\\", "/");
            String fileLocation = path + "/loading.gif";
            File file = new File(fileLocation);
            Image image2 = new Image(file.toURI().toString());
            ImageView loader = new ImageView(image2);
            loader.setFitHeight(30.0);
            loader.setFitWidth(30.0);
            this.notificationPane.setGraphic((Node)loader);
            this.notificationPane.setText("Saving the loan. Please wait...");
            this.notificationPane.show();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("loanNumber", myLoanNumber);
            params.put("loanAmount", myLoanAmount);
            params.put("loanInstallments", myinstallments);
            params.put("chequeNumber", mychequeNumber);
            params.put("member", mymember);
            params.put("loanProduct", myloanProduct);
            params.put("payingBank", mypayingBank);
            params.put("disbursementMode", mydisbursementMode);
            params.put("issuedOn", tIssuedOn);
            params.put("crbCharge", mCrbCharge);
            params.put("chequeCommission", mChequeCommission);
            params.put("loanForm", mLoanForm);
            params.put("insurance", mInsurance);
            params.put("monthlyRepayment", mMonthlyRepayment);
            params.put("receivingBankCode", mReceivingBankCode);
            params.put("chargesExternalAccount", mChargesExternalAccount);
            params.put("topup", tTop);
            params.put("topuploanno", tLoanToTopUp);
            Gson g = new Gson();
            String response2 = Config.loadDataFromPhp("mastercreate?type=loan", params, this.getUser());
            JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
            if (myResponse.isStatus()) {
                this.notificationPane.setText(myResponse.getMessage());
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.show();
                if (newLoan.booleanValue()) {
                    ns.updateLastUsed(myLoanNumber);
                }
                this.loanNumber.setText(myLoanNumber);
                return true;
            }
            this.notificationPane.setText(myResponse.getMessage());
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        catch (Exception t) {
            t.printStackTrace();
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public void issueLoan() {
        ProgressIndicator indicate = new ProgressIndicator();
        indicate.setStyle(" -fx-progress-color: #ffffff;");
        this.notificationPane.setGraphic((Node)indicate);
        this.notificationPane.setText("Validating the loan request. Please wait.....");
        this.notificationPane.show();
        this.issue.setDisable(true);
        this.save.setDisable(true);
        this.cancel.setDisable(true);
        double myQualifying = 0.0;
        double requestedAmount = 0.0;
        double requestedInstallments = 0.0;
        boolean error = false;
        String memberNumber = "";
        String message = "";
        String loanProductCode = "";
        int bankCode = 0;
        int receivingBankCode = 0;
        int loanDisbursement = 0;
        String myCheque = "";
        try {
            memberNumber = ((Member)this.member.getValue()).getMemberNumber();
            if (memberNumber.equals(null) || memberNumber.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            memberNumber = "";
            error = true;
            message = "Please select a member to issue the loan";
        }
        try {
            loanProductCode = ((LoanProduct)this.loanProduct.getValue()).getLoanProductCode();
            if (loanProductCode.equals(null) || loanProductCode.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            loanProductCode = "";
            error = true;
            if (message.length() > 0) {
                message = message + "\n";
            }
            message = message + "Please select the loan product you are issuing";
        }
        try {
            requestedAmount = Double.parseDouble(this.loanAmount.getText().trim());
            if (requestedAmount == 0.0) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            requestedAmount = 0.0;
            error = true;
            if (message.length() > 0) {
                message = message + "\n";
            }
            message = message + "Please enter a valid requested amount";
        }
        try {
            requestedInstallments = Double.parseDouble(this.installments.getText().trim());
            if (requestedInstallments == 0.0) {
                throw new Exception();
            }
            try {
                LoanProduct lp = (LoanProduct)this.loanProduct.getValue();
                if (requestedInstallments < (double)lp.getLoanMinimumInstallments()) {
                    error = true;
                    if (message.length() > 0) {
                        message = message + "\n";
                    }
                    message = message + "Number of installments must be more than " + lp.getLoanMinimumInstallments();
                }
                if (requestedInstallments > (double)lp.getLoanMaximumInstallments()) {
                    error = true;
                    if (message.length() > 0) {
                        message = message + "\n";
                    }
                    message = message + "Number of installments must be less than " + lp.getLoanMaximumInstallments();
                }
            }
            catch (Exception lp) {}
        }
        catch (Exception t) {
            requestedInstallments = 0.0;
            error = true;
            if (message.length() > 0) {
                message = message + "\n";
            }
            message = message + "Please enter a valid number of installments";
        }
        try {
            loanDisbursement = ((LoanDisbursementMethods)this.disbursementMode.getValue()).getId();
            if (loanDisbursement == 0) {
                throw new Exception();
            }
        }
        catch (Exception o) {
            loanDisbursement = 0;
            error = true;
            if (message.length() > 0) {
                message = message + "\n";
            }
            message = message + "Please enter a valid loan disbursement mode";
        }
        try {
            bankCode = ((Bank)this.payingBank.getValue()).getCode();
            if (bankCode == 0) {
                throw new Exception();
            }
        }
        catch (Exception o) {
            bankCode = 0;
            error = true;
            if (message.length() > 0) {
                message = message + "\n";
            }
            message = message + "Please select the bank from which to pay the loan";
        }
        try {
            receivingBankCode = ((Bank)this.receivingBank.getValue()).getCode();
            if (receivingBankCode == 0) {
                throw new Exception();
            }
        }
        catch (Exception o) {
            receivingBankCode = 0;
            error = true;
            if (message.length() > 0) {
                message = message + "\n";
            }
            message = message + "Please select the bank receiving the bank charges";
        }
        try {
            myCheque = this.chequeNumber.getText().trim();
        }
        catch (Exception o) {
            myCheque = "";
        }
        ObservableList myLoanGuarantors = this.guarantors.getItems();
        double fromGuarantors = 0.0;
        double fromCollateral = 0.0;
        for (int a = 0; a < myLoanGuarantors.size(); ++a) {
            try {
                fromGuarantors += ((Guarantor)myLoanGuarantors.get((int)a)).amountDouble;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ObservableList myCollateral = this.vehicles1.getItems();
        for (int b = 0; b < myCollateral.size(); ++b) {
            try {
                if (!((LoanCollateral)myCollateral.get(b)).isLogBookReceived()) continue;
                fromCollateral += ((LoanCollateral)myCollateral.get(b)).getVehicleValue();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String errorMessage = message;
        if (error) {
            FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
            icon.setStyle("-fx-fill: #d32f2f;");
            icon.setSize("24.0");
            this.notificationPane.setGraphic((Node)icon);
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
            this.issue.setDisable(false);
            this.save.setDisable(false);
            this.cancel.setDisable(false);
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("loanNumber", this.loanNumber.getText().trim());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterpost?type=loanapplication", params, this.getUser());
                JsonResponses responses = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (responses.isStatus()) {
                    LoanApplicationList.stage.close();
                } else {
                    this.notificationPane.setText(responses.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
    }

    public void updateGuarantor(Guarantor guarantor, String action) {
        this.notificationPane.hide();
        int id = 0;
        try {
            id = guarantor.getId();
        }
        catch (Exception t) {
            id = 0;
        }
        String memberNumber = "";
        try {
            memberNumber = guarantor.getMember().getMemberNumber();
        }
        catch (Exception r) {
            memberNumber = "";
        }
        String lNumber = this.loanNumber.getText();
        double myPercentage = 0.0;
        try {
            myPercentage = guarantor.getPercentageDouble();
        }
        catch (Exception t) {
            myPercentage = 0.0;
        }
        double myAmount = 0.0;
        try {
            myAmount = guarantor.getAmountDouble();
        }
        catch (Exception t) {
            myAmount = 0.0;
        }
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("guarantorId", id);
            params.put("memberNumber", memberNumber);
            params.put("loanNumber", lNumber);
            params.put("percentage", myPercentage);
            params.put("amountToGuaraantee", myAmount);
            params.put("action", action);
            Gson g = new Gson();
            String response2 = Config.loadDataFromPhp("masterupdate?type=guarantors", params, this.getUser());
            JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
            if (myResponse.isStatus()) {
                this.loadGuarantors();
            } else {
                this.notificationPane.setText(myResponse.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
            icon.setStyle("-fx-fill: #d32f2f;");
            icon.setSize("24.0");
            this.notificationPane.setGraphic((Node)icon);
            this.notificationPane.show();
        }
    }

    public void updateCollateral(LoanCollateral collateral, String action) {
        this.notificationPane.hide();
        String lNumber = this.loanNumber.getText();
        int id = 0;
        try {
            id = collateral.getId();
        }
        catch (Exception t) {
            id = 0;
        }
        String vehicleRegNumber = "";
        try {
            vehicleRegNumber = collateral.getRegNumber();
        }
        catch (Exception r) {
            vehicleRegNumber = "";
        }
        double vehicleValue = 0.0;
        try {
            vehicleValue = collateral.getVehicleValue();
        }
        catch (Exception t) {
            vehicleValue = 0.0;
        }
        boolean logbookReceived = false;
        try {
            logbookReceived = collateral.isLogBookReceived();
        }
        catch (Exception t) {
            logbookReceived = false;
        }
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("collateralId", id);
            params.put("regNumber", vehicleRegNumber);
            params.put("loanNumber", lNumber);
            params.put("vehicleValue", vehicleValue);
            params.put("logBookReceived", logbookReceived);
            params.put("action", action);
            String response2 = Config.loadDataFromPhp("masterupdate?type=loancollateral", params, this.getUser());
            Gson g = new Gson();
            JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
            if (myResponse.isStatus()) {
                this.loadCollateral();
            } else {
                this.notificationPane.setText(myResponse.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public double getMonthlyRepaymentAmount() {
        double tLoanAmount = 0.0;
        double tInstallments = 0.0;
        LoanProduct selectedProduct = new LoanProduct();
        try {
            tLoanAmount = Double.parseDouble(this.loanAmount.getText().trim());
        }
        catch (Exception t) {
            tLoanAmount = 0.0;
        }
        try {
            tInstallments = Double.parseDouble(this.installments.getText().trim());
        }
        catch (Exception t) {
            tInstallments = 0.0;
        }
        try {
            selectedProduct = (LoanProduct)this.loanProduct.getValue();
        }
        catch (Exception t) {
            // empty catch block
        }
        if (tLoanAmount != 0.0 && tInstallments != 0.0) {
            try {
                String calculationMethod = selectedProduct.getLoanCalculationMethod();
                if (calculationMethod.equalsIgnoreCase("Flat Rate")) {
                    double totalInterest = tLoanAmount * (selectedProduct.getLoanInterestRate() / 100.0);
                    double mLoanAmount = tLoanAmount + totalInterest;
                    double mMonthlyRepayment = mLoanAmount / tInstallments;
                    return mMonthlyRepayment;
                }
                throw new Exception();
            }
            catch (Exception y) {
                double mInterestRate = 1.0;
                try {
                    mInterestRate = selectedProduct.getLoanInterestRate();
                }
                catch (Exception yt) {
                    mInterestRate = 1.0;
                }
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("interestrate", mInterestRate);
                    params.put("installment", tInstallments);
                    params.put("loanAmount", tLoanAmount);
                    String response = Config.loadDataFromPhp("masterfetch?type=loanmonthlyrepaymentamount", params, this.getUser());
                    Double[] myResponse = (Double[])new Gson().fromJson(response, Double[].class);
                    return myResponse[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return 0.0;
    }

    public void getMonthlyRepayment() {
        this.monthlyRepayment.setText(Config.formatNumber(this.getMonthlyRepaymentAmount()));
    }

    public void calculateTotalLoanCharges() {
        double mCrb = 0.0;
        double mInsurance = 0.0;
        double mChequeCommission = 0.0;
        double mLoanForm = 0.0;
        try {
            mCrb = Double.parseDouble(this.crbCharge.getText().trim());
        }
        catch (Exception h) {
            mCrb = 0.0;
        }
        try {
            mInsurance = Double.parseDouble(this.insurance.getText().trim());
        }
        catch (Exception h) {
            mInsurance = 0.0;
        }
        try {
            mChequeCommission = Double.parseDouble(this.chequeCommission.getText().trim());
        }
        catch (Exception h) {
            mChequeCommission = 0.0;
        }
        try {
            mLoanForm = Double.parseDouble(this.loanForm.getText().trim());
        }
        catch (Exception h) {
            mLoanForm = 0.0;
        }
        this.totalCharges.setText(Config.formatNumber(mCrb + mInsurance + mChequeCommission + mLoanForm));
    }

    public void populateLoans() {
        try {
            Member selectedMember = (Member)this.member.getValue();
            ObservableList<Loan> myLoans = new Loan().getAllLoans(true, selectedMember.getMemberNumber(), this.getUser());
            this.loanToTopUp.setItems(myLoans);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

