/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.PaymentMethod;
import classes.PaymentVoucher;
import classes.Property;
import classes.Units;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class LandlordDisbursementVoucher
implements Initializable {
    ObservableList<Vendor> allVendors = FXCollections.observableArrayList();
    private User user;
    PaymentVoucher paymentVoucher;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label voucherNumber;
    @FXML
    private ComboBox<Vendor> myVendor;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private ComboBox<PaymentMethod> paymentMethod;
    @FXML
    private TextField externalRefNo;
    @FXML
    private DatePicker paymentDate;
    @FXML
    private TextArea beingPaymentFor;
    @FXML
    private ComboBox<Property> property;
    @FXML
    private ComboBox<Units> unit;
    @FXML
    private TextField amount;
    @FXML
    private Hyperlink userName;
    @FXML
    private JFXButton deleteVoucher;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton postVoucher;
    @FXML
    private JFXButton postAndNew;

    public ObservableList<Vendor> getAllVendors() {
        return this.allVendors;
    }

    public void setAllVendors(ObservableList<Vendor> allVendors) {
        this.allVendors = allVendors;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    LandlordDisbursementVoucher.this.notificationPane.setText("Loading Values. Please wait");
                    LandlordDisbursementVoucher.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    LandlordDisbursementVoucher.this.notificationPane.show();
                });
                ObservableList<Property> allProperties = new Property().getAllProperties(user);
                allProperties.sort(Comparator.comparing(Property::getName));
                LandlordDisbursementVoucher.this.property.setItems(allProperties);
                LandlordDisbursementVoucher.this.myVendor.setItems(new Vendor().getAllVendors("landlord", user));
                LandlordDisbursementVoucher.this.bank.setItems(Bank.getAllBanks(user));
                LandlordDisbursementVoucher.this.paymentMethod.setItems(new PaymentMethod().getAllPaymentMethods(user));
                Platform.runLater(() -> LandlordDisbursementVoucher.this.notificationPane.hide());
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public PaymentVoucher getPaymentVoucher() {
        return this.paymentVoucher;
    }

    public void setPaymentVoucher(PaymentVoucher paymentVoucher) {
        this.paymentVoucher = paymentVoucher;
        try {
            this.voucherNumber.setText(paymentVoucher.getPvNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myVendor.setValue((Object)paymentVoucher.getVendor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bank.setValue((Object)paymentVoucher.getBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.paymentMethod.setValue((Object)paymentVoucher.getPaymentMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.externalRefNo.setText(paymentVoucher.getExternalRef());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LocalDate localDate = LocalDate.parse(paymentVoucher.getPaymentDate());
            this.paymentDate.setValue((Object)localDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.beingPaymentFor.setText(paymentVoucher.getPaymentDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.amount.setText(paymentVoucher.getAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (paymentVoucher.isPosted()) {
            this.deleteVoucher.setDisable(true);
            this.postVoucher.setDisable(true);
            this.postAndNew.setDisable(true);
            this.save.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.property.setOnAction(e -> this.myVendor.setValue((Object)((Property)this.property.getValue()).getLandlord()));
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.myVendor, Validator.createEmptyValidator((String)"Please select the vendor"));
        vs.registerValidator(this.bank, Validator.createEmptyValidator((String)"Please select the bank"));
        vs.registerValidator(this.paymentMethod, Validator.createEmptyValidator((String)"Please select the payment method"));
        vs.registerValidator((Control)this.paymentDate, Validator.createEmptyValidator((String)"Please select the payment date"));
        vs.registerValidator((Control)this.beingPaymentFor, Validator.createEmptyValidator((String)"Please enter payment description"));
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Please enter the amount"));
        this.save.setOnAction(e -> this.save());
        this.deleteVoucher.setOnAction(e -> {
            String tVoucherNo = this.voucherNumber.getText().trim();
            if (!tVoucherNo.equals(null) && !tVoucherNo.equals("")) {
                JsonResponses jr = new PaymentVoucher().deletePV(tVoucherNo, this.getUser());
                if (jr.isStatus()) {
                    Stage stage = (Stage)this.deleteVoucher.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            } else {
                Stage stage = (Stage)this.deleteVoucher.getScene().getWindow();
                stage.close();
            }
        });
        this.postVoucher.setOnAction(e -> {
            block6: {
                if (this.save()) {
                    try {
                        String tVoucherNo = this.voucherNumber.getText().trim();
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the payment voucher results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post payment voucher number " + tVoucherNo + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block6;
                        try {
                            JsonResponses jr = new PaymentVoucher().postPV(tVoucherNo, this.getUser());
                            if (jr.isStatus()) {
                                Stage stage = (Stage)this.postVoucher.getScene().getWindow();
                                stage.close();
                                break block6;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                            t.printStackTrace();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
        this.postAndNew.setOnAction(e -> {
            block6: {
                if (this.save()) {
                    try {
                        String tVoucherNo = this.voucherNumber.getText().trim();
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the payment voucher results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post payment voucher number " + tVoucherNo + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block6;
                        try {
                            JsonResponses jr = new PaymentVoucher().postPV(tVoucherNo, this.getUser());
                            if (jr.isStatus()) {
                                Stage stage = (Stage)this.postVoucher.getScene().getWindow();
                                stage.close();
                                this.property.setValue(null);
                                this.myVendor.setValue(null);
                                this.unit.setValue(null);
                                this.paymentMethod.setValue(null);
                                this.paymentDate.setValue(null);
                                this.bank.setValue(null);
                                this.amount.setText("");
                                this.beingPaymentFor.setText("");
                                this.externalRefNo.setText("");
                                break block6;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                            t.printStackTrace();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
        this.amount.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[0123456789.]")) {
                    event.consume();
                }
            }
        });
    }

    public boolean save() {
        String tVoucherNo = "";
        NumberSeries nb = new NumberSeries(11, this.getUser());
        try {
            tVoucherNo = this.voucherNumber.getText().trim();
        }
        catch (Exception e) {
            tVoucherNo = "";
        }
        boolean newVoucher = false;
        if (tVoucherNo.equals("")) {
            tVoucherNo = nb.getNextNumber();
            newVoucher = true;
        }
        String tVendor = "";
        try {
            tVendor = ((Vendor)this.myVendor.getValue()).getVendorNumber();
            if (tVendor.equals(null) || tVendor.trim().equals("")) {
                tVendor = "";
            }
        }
        catch (Exception p) {
            tVendor = "";
        }
        int tBank = 0;
        try {
            tBank = ((Bank)this.bank.getValue()).getCode();
        }
        catch (Exception e) {
            tBank = 0;
        }
        int tPaymentMethod = 0;
        try {
            tPaymentMethod = ((PaymentMethod)this.paymentMethod.getValue()).getCode();
        }
        catch (Exception e) {
            tPaymentMethod = 0;
        }
        String tPaymentRef = this.externalRefNo.getText().trim();
        String tPaymentDate = "";
        try {
            tPaymentDate = ((LocalDate)this.paymentDate.getValue()).toString();
        }
        catch (Exception r) {
            tPaymentDate = "";
        }
        String tPaymentDescription = this.beingPaymentFor.getText().trim();
        String tAmount = this.amount.getText().trim();
        double mAmount = 0.0;
        try {
            mAmount = Double.parseDouble(tAmount);
        }
        catch (Exception r) {
            this.notificationPane.setText("Please enter a valid value for amount");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("voucherNo", tVoucherNo);
            params.put("vendorNo", tVendor);
            params.put("bankCode", tBank);
            params.put("paymentMethod", tPaymentMethod);
            params.put("paymentRef", tPaymentRef);
            params.put("paymentDate", tPaymentDate);
            params.put("paymentDescription", tPaymentDescription);
            params.put("amount", mAmount);
            String response = Config.loadDataFromPhp("mastercreate?type=paymentvoucher", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (newVoucher) {
                nb.updateLastUsed(tVoucherNo);
                this.voucherNumber.setText(jr.getOverLoad1());
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception e) {
            this.notificationPane.setText("We encountered an error while saving the payment voucher. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }
}

