/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.LedgerEntries;
import classes.ShopItem;
import classes.ShopLocation;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class ItemEntriesController
implements Initializable {
    private User user;
    private ShopItem selectedItem;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private ComboBox<ShopLocation> warehouse;
    @FXML
    private ComboBox<ShopItem> item;
    @FXML
    private Button searchItem;
    @FXML
    private DatePicker startDate;
    @FXML
    private DatePicker endDate;
    @FXML
    private Button viewEntries;
    @FXML
    private TableView<LedgerEntries> allEntries;
    @FXML
    private TableColumn colDate;
    @FXML
    private TableColumn colDocNo;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colPurchases;
    @FXML
    private TableColumn colSales;
    @FXML
    private TableColumn colBalance;
    @FXML
    private TableColumn colPostedBy;
    @FXML
    private MaskerPane maskerPane;
    @FXML
    private Label totalLabel;
    @FXML
    private Label totalStockIn;
    @FXML
    private Label totalStockOut;
    @FXML
    private Label stockBalance;
    @FXML
    private Button close;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    ItemEntriesController.this.notificationPane.setText("Loading Values. Please wait");
                    ItemEntriesController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    ItemEntriesController.this.notificationPane.show();
                });
                ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(ItemEntriesController.this.getUser());
                allLocations.sort(Comparator.comparing(ShopLocation::getName));
                ObservableList<ShopItem> allItems = new ShopItem().getAllItems(ItemEntriesController.this.getUser());
                Platform.runLater(() -> {
                    ItemEntriesController.this.item.setItems(allItems);
                    ItemEntriesController.this.warehouse.setItems(allLocations);
                    if (allLocations.size() == 1) {
                        ItemEntriesController.this.warehouse.setValue(allLocations.get(0));
                    }
                    ItemEntriesController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public ShopItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(ShopItem selectedItem) {
        this.selectedItem = selectedItem;
        this.item.setValue((Object)selectedItem);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.endDate.setValue((Object)Config.getCurrentLocaldate());
        this.startDate.setValue((Object)Config.getCurrentLocaldate().minusMonths(1L));
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("transactionDateTime"));
        this.colDocNo.setCellValueFactory((Callback)new PropertyValueFactory("documentNo"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colPurchases.setCellValueFactory((Callback)new PropertyValueFactory("debit"));
        this.colSales.setCellValueFactory((Callback)new PropertyValueFactory("credit"));
        this.colBalance.setCellValueFactory((Callback)new PropertyValueFactory("balance"));
        this.colPostedBy.setCellValueFactory((Callback)new PropertyValueFactory("postedBy"));
        this.totalLabel.prefWidthProperty().bind((ObservableValue)this.colDate.widthProperty().add((ObservableNumberValue)this.colDocNo.widthProperty()).add((ObservableNumberValue)this.colDescription.widthProperty()));
        this.totalStockIn.prefWidthProperty().bind((ObservableValue)this.colPurchases.widthProperty());
        this.totalStockOut.prefWidthProperty().bind((ObservableValue)this.colSales.widthProperty());
        this.stockBalance.prefWidthProperty().bind((ObservableValue)this.colBalance.widthProperty());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.maskerPane.setVisible(false);
        this.item.setOnAction(e -> {});
        this.viewEntries.setOnAction(e -> this.loadItems());
        ContextMenu menu = new ContextMenu();
        MenuItem exportToExcel = new MenuItem("Export to Excel");
        exportToExcel.setOnAction(e -> Config.exportTableToExcel(new Gson().toJson((Object)this.allEntries.getItems()), "itemLedgers"));
        MenuItem refreshMenu = new MenuItem("Refresh");
        refreshMenu.setOnAction(e -> this.loadItems());
        menu.getItems().addAll((Object[])new MenuItem[]{exportToExcel, refreshMenu});
        this.allEntries.setContextMenu(menu);
        this.searchItem.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.item.getItems()), this.getUser());
                this.item.setValue(gson.fromJson(response, ShopItem.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.close.setOnAction(e -> {
            Stage stage = (Stage)this.close.getScene().getWindow();
            stage.close();
        });
    }

    public void loadItems() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> ItemEntriesController.this.maskerPane.setVisible(true));
                ObservableList allData = null;
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("warehouse", ((ShopLocation)ItemEntriesController.this.warehouse.getValue()).getId());
                    params.put("itemNo", ((ShopItem)ItemEntriesController.this.item.getValue()).getCode());
                    params.put("startDate", Config.localDateToString((LocalDate)ItemEntriesController.this.startDate.getValue()));
                    params.put("endDate", Config.localDateToString((LocalDate)ItemEntriesController.this.endDate.getValue()));
                    String response = Config.loadDataFromPhp("masterfetch?type=itemledger", params, ItemEntriesController.this.getUser());
                    System.out.println(response);
                    allData = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, LedgerEntries[].class)));
                }
                catch (NullPointerException y) {
                    ItemEntriesController.this.notificationPane.setText("Please select the warehouse");
                    ItemEntriesController.this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    ItemEntriesController.this.notificationPane.show();
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
                ObservableList myData = allData;
                double tTotalIn = myData.stream().mapToDouble(LedgerEntries::getDebit).sum();
                double tTotalOut = myData.stream().mapToDouble(LedgerEntries::getCredit).sum();
                double balance = tTotalIn - tTotalOut;
                Platform.runLater(() -> {
                    ItemEntriesController.this.totalStockIn.setText(Config.formatNumber(tTotalIn));
                    ItemEntriesController.this.totalStockOut.setText(Config.formatNumber(tTotalOut));
                    ItemEntriesController.this.stockBalance.setText(Config.formatNumber(balance));
                    ItemEntriesController.this.allEntries.setItems(myData);
                    ItemEntriesController.this.maskerPane.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

