/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Month;
import classes.ServiceFeeVoucher;
import classes.User;
import classes.Vehicle;
import classes.Year;
import com.google.gson.Gson;
import controllers.ServiceFeeCardController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class ImportServiceFee
implements Initializable {
    private User user;
    @FXML
    private ComboBox<Month> month;
    @FXML
    private ComboBox<Year> year;
    @FXML
    private Label totalFeeCharged;
    @FXML
    private Hyperlink chooseFile;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableView<ObservableList<String>> allEntries;
    @FXML
    private TableColumn<ObservableList<String>, String> vehicleNo;
    @FXML
    private TableColumn<ObservableList<String>, String> owner;
    @FXML
    private TableColumn<ObservableList<String>, String> monthllyFee;
    @FXML
    private TableColumn<ObservableList<String>, String> noOfInactiveDays;
    @FXML
    private TableColumn<ObservableList<String>, String> feeCharged;
    @FXML
    private MaskerPane masker;
    @FXML
    private Button cancel;
    @FXML
    private Button createVoucher;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.year.setItems(new Year().getAllYears(this.getUser()));
        this.month.setItems(new Month().getAllMonths());
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.stackPane);
        this.vehicleNo.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(0)));
        this.owner.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(1)));
        this.monthllyFee.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(2)));
        this.noOfInactiveDays.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(3)));
        this.feeCharged.setCellValueFactory(param -> new ReadOnlyObjectWrapper(((ObservableList)param.getValue()).get(4)));
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.month, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.year, Validator.createEmptyValidator((String)"Required"));
        this.chooseFile.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Excel to Import Service Fee entries from");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx"})});
            try {
                final File file = chooser.showOpenDialog((Window)new Stage());
                if (file != null) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        BufferedReader br2 = new BufferedReader(new FileReader(file));
                        Task<Void> task = new Task<Void>(){

                            public Void call() throws InterruptedException {
                                Platform.runLater(() -> {
                                    ImportServiceFee.this.masker.setText("Importing entries");
                                    ImportServiceFee.this.masker.setVisible(true);
                                });
                                try {
                                    ImportServiceFee.this.createVoucher.setDisable(true);
                                    XSSFWorkbook wb = new XSSFWorkbook(file);
                                    XSSFSheet ws = wb.getSheetAt(0);
                                    double totalFee = 0.0;
                                    int limit = ws.getPhysicalNumberOfRows();
                                    for (int i = 0; i < ws.getPhysicalNumberOfRows(); ++i) {
                                        XSSFRow myRow = ws.getRow(i);
                                        int j = i + 1;
                                        this.updateProgress(i, limit);
                                        Platform.runLater(() -> {
                                            ImportServiceFee.this.masker.setText("Importing " + Config.formatNumber(j) + "  of " + Config.formatNumber(limit));
                                            ImportServiceFee.this.masker.setVisible(true);
                                        });
                                        try {
                                            String previous;
                                            Cell myCell;
                                            String vehicleRegNo = "";
                                            String vehicleOwner = "";
                                            double previousMonth = 0.0;
                                            double currentMonthPayment = 0.0;
                                            double currentMonthArrears = 0.0;
                                            double adjustedDaysAmount = 0.0;
                                            double arrearsToDate = 0.0;
                                            double adjustedDays = 0.0;
                                            double monthlyAmount = 0.0;
                                            double feeCharged = 0.0;
                                            try {
                                                myCell = myRow.getCell(1);
                                                vehicleRegNo = myCell.toString().trim();
                                                vehicleRegNo = vehicleRegNo.replace(" ", "");
                                                if (vehicleRegNo.length() < 1) {
                                                }
                                            }
                                            catch (Exception t) {}
                                            continue;
                                            try {
                                                vehicleOwner = new Vehicle().getVehicleOwnerName(vehicleRegNo, ImportServiceFee.this.getUser());
                                            }
                                            catch (Exception t) {
                                                // empty catch block
                                            }
                                            try {
                                                myCell = myRow.getCell(2);
                                                previous = myCell.toString().trim();
                                                previousMonth = Double.parseDouble(previous);
                                            }
                                            catch (Exception myCell2) {
                                                // empty catch block
                                            }
                                            try {
                                                myCell = myRow.getCell(3);
                                                previous = myCell.toString().trim();
                                                currentMonthPayment = Double.parseDouble(previous);
                                            }
                                            catch (Exception myCell3) {
                                                // empty catch block
                                            }
                                            try {
                                                myCell = myRow.getCell(4);
                                                previous = myCell.toString().trim();
                                                currentMonthArrears = Double.parseDouble(previous);
                                            }
                                            catch (Exception myCell4) {
                                                // empty catch block
                                            }
                                            try {
                                                myCell = myRow.getCell(5);
                                                previous = myCell.toString().trim();
                                                adjustedDaysAmount = Double.parseDouble(previous);
                                            }
                                            catch (Exception myCell5) {
                                                // empty catch block
                                            }
                                            try {
                                                double myValue;
                                                myCell = myRow.getCell(6);
                                                arrearsToDate = myValue = myCell.getNumericCellValue();
                                            }
                                            catch (Exception t) {
                                                continue;
                                            }
                                            try {
                                                adjustedDays = adjustedDaysAmount / 200.0;
                                            }
                                            catch (Exception t) {
                                                // empty catch block
                                            }
                                            try {
                                                monthlyAmount = arrearsToDate - (previousMonth - currentMonthPayment - currentMonthArrears - adjustedDaysAmount);
                                            }
                                            catch (Exception t) {
                                                // empty catch block
                                            }
                                            try {
                                                feeCharged = monthlyAmount - adjustedDaysAmount;
                                            }
                                            catch (Exception t) {
                                                // empty catch block
                                            }
                                            ObservableList entry = FXCollections.observableArrayList();
                                            entry.add((Object)vehicleRegNo);
                                            entry.add((Object)vehicleOwner);
                                            entry.add((Object)Config.formatNumber(monthlyAmount));
                                            entry.add((Object)Config.formatNumber(adjustedDays));
                                            entry.add((Object)Config.formatNumber(feeCharged));
                                            totalFee += feeCharged;
                                            ImportServiceFee.this.allEntries.getItems().add((Object)entry);
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    double myTotal = totalFee;
                                    Platform.runLater(() -> {
                                        ImportServiceFee.this.createVoucher.setDisable(false);
                                        ImportServiceFee.this.masker.setVisible(false);
                                        ImportServiceFee.this.totalFeeCharged.setText(Config.formatNumber(myTotal));
                                    });
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                return null;
                            }
                        };
                        Thread backgroundThread = new Thread((Runnable)task);
                        backgroundThread.setDaemon(true);
                        this.masker.progressProperty().bind((ObservableValue)task.progressProperty());
                        backgroundThread.start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        });
        this.createVoucher.setOnAction(e -> {
            block15: {
                try {
                    ObservableList myEntries = this.allEntries.getItems();
                    if (myEntries.size() < 1) {
                        this.notificationPane.setText("There are no entries in the table. Please select an excel file before creating the voucher");
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.show();
                        break block15;
                    }
                    int monthCode = 0;
                    int yearCode = 0;
                    boolean error = false;
                    String message = "";
                    try {
                        monthCode = ((Month)this.month.getValue()).getCode();
                    }
                    catch (Exception y) {
                        error = true;
                        message = "Please select a month before creating the voucher";
                    }
                    try {
                        yearCode = ((Year)this.year.getValue()).getYear();
                    }
                    catch (Exception y) {
                        error = true;
                        message = message + (message.length() > 0 ? "\n" : "");
                        message = message + "Please select year before creating the voucher";
                    }
                    if (error) {
                        this.notificationPane.setText(message);
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.show();
                        break block15;
                    }
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("monthCode", monthCode);
                    params.put("yearCode", yearCode);
                    params.put("entries", new Gson().toJson((Object)myEntries));
                    String response = Config.loadDataFromPhp("mastercreate?type=servicefeeimport", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        Stage myStage = (Stage)this.createVoucher.getScene().getWindow();
                        myStage.close();
                        try {
                            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                            alert.setTitle("Open Voucher");
                            alert.setContentText("The Service Fee Voucher was successfully created. Would you like to open it?");
                            Optional result = alert.showAndWait();
                            if (result.get() != ButtonType.OK) break block15;
                            String voucher = jr.getOverLoad1();
                            ServiceFeeVoucher[] vouchers = (ServiceFeeVoucher[])new Gson().fromJson(voucher, ServiceFeeVoucher[].class);
                            ServiceFeeVoucher myVoucher = vouchers[0];
                            try {
                                FXMLLoader loader = new FXMLLoader();
                                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/serviceFeeCard.fxml").openStream());
                                Scene editVoucherScreen = new Scene((Parent)itemPane);
                                final Stage stage = new Stage();
                                editVoucherScreen.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                                    public void handle(KeyEvent t) {
                                        KeyCode key = t.getCode();
                                        if (key == KeyCode.ESCAPE) {
                                            stage.close();
                                        }
                                    }
                                });
                                stage.setScene(editVoucherScreen);
                                ServiceFeeCardController controller = (ServiceFeeCardController)loader.getController();
                                controller.setUser(this.getUser());
                                controller.setVoucher(myVoucher);
                                stage.setTitle("Edit Service Fee Voucher");
                                stage.setResizable(false);
                                try {
                                    stage.initModality(Modality.APPLICATION_MODAL);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                stage.showAndWait();
                                break block15;
                            }
                            catch (Exception p) {
                                p.printStackTrace();
                                Alert alert2 = new Alert(Alert.AlertType.ERROR);
                                alert2.setTitle("An error occurred");
                                alert2.setHeaderText("An error occurred while loading your edit service fee voucher screen. Please contact support");
                                alert2.showAndWait();
                            }
                        }
                        catch (Exception exception) {}
                        break block15;
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }
}

