/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import filterscontrollers.DateRangeFilter;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class GeneralListController<T>
implements Initializable {
    private User user;
    private T obj;
    List<T> toSearch = FXCollections.observableArrayList();
    private Type listType;
    private Map<String, Object> dataParams;
    private String dataUrl;
    private Modality modality;
    private boolean newRecordResizable;
    private String deleteUrl;
    private String type;
    @FXML
    private VBox root;
    @FXML
    private JFXButton newRecord;
    @FXML
    private JFXButton editRecord;
    @FXML
    private JFXButton deleteRecord;
    @FXML
    private NotificationPane notificationPane;
    public static NotificationPane publicNotificationPane = new NotificationPane();
    @FXML
    private StackPane stackPane;
    @FXML
    private JFXButton refresh;
    @FXML
    private HBox searchBox;
    @FXML
    HBox reportsHbox;
    @FXML
    HBox actionsTab;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton datesFilter;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private TableView<T> allEntriesTable;
    @FXML
    private MaskerPane masker;
    @FXML
    private JFXButton excelImport;
    @FXML
    private Separator excelImportSeparator;
    @FXML
    private JFXButton navigatePosting;
    @FXML
    private Separator navigateSeparator;
    private String newRecordNode;
    private double newRecordWidth;
    private double newRecordHeight;
    private String newRecordTitle;
    private LocalDate startDate;
    private LocalDate endDate;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setObject(T t) {
        this.obj = t;
    }

    public void setListType(Type listType) {
        this.listType = listType;
    }

    public String getDeleteUrl() {
        return this.deleteUrl;
    }

    public void setDeleteUrl(String deleteUrl) {
        this.deleteUrl = deleteUrl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNewRecordNode() {
        return this.newRecordNode;
    }

    public void setNewRecordNode(String newRecordNode) {
        this.newRecordNode = newRecordNode;
    }

    public double getNewRecordWidth() {
        return this.newRecordWidth;
    }

    public void setNewRecordWidth(double newRecordWidth) {
        this.newRecordWidth = newRecordWidth;
    }

    public double getNewRecordHeight() {
        return this.newRecordHeight;
    }

    public void setNewRecordHeight(double newRecordHeight) {
        this.newRecordHeight = newRecordHeight;
    }

    public String getNewRecordTitle() {
        return this.newRecordTitle;
    }

    public void setNewRecordTitle(String newRecordTitle) {
        this.newRecordTitle = newRecordTitle;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.stackPane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        publicNotificationPane = this.notificationPane;
        this.excelImport.managedProperty().bind((ObservableValue)this.excelImport.visibleProperty());
        this.excelImportSeparator.managedProperty().bind((ObservableValue)this.excelImportSeparator.visibleProperty());
        this.navigatePosting.managedProperty().bind((ObservableValue)this.navigatePosting.visibleProperty());
        this.navigateSeparator.managedProperty().bind((ObservableValue)this.navigateSeparator.visibleProperty());
        ContextMenu menu = new ContextMenu();
        MenuItem exportToExcel = new MenuItem("Export to Excel");
        exportToExcel.setOnAction(e -> Config.exportTableToExcel(this.allEntriesTable));
        MenuItem newRecordMenu = new MenuItem("New Record");
        MenuItem refreshMenu = new MenuItem("Refresh");
        refreshMenu.setOnAction(e -> this.loadItems());
        newRecordMenu.setOnAction(e -> {});
        menu.getItems().addAll((Object[])new MenuItem[]{exportToExcel, newRecordMenu, refreshMenu});
        this.allEntriesTable.setContextMenu(menu);
        this.refresh.setOnAction(e -> this.loadItems());
        this.clearFilter.setOnAction(e -> {
            this.searchBar.setText("");
            this.loadItems();
        });
        this.searchBar.textProperty().addListener((observable, oldValue, newValue) -> this.searchItems());
        this.excelImport.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FileChooser chooser = new FileChooser();
                chooser.setTitle("Select Excel to Import Entries From");
                chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx", "*.csv"})});
                try {
                    File file = chooser.showOpenDialog((Window)new Stage());
                    if (file != null) {
                        XSSFWorkbook wb = new XSSFWorkbook(file);
                        final XSSFSheet ws = wb.getSheetAt(0);
                        System.out.println("No of rows " + ws.getPhysicalNumberOfRows());
                        Platform.runLater(() -> {
                            GeneralListController.this.masker.setText("Uploading Records. Please wait");
                            GeneralListController.this.masker.setVisible(true);
                        });
                        Task<Void> task1 = new Task<Void>(){

                            public Void call() {
                                int noOfRecords = ws.getPhysicalNumberOfRows();
                                for (int b = 1; b < noOfRecords; ++b) {
                                    int c = b;
                                    this.updateProgress(c + 1, noOfRecords);
                                    Platform.runLater(() -> GeneralListController.this.masker.setText("Uploading Records. Please wait... " + (c + 1) + " of " + noOfRecords));
                                    XSSFRow myRow = ws.getRow(b);
                                    try {
                                        String tColumnDetails;
                                        Cell myCell2;
                                        String tColumn1 = "";
                                        String tColumn2 = "";
                                        String tColumn3 = "";
                                        String tColumn4 = "";
                                        String tColumn5 = "";
                                        String tColumn6 = "";
                                        String tColumn7 = "";
                                        String tColumn8 = "";
                                        String tColumn9 = "";
                                        String tColumn10 = "";
                                        String tColumn11 = "";
                                        String tColumn12 = "";
                                        String tColumn13 = "";
                                        String tColumn14 = "";
                                        String tColumn15 = "";
                                        try {
                                            myCell2 = myRow.getCell(0);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn1 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn1 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell2) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(1);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn2 = tColumnDetails;
                                            }
                                            catch (Exception u) {
                                                tColumn2 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell3) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(2);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn3 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn3 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell4) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(3);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn4 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn4 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell5) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(4);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn5 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn5 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell6) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(5);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn6 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn6 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell7) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(6);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn7 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn7 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell8) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(7);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn8 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn8 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell9) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(8);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn9 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn9 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell10) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(9);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn10 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn10 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell11) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(10);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn11 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn11 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell12) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(11);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn12 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn12 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell13) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(12);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn13 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn13 = tColumnDetails;
                                            }
                                            tColumn13 = tColumnDetails;
                                        }
                                        catch (Exception myCell14) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(13);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn14 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn14 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell15) {
                                            // empty catch block
                                        }
                                        try {
                                            myCell2 = myRow.getCell(14);
                                            tColumnDetails = myCell2.toString().trim();
                                            try {
                                                tColumn15 = Double.parseDouble(tColumnDetails) + "";
                                            }
                                            catch (Exception u) {
                                                tColumn15 = tColumnDetails;
                                            }
                                        }
                                        catch (Exception myCell16) {
                                            // empty catch block
                                        }
                                        try {
                                            LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                                            params2.put("recordType", GeneralListController.this.getType());
                                            params2.put("column1", tColumn1);
                                            params2.put("column2", tColumn2);
                                            params2.put("column3", tColumn3);
                                            params2.put("column4", tColumn4);
                                            params2.put("column5", tColumn5);
                                            params2.put("column6", tColumn6);
                                            params2.put("column7", tColumn7);
                                            params2.put("column8", tColumn8);
                                            params2.put("column9", tColumn9);
                                            params2.put("column10", tColumn10);
                                            params2.put("column11", tColumn11);
                                            params2.put("column12", tColumn12);
                                            params2.put("column13", tColumn13);
                                            params2.put("column14", tColumn14);
                                            params2.put("column15", tColumn15);
                                            String response2 = Config.loadDataFromPhp("mastercreate?type=excelimport", params2, GeneralListController.this.getUser());
                                            System.out.println(response2);
                                        }
                                        catch (Exception o) {
                                            o.printStackTrace();
                                        }
                                        continue;
                                    }
                                    catch (Exception u) {
                                        u.printStackTrace();
                                    }
                                }
                                GeneralListController.this.loadItems();
                                return null;
                            }
                        };
                        Thread backgroundThread = new Thread((Runnable)task1);
                        backgroundThread.setDaemon(true);
                        GeneralListController.this.masker.progressProperty().bind((ObservableValue)task1.progressProperty());
                        backgroundThread.start();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        this.navigatePosting.setOnAction(e -> {
            try {
                Gson g = new Gson();
                String theType = this.getType();
                new Config().navigatePosting(theType, g.toJson(this.allEntriesTable.getSelectionModel().getSelectedItem()), this.getUser());
            }
            catch (NullPointerException g) {
            }
            catch (Exception j) {
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        });
        this.deleteRecord.setOnAction(e -> {
            try {
                Gson g = new Gson();
                Object voucher = this.allEntriesTable.getSelectionModel().getSelectedItem();
                String theObject = g.toJson(voucher);
                String theType = this.getType();
                JsonResponses myResponse = new Config().deleteRecord(theObject, theType, this.getUser());
                if (myResponse.isStatus()) {
                    this.loadItems();
                }
                if (!myResponse.getMessage().equals("") || myResponse.getMessage().equals(null)) {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (NullPointerException g) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while deleting the entry. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.newRecord.setOnAction(e -> this.createNewRecord());
        this.allEntriesTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Object rowData = row.getItem();
                    Object voucher = this.allEntriesTable.getSelectionModel().getSelectedItem();
                    if (!voucher.equals(null)) {
                        this.editRecord(voucher);
                    }
                }
            });
            return row;
        });
        this.editRecord.setOnAction(r -> {
            try {
                Object xm = this.allEntriesTable.getSelectionModel().getSelectedItem();
                if (!xm.equals(null)) {
                    this.editRecord(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.datesFilter.setOnAction(e -> this.getDatesFilter());
    }

    private void searchItems() {
        ObservableList afterSearch = FXCollections.observableArrayList();
        String searchString = this.searchBar.getText().trim().toLowerCase();
        for (int b = 0; b < this.toSearch.size(); ++b) {
            try {
                Gson g = new Gson();
                String current = g.toJson(this.toSearch.get(b));
                current = current.toLowerCase();
                if (!current.contains(searchString)) continue;
                afterSearch.add(this.toSearch.get(b));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.allEntriesTable.getItems().removeAll((Collection)this.allEntriesTable.getItems());
        this.allEntriesTable.setItems(afterSearch);
    }

    public void editRecord(T voucher) {
        Stage stage = new Stage();
        stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GeneralListController.this.loadItems();
                    }
                });
            }
        });
        Gson g = new Gson();
        String theObject = g.toJson(voucher);
        String theType = this.getType();
        new Config().editRecord(theObject, theType, stage, this.getUser());
    }

    public Type getListType() {
        return this.listType;
    }

    public void loadItems() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> GeneralListController.this.masker.setVisible(true));
                try {
                    Map<String, Object> params = GeneralListController.this.getDataParams();
                    try {
                        params.put("filterStartDate", Config.localDateToString(GeneralListController.this.getStartDate()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        params.put("filterEndDate", Config.localDateToString(GeneralListController.this.getEndDate()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String response = Config.loadDataFromPhp(GeneralListController.this.getDataUrl(), params, GeneralListController.this.getUser());
                    List yourClassList = (List)new Gson().fromJson(response, GeneralListController.this.getListType());
                    GeneralListController.this.toSearch = (List)new Gson().fromJson(response, GeneralListController.this.getListType());
                    Platform.runLater(() -> {
                        GeneralListController.this.allEntriesTable.setItems(FXCollections.observableArrayList((Collection)yourClassList));
                        GeneralListController.this.searchItems();
                        GeneralListController.this.masker.setVisible(false);
                    });
                }
                catch (NullPointerException t) {
                    t.printStackTrace();
                    GeneralListController.this.masker.setVisible(false);
                }
                catch (Exception t) {
                    Platform.runLater(() -> {
                        GeneralListController.this.notificationPane.setText("We encountered an error while loading your data. Please refresh");
                        GeneralListController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        GeneralListController.this.notificationPane.show();
                        GeneralListController.this.masker.setVisible(false);
                    });
                    t.printStackTrace();
                }
                Platform.runLater(() -> {});
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void addTableColumn(String columnText, String propertyText, double width) {
        TableColumn myColumn = new TableColumn();
        myColumn.setText(columnText);
        myColumn.setCellValueFactory((Callback)new PropertyValueFactory(propertyText));
        myColumn.prefWidthProperty().bind((ObservableValue)this.allEntriesTable.widthProperty().multiply(width));
        this.allEntriesTable.getColumns().add((Object)myColumn);
    }

    public void addNumericTableColumn(String columnText, String propertyText, double width) {
        TableColumn myColumn = new TableColumn();
        myColumn.setText(columnText);
        myColumn.setSortable(true);
        myColumn.setCellValueFactory((Callback)new PropertyValueFactory(propertyText));
        myColumn.prefWidthProperty().bind((ObservableValue)this.allEntriesTable.widthProperty().multiply(width));
        Config.sortNumericalColumn(myColumn);
        this.allEntriesTable.getColumns().add((Object)myColumn);
    }

    public void addHyperlinkTableColumn(String columnText, String propertyText, double width) {
        TableColumn myColumn = new TableColumn();
        myColumn.setText(columnText);
        myColumn.setSortable(true);
        myColumn.setCellValueFactory((Callback)new PropertyValueFactory(propertyText));
        myColumn.prefWidthProperty().bind((ObservableValue)this.allEntriesTable.widthProperty().multiply(width));
        Config.sortHyperlinkColumn(myColumn);
        this.allEntriesTable.getColumns().add((Object)myColumn);
    }

    public void setSearchPromptText(String text) {
        this.searchBar.setPromptText(text);
    }

    public Map<String, Object> getDataParams() {
        return this.dataParams;
    }

    public void setDataParams(Map<String, Object> dataParams) {
        this.dataParams = dataParams;
        this.loadItems();
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public void setNewRecordText(String text) {
        this.newRecord.setText(text);
    }

    public void setDeleteRecordText(String text) {
        this.deleteRecord.setText(text);
    }

    public void setEditRecordText(String text) {
        this.editRecord.setText(text);
    }

    public void setRefreshRecordText(String text) {
        this.refresh.setText(text);
    }

    public void setNewRecordEnabled(boolean enabled) {
        this.newRecord.setDisable(!enabled);
    }

    public void setDeleteRecordEnabled(boolean enabled) {
        this.deleteRecord.setDisable(!enabled);
    }

    public void setEditRecordEnabled(boolean enabled) {
        this.editRecord.setDisable(!enabled);
    }

    public void setRefreshRecordEnabled(boolean enabled) {
        this.refresh.setDisable(!enabled);
    }

    public void setModality(Modality modality) {
        this.modality = modality;
    }

    public void setNewRecordResizable(boolean resizable) {
        this.newRecordResizable = resizable;
    }

    public void addRecordActionButton(JFXButton button, String action) {
        Separator sep = new Separator();
        sep.setOrientation(Orientation.VERTICAL);
        button.setOnAction(e -> {
            try {
                Stage stage = new Stage();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                GeneralListController.this.loadItems();
                            }
                        });
                    }
                });
                Gson g = new Gson();
                Object xm = this.allEntriesTable.getSelectionModel().getSelectedItem();
                if (!xm.equals(null)) {
                    String json = g.toJson(xm);
                    new Config().performRecordAction(action, stage, json, this.getUser());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.actionsTab.getChildren().add((Object)button);
        this.actionsTab.getChildren().add((Object)sep);
    }

    public void addRecordReport(JFXButton button, String reportName, String reportURl, Map<String, Object> reportVariables) {
        Separator sep = new Separator();
        sep.setOrientation(Orientation.VERTICAL);
        if (this.reportsHbox.getChildren().size() > 0) {
            this.reportsHbox.getChildren().add((Object)sep);
        }
        this.reportsHbox.getChildren().add((Object)button);
        button.setOnAction(e -> {
            try {
                Gson g = new Gson();
                Object xm = this.allEntriesTable.getSelectionModel().getSelectedItem();
                if (!xm.equals(null)) {
                    String json = g.toJson(xm);
                    new Config().getReportWithJson(reportName, json, reportURl, reportVariables);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void addRecordButton(JFXButton button, String reportType) {
        Separator sep = new Separator();
        sep.setOrientation(Orientation.VERTICAL);
        if (this.reportsHbox.getChildren().size() > 0) {
            this.reportsHbox.getChildren().add((Object)sep);
        }
        this.reportsHbox.getChildren().add((Object)button);
        button.setOnAction(e -> {
            try {
                Gson g = new Gson();
                Object xm = this.allEntriesTable.getSelectionModel().getSelectedItem();
                if (!xm.equals(null)) {
                    String json = g.toJson(xm);
                    System.out.println(reportType);
                    new Config().generateReport(reportType, json, this.getUser());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void addNonRecordButton(JFXButton button, String reportType) {
        Separator sep = new Separator();
        sep.setOrientation(Orientation.VERTICAL);
        if (this.reportsHbox.getChildren().size() > 0) {
            this.reportsHbox.getChildren().add((Object)sep);
        }
        this.reportsHbox.getChildren().add((Object)button);
        button.setOnAction(e -> {
            try {
                new Config().generateReport(reportType, this.getUser());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void showNavigatePosting() {
        this.navigatePosting.setVisible(true);
        this.navigateSeparator.setVisible(true);
    }

    public void showDatesFilters(int dateRange) {
        LocalDate startDate = Config.getCurrentLocaldate().minusDays(dateRange);
        LocalDate endDate = Config.getCurrentLocaldate();
        this.searchBar.prefWidthProperty().bind((ObservableValue)this.searchBox.widthProperty().multiply(0.78));
        this.datesFilter.setVisible(true);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
        String displayDate = "";
        try {
            displayDate = Config.localDateToString(startDate);
            this.setStartDate(startDate);
        }
        catch (Exception u) {
            this.setStartDate(null);
        }
        displayDate = displayDate + "..";
        try {
            displayDate = displayDate + Config.localDateToString(endDate);
            this.setEndDate(endDate);
        }
        catch (Exception y) {
            this.setEndDate(null);
        }
        this.datesFilter.setText(displayDate);
    }

    public void getDatesFilter() {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/daterangefilter.fxml").openStream());
            DateRangeFilter controller = (DateRangeFilter)loader.getController();
            try {
                controller.setStartDate(this.getStartDate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                controller.setEndDate(this.getEndDate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Scene addItemScene = new Scene((Parent)itemPane);
            Stage memberSelectionStage = new Stage();
            memberSelectionStage.setScene(addItemScene);
            memberSelectionStage.setTitle("Date Range Filter");
            memberSelectionStage.setResizable(false);
            try {
                memberSelectionStage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            memberSelectionStage.showAndWait();
            String displayDate = "";
            try {
                LocalDate startDate = controller.getStartDate();
                displayDate = Config.localDateToString(startDate);
                this.setStartDate(startDate);
            }
            catch (Exception u) {
                this.setStartDate(null);
            }
            displayDate = displayDate + "..";
            try {
                LocalDate endDate = controller.getEndDate();
                displayDate = displayDate + Config.localDateToString(endDate);
                this.setEndDate(endDate);
            }
            catch (Exception y) {
                this.setEndDate(null);
            }
            this.datesFilter.setText(displayDate);
            this.loadItems();
        }
        catch (Exception p) {
            this.notificationPane.setText("An error occurred while loading your dates filter screen. Please contact support");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
            p.printStackTrace();
        }
    }

    private void createNewRecord() {
        try {
            Stage stage = new Stage();
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GeneralListController.this.loadItems();
                        }
                    });
                }
            });
            Gson g = new Gson();
            String theType = this.getType();
            new Config().newRecord(theType, stage, this.getUser());
        }
        catch (Exception y) {
            this.notificationPane.setText("We experienced an error while loading your new record screen. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void allowExcelImport() {
        this.excelImport.setVisible(true);
        this.excelImportSeparator.setVisible(true);
    }
}

