/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.User;
import controllers.PNLViewController;
import controllers.ProfitAndLossController;
import filterscontrollers.BSFilter;
import filterscontrollers.GLAccountFilter;
import filterscontrollers.PNLFilter;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Hyperlink;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class FinancialReportsController
implements Initializable {
    private User user;
    @FXML
    private Hyperlink trialBalance;
    @FXML
    private Hyperlink pnlView;
    @FXML
    private Hyperlink profitAndLossStatementSalesRep;
    @FXML
    private Hyperlink profitAndLossStatementPerRegion;
    @FXML
    private Hyperlink profitAndLossStatementGlobal;
    @FXML
    private Hyperlink balanceSheetMinimized;
    @FXML
    private Hyperlink balanceSheetDetailed;
    @FXML
    private Hyperlink generalLedger;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.pnlView.setOnAction(e -> {
            try {
                Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/pnl_view.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed(t -> {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                });
                stage.setScene(scene);
                PNLViewController controller = (PNLViewController)loader.getController();
                controller.setUser(this.getUser());
                stage.setTitle("PNL View");
                stage.setResizable(true);
                stage.show();
            }
            catch (NullPointerException stage) {
            }
            catch (Exception i) {
                i.printStackTrace();
            }
            this.pnlView.setVisited(false);
        });
        this.profitAndLossStatementSalesRep.setOnAction(e -> {
            try {
                final Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/profit_and_loss.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                ProfitAndLossController controller = (ProfitAndLossController)loader.getController();
                controller.setUser(this.getUser());
                stage.setTitle("Profit and Loss Statement");
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your profit and loss screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.profitAndLossStatementGlobal.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/pnlfilter.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                PNLFilter controller = (PNLFilter)loader.getController();
                controller.setUser(this.getUser());
                stage.setTitle("Profit And Loss Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.balanceSheetMinimized.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/bsfilter.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                BSFilter controller = (BSFilter)loader.getController();
                controller.setReportName("balance_sheet_minimized");
                controller.setUser(this.getUser());
                stage.setTitle("Balance Sheet Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.balanceSheetDetailed.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/bsfilter.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                BSFilter controller = (BSFilter)loader.getController();
                controller.setReportName("balance_sheet_detailed");
                controller.setUser(this.getUser());
                stage.setTitle("Balance Sheet Filter");
                stage.setResizable(false);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.trialBalance.setOnAction(e -> {
            try {
                Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/glaccountfilter.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed(t -> {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                });
                stage.setScene(scene);
                GLAccountFilter controller = (GLAccountFilter)loader.getController();
                controller.setReportName("trialbalance");
                controller.setUser(this.getUser());
                stage.setTitle("Trial Balance");
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.showAndWait();
            }
            catch (NullPointerException stage) {
            }
            catch (Exception i) {
                i.printStackTrace();
            }
        });
        this.generalLedger.setOnAction(e -> {
            try {
                Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/glaccountfilter.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed(t -> {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                });
                stage.setScene(scene);
                GLAccountFilter controller = (GLAccountFilter)loader.getController();
                controller.setReportName("generalledger");
                controller.setUser(this.getUser());
                stage.setTitle("General Ledger");
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.showAndWait();
            }
            catch (NullPointerException stage) {
            }
            catch (Exception i) {
                i.printStackTrace();
            }
        });
    }
}

