/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.SalesHeader;
import classes.User;
import com.google.gson.Gson;
import controllers.ClosingStockController;
import controllers.GeneralListController;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class EndOfDayController
implements Initializable {
    private User user;
    private SalesHeader header;
    private String docType;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label docNo;
    @FXML
    private Label vsmName;
    @FXML
    private Label requestDate;
    @FXML
    private TableView<HashMap> allEntries;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colItemName;
    @FXML
    private TableColumn colOpeningStock;
    @FXML
    private TableColumn colIssuedStock;
    @FXML
    private TableColumn colConfirmedSales;
    @FXML
    private TableColumn colSales;
    @FXML
    private TableColumn colWarehouseReturn;
    @FXML
    private TableColumn colMissingBottles;
    @FXML
    private TableColumn colClosingStock;
    @FXML
    private MaskerPane masker;
    @FXML
    private TableView<HashMap> allPayments;
    @FXML
    private TableColumn colPaymentMode;
    @FXML
    private TableColumn colDeclaredAmount;
    @FXML
    private TableColumn colCustomerCode;
    @FXML
    private TableColumn colCustomerName;
    @FXML
    private TableColumn colInvoiceNo;
    @FXML
    private TableColumn colProduct;
    @FXML
    private TableColumn colQuantity;
    @FXML
    private TableColumn colDiscount;
    @FXML
    private TableColumn colConfirmedAmount;
    @FXML
    private MaskerPane paymentsMasker;
    @FXML
    private Label computedSales;
    @FXML
    private Label declaredPayments;
    @FXML
    private Label variance;
    @FXML
    private Button cancel;
    @FXML
    private Button approve;
    @FXML
    private HBox warehouseApproval;
    @FXML
    private HBox superUserHBox;
    @FXML
    private Button superUserCancel;
    @FXML
    private Button superUserApprove;
    @FXML
    private HBox accountsUserHBox;
    @FXML
    private Button accountsCancel;
    @FXML
    private Button accountsApprove;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public SalesHeader getHeader() {
        return this.header;
    }

    public void setHeader(SalesHeader header) {
        this.header = header;
        System.out.println(new Gson().toJson((Object)header));
        this.docNo.setText(header.getDoc_no());
        this.vsmName.setText(header.getUserFullName());
        this.requestDate.setText(header.getSales_date());
        this.loadLines();
        boolean warehouseApproved = header.isPosted();
        boolean superUserApproved = header.isConfirmedBySuperUser();
        boolean accountsApproved = header.isConfirmedByAccounts();
        if (header.getStatus().equalsIgnoreCase("Approved")) {
            warehouseApproved = true;
        }
        this.warehouseApproval.setVisible(false);
        this.superUserHBox.setVisible(false);
        this.accountsUserHBox.setVisible(false);
        if (warehouseApproved) {
            if (superUserApproved) {
                if (!accountsApproved) {
                    this.accountsUserHBox.setVisible(true);
                }
            } else {
                this.superUserHBox.setVisible(true);
            }
        } else {
            this.warehouseApproval.setVisible(true);
        }
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        Callback numberFormatCellFactoryForMap = p -> new TextFieldTableCell(new StringConverter(){

            public String toString(Object t) {
                try {
                    return Config.formatNumber(Double.parseDouble(t.toString()));
                }
                catch (NullPointerException u) {
                    return "0";
                }
                catch (Exception u) {
                    return t.toString();
                }
            }

            public Object fromString(String string) {
                return null;
            }
        });
        Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>> cellFactory = new Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>>(){

            public TableCell<HashMap, HashMap> call(TableColumn<HashMap, HashMap> param) {
                TableCell<HashMap, HashMap> cell = new TableCell<HashMap, HashMap>(){
                    private final Hyperlink btn = new Hyperlink("Edit");
                    {
                        this.btn.setOnAction(e -> {
                            HashMap data = (HashMap)this.getTableView().getItems().get(this.getIndex());
                            EndOfDayController.this.editEntry(data);
                        });
                    }

                    public void updateItem(HashMap item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            double requestedAmount = 0.0;
                            try {
                                requestedAmount = Double.parseDouble(item.get("closing_stock").toString());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.btn.setText(Config.formatNumber(requestedAmount));
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colClosingStock.setCellFactory((Callback)cellFactory);
        this.colClosingStock.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.colItemCode.setCellValueFactory((Callback)new MapValueFactory((Object)"itemNo"));
        this.colItemName.setCellValueFactory((Callback)new MapValueFactory((Object)"description"));
        this.colPaymentMode.setCellValueFactory((Callback)new MapValueFactory((Object)"PaymentMethod"));
        this.colCustomerCode.setCellValueFactory((Callback)new MapValueFactory((Object)"customer_code"));
        this.colCustomerName.setCellValueFactory((Callback)new MapValueFactory((Object)"customerName"));
        this.colInvoiceNo.setCellValueFactory((Callback)new MapValueFactory((Object)"invoice_no"));
        this.colProduct.setCellValueFactory((Callback)new MapValueFactory((Object)"itemName"));
        this.colQuantity.setCellValueFactory((Callback)new MapValueFactory((Object)"quantity"));
        this.colDiscount.setCellValueFactory((Callback)new MapValueFactory((Object)"discount"));
        this.colDiscount.setCellFactory(numberFormatCellFactoryForMap);
        this.colDeclaredAmount.setCellValueFactory((Callback)new MapValueFactory((Object)"amount"));
        this.colOpeningStock.setCellValueFactory((Callback)new MapValueFactory((Object)"opening_stock"));
        this.colIssuedStock.setCellValueFactory((Callback)new MapValueFactory((Object)"issued_stock"));
        this.colConfirmedSales.setCellValueFactory((Callback)new MapValueFactory((Object)"confirmed_sales"));
        this.colSales.setCellValueFactory((Callback)new MapValueFactory((Object)"quantity"));
        this.colWarehouseReturn.setCellValueFactory((Callback)new MapValueFactory((Object)"warehouse_return"));
        this.colMissingBottles.setCellValueFactory((Callback)new MapValueFactory((Object)"missing_bottles"));
        this.colDeclaredAmount.setCellFactory(numberFormatCellFactoryForMap);
        this.colOpeningStock.setCellFactory(numberFormatCellFactoryForMap);
        Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>> confirmCellFactory = new Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>>(){

            public TableCell<HashMap, HashMap> call(TableColumn<HashMap, HashMap> param) {
                TableCell<HashMap, HashMap> cell = new TableCell<HashMap, HashMap>(){
                    private final Hyperlink btn = new Hyperlink("Edit");
                    {
                        this.btn.setOnAction(e -> {
                            HashMap data = (HashMap)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setVisited(false);
                            System.out.println(data);
                            int paymentMethod = 0;
                            String myPaymentMethod = "";
                            try {
                                paymentMethod = Integer.parseInt(data.get("payment_method").toString());
                                myPaymentMethod = data.get("PaymentMethod").toString();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (paymentMethod == 8) {
                                String quantity = data.get("quantity").toString();
                                String lineId = data.get("id").toString();
                                TextInputDialog alert = new TextInputDialog(quantity);
                                alert.setHeaderText(myPaymentMethod);
                                alert.setTitle("Edit Quantity");
                                alert.setContentText("Edit Quantity");
                                Optional result = alert.showAndWait();
                                result.ifPresent(confirmedAmount -> EndOfDayController.this.editConfirmedAmount((String)confirmedAmount, lineId, "quantity"));
                            } else if (paymentMethod == 8) {
                                String discount = data.get("discount").toString();
                                String lineId = data.get("id").toString();
                                TextInputDialog alert = new TextInputDialog(discount);
                                alert.setHeaderText(myPaymentMethod);
                                alert.setTitle("Edit Discount");
                                alert.setContentText("Edit Discount");
                                Optional result = alert.showAndWait();
                                result.ifPresent(confirmedAmount -> EndOfDayController.this.editConfirmedAmount((String)confirmedAmount, lineId, "discount"));
                            } else {
                                String requestedQuantity = data.get("confirmed_amount").toString();
                                String lineId = data.get("id").toString();
                                TextInputDialog alert = new TextInputDialog(requestedQuantity);
                                alert.setHeaderText(myPaymentMethod);
                                alert.setTitle("Edit Confirmed Amount");
                                alert.setContentText("Edit Confirmed Amount");
                                Optional result = alert.showAndWait();
                                result.ifPresent(confirmedAmount -> EndOfDayController.this.editConfirmedAmount((String)confirmedAmount, lineId, "confirmedAmount"));
                            }
                        });
                    }

                    public void updateItem(HashMap item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            Double requestedAmount = Double.parseDouble(item.get("confirmed_amount").toString());
                            this.btn.setText(Config.formatNumber(requestedAmount));
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colConfirmedAmount.setCellFactory((Callback)confirmCellFactory);
        this.colConfirmedAmount.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.cancel.setOnAction(e -> ((Stage)this.cancel.getScene().getWindow()).close());
        this.superUserCancel.setOnAction(e -> ((Stage)this.cancel.getScene().getWindow()).close());
        this.accountsApprove.setOnAction(e -> {
            this.accountsApprove.setDisable(true);
            if (Config.showConfirmDialog("Account Approval", "Are you sure you want to approve the record? \n Once approved this cannot be reversed", "The document has a variance of " + this.variance.getText())) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("docNo", this.docNo.getText().trim());
                    params.put("docType", this.getDocType());
                    String response = Config.loadDataFromPhp("masterpost?type=accountapprove", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        ((Stage)this.cancel.getScene().getWindow()).close();
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception u) {
                    u.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
                finally {
                    this.accountsApprove.setDisable(false);
                }
            } else {
                this.accountsApprove.setDisable(false);
            }
        });
        this.superUserApprove.setOnAction(e -> {
            this.superUserApprove.setDisable(true);
            if (Config.showConfirmDialog("Account Approval", "Are you sure you want to approve the record? \n Once approved this cannot be reversed", "Are you sure you want to approve the record")) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("docNo", this.docNo.getText().trim());
                    params.put("docType", this.getDocType());
                    String response = Config.loadDataFromPhp("masterpost?type=superuserapproval", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        ((Stage)this.cancel.getScene().getWindow()).close();
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception u) {
                    u.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
                finally {
                    this.superUserApprove.setDisable(false);
                }
            } else {
                this.superUserApprove.setDisable(false);
            }
        });
        this.approve.setOnAction(e -> {
            this.approve.setDisable(true);
            if (Config.showConfirmDialog("Account Approval", "Are you sure you want to approve the record? \n Once approved this cannot be reversed", "Are you sure you want to approve the record")) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("docNo", this.docNo.getText().trim());
                    params.put("docType", this.getDocType());
                    String response = Config.loadDataFromPhp("masterpost?type=salesheader", params, this.getUser());
                    System.out.println(response + " From Approval");
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        ((Stage)this.cancel.getScene().getWindow()).close();
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception u) {
                    u.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
                finally {
                    this.approve.setDisable(false);
                }
            } else {
                this.approve.setDisable(false);
            }
        });
        this.warehouseApproval.managedProperty().bind((ObservableValue)this.warehouseApproval.visibleProperty());
        this.superUserHBox.managedProperty().bind((ObservableValue)this.superUserHBox.visibleProperty());
        this.accountsUserHBox.managedProperty().bind((ObservableValue)this.accountsUserHBox.visibleProperty());
    }

    public void loadLines() {
        this.loadSales();
        this.loadPayments();
    }

    public void editClosingQuantity(String openingStock, String issuedQuantity, String closingQuantity, String itemType, String itemNo, String lineId) {
        this.notificationPane.setText("Editing Quantity. Please wait....");
        this.notificationPane.setGraphic((Node)new ProgressIndicator());
        this.notificationPane.show();
        try {
            double quantity = Double.parseDouble(openingStock) + Double.parseDouble(issuedQuantity) - Double.parseDouble(closingQuantity);
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("headerNo", this.docNo.getText().trim());
            params.put("documentType", this.getDocType());
            params.put("documentType", this.getDocType());
            params.put("itemType", itemType);
            params.put("itemNo", itemNo);
            params.put("closingStock", closingQuantity);
            params.put("quantity", quantity);
            params.put("lineId", lineId);
            String response = Config.loadDataFromPhp("masterupdate?type=salesline", params, this.getUser());
            Gson g = new Gson();
            JsonResponses js = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (js.isStatus()) {
                this.loadLines();
                this.notificationPane.setText(js.getMessage());
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.show();
            } else {
                this.notificationPane.setText(js.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
        catch (Exception u) {
            this.notificationPane.setText("We experienced an error while ediging the quantity. Please try again later. ");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void editEntry(HashMap details) {
        try {
            final Stage stage = new Stage();
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/closingstock.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            ClosingStockController controller = (ClosingStockController)loader.getController();
            controller.setUser(this.getUser());
            controller.setDetails(details);
            stage.setTitle("Edit Closing stock");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EndOfDayController.this.loadLines();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            this.notificationPane.setText("An error occurred while loading your edit closing stock screen. Please contact support");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void editConfirmedAmount(String confirmedAmount, String lineId, String field) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("lineId", lineId);
        params.put("amount", confirmedAmount);
        params.put("field", field);
        String response = Config.loadDataFromPhp("masterupdate?type=confirmpaymentamount", params, this.getUser());
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            this.loadPayments();
        } else {
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        }
    }

    public void loadPayments() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> EndOfDayController.this.paymentsMasker.setVisible(true));
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("docNo", EndOfDayController.this.docNo.getText().trim());
                    params.put("docType", EndOfDayController.this.getDocType());
                    String response2 = Config.loadDataFromPhp("masterfetch?type=detailedsalespayments", params, EndOfDayController.this.getUser());
                    System.out.println(response2);
                    ObservableList paymentLines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response2, HashMap[].class)));
                    Platform.runLater(() -> {
                        EndOfDayController.this.allPayments.setItems(paymentLines);
                        EndOfDayController.this.computeVariances();
                        EndOfDayController.this.paymentsMasker.setVisible(false);
                    });
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void loadSales() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> EndOfDayController.this.masker.setVisible(true));
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("docNo", EndOfDayController.this.docNo.getText().trim());
                    params.put("docType", EndOfDayController.this.getDocType());
                    String response = Config.loadDataFromPhp("masterfetch?type=salesline", params, EndOfDayController.this.getUser());
                    ObservableList allLines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, HashMap[].class)));
                    Platform.runLater(() -> {
                        EndOfDayController.this.allEntries.setItems(allLines);
                        EndOfDayController.this.computeVariances();
                        EndOfDayController.this.masker.setVisible(false);
                    });
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void computeVariances() {
        String selection;
        int a;
        ObservableList allLines = this.allEntries.getItems();
        ObservableList paymentLines = this.allPayments.getItems();
        double tTotalSales = 0.0;
        double tTotalPayments = 0.0;
        for (a = 0; a < allLines.size(); ++a) {
            selection = ((HashMap)allLines.get(a)).get("totalAmount").toString();
            try {
                tTotalSales += Double.parseDouble(selection);
                continue;
            }
            catch (Exception p) {
                p.printStackTrace();
            }
        }
        for (a = 0; a < paymentLines.size(); ++a) {
            selection = ((HashMap)paymentLines.get(a)).get("confirmed_amount").toString();
            try {
                tTotalPayments += Double.parseDouble(selection);
                continue;
            }
            catch (Exception p) {
                // empty catch block
            }
        }
        double finalTTotalSales = tTotalSales;
        double finalTTotalPayments = tTotalPayments;
        this.computedSales.setText(Config.formatNumber(finalTTotalSales));
        this.declaredPayments.setText(Config.formatNumber(finalTTotalPayments));
        this.variance.setText(Config.formatNumber(finalTTotalPayments - finalTTotalSales));
    }
}

