/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.NumberSeries;
import classes.User;
import classes.Vehicle;
import classes.VehicleBrands;
import classes.VehicleMakes;
import classes.VehicleModels;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class EditVehicleController
implements Initializable {
    private User user;
    String imagePath = "";
    @FXML
    private Button chooseMember;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private AnchorPane holder;
    @FXML
    private ImageView profilePhoto;
    @FXML
    private ComboBox<Member> vehicleOwner;
    @FXML
    private TextField vehicleAlias;
    @FXML
    private ComboBox<VehicleMakes> vehicleMake;
    @FXML
    private TextField vehicleRegNummber;
    @FXML
    private TextField fleetNumber;
    @FXML
    private ComboBox<VehicleModels> vehicleModel;
    @FXML
    private JFXButton addVehicle;
    @FXML
    private ComboBox<VehicleBrands> vehicleBrand;
    @FXML
    private CheckBox vehicleActive;
    @FXML
    private JFXButton reset;
    ObservableList<VehicleModels> allModels = FXCollections.observableArrayList();
    Vehicle vehicle;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(vehicle.getPhotoBlob());
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            Image image = new Image((InputStream)bis);
            this.profilePhoto.setImage(image);
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vehicleOwner.setValue((Object)vehicle.getOwner());
        this.vehicleAlias.setText(vehicle.getName());
        this.vehicleMake.setValue((Object)vehicle.getMake());
        this.vehicleRegNummber.setText(vehicle.getRegNo());
        this.fleetNumber.setText(vehicle.getFleetNumber());
        this.vehicleModel.setValue((Object)vehicle.getModel());
        try {
            this.vehicleBrand.setValue((Object)vehicle.getBrand());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vehicleActive.setSelected(vehicle.isActive());
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.chooseMember.setOnAction(e -> {
            try {
                Member member = new Member().getMemberFromSelection(this.getUser());
                String mNo = member.getMemberNumber();
                this.vehicleOwner.setValue((Object)member);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.vehicleRegNummber.setDisable(true);
        this.fleetNumber.setDisable(true);
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/vehicle.png";
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.getStyleClass().add((Object)"dark");
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
        MenuItem reset1 = new MenuItem("Reset to Default");
        String myPath = path;
        reset1.setOnAction(e -> {
            String fileLocation = myPath + "/vehicle.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset1});
        this.profilePhoto.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)EditVehicleController.this.profilePhoto, event.getScreenX(), event.getScreenY());
            }
        });
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.vehicleRegNummber, Validator.createEmptyValidator((String)"Vehicle Reg. No. is required"));
        validationSupport.registerValidator(this.vehicleMake, Validator.createEmptyValidator((String)"Vehicle Make is required"));
        validationSupport.registerValidator(this.vehicleModel, Validator.createEmptyValidator((String)"Vehicle Model is required"));
        validationSupport.registerValidator(this.vehicleOwner, Validator.createEmptyValidator((String)"Vehicle owner is required"));
        validationSupport.registerValidator(this.vehicleBrand, Validator.createEmptyValidator((String)"Vehicle Brand is required"));
        Platform.runLater(() -> {
            this.vehicleMake.setItems(new VehicleMakes().getAllMakes(this.getUser()));
            this.allModels = new VehicleModels().getAllModels(this.getUser());
            this.vehicleModel.setItems(this.allModels);
            ObservableList<Member> allMembers = new Member().getAllMembers(this.getUser());
            allMembers.sort(Comparator.comparing(Member::getFullName));
            this.vehicleOwner.setItems(allMembers);
            this.vehicleBrand.setItems(new VehicleBrands().getAllBrands(this.getUser()));
        });
        this.vehicleMake.setOnAction(e -> {
            ObservableList selectedModels = FXCollections.observableArrayList();
            for (VehicleModels model : this.allModels) {
                try {
                    if (model.getMake().getCode() != ((VehicleMakes)this.vehicleMake.getValue()).getCode()) continue;
                    selectedModels.add((Object)model);
                }
                catch (Exception exception) {}
            }
            this.vehicleModel.setItems(selectedModels);
        });
        this.addVehicle.setOnAction(e -> {
            int tActive;
            String vAlias = this.vehicleAlias.getText().trim();
            String tregNo = this.vehicleRegNummber.getText().trim();
            String tregno = tregNo.replace(" ", "");
            String message = "";
            Boolean error = false;
            if ((tregNo = tregNo.replace(" ", "")).length() != 7) {
                error = true;
                message = message + "\n Please provide a valid car registration number";
            }
            if (!tregNo.toUpperCase().matches("K[A-Z][A-Z]\\d\\d\\d[A-Z]")) {
                error = true;
                message = message + "\n Please provide a valid car registration number";
            }
            int makeCode = 0;
            int brandCode = 0;
            try {
                makeCode = ((VehicleMakes)this.vehicleMake.getValue()).getCode();
            }
            catch (Exception ui) {
                error = true;
                message = message + "\n Please select a make for the car";
            }
            int modelCode = 0;
            try {
                modelCode = ((VehicleModels)this.vehicleModel.getValue()).getCode();
            }
            catch (Exception ui) {
                error = true;
                message = message + "\n Please select a model for the car";
            }
            String ownerCode = "";
            try {
                ownerCode = ((Member)this.vehicleOwner.getValue()).getMemberNumber();
            }
            catch (Exception ui) {
                error = true;
                message = message + "\n Please select the owner of the car";
            }
            try {
                brandCode = ((VehicleBrands)this.vehicleBrand.getValue()).getBrandId();
            }
            catch (Exception ui) {
                error = true;
                message = message + "\n Please select the brand of the car";
            }
            int n = tActive = this.vehicleActive.isSelected() ? 1 : 0;
            if (!error.booleanValue()) {
                try {
                    NumberSeries ns = new NumberSeries(2, this.getUser());
                    String tFleetno = ns.getNextNumber();
                    ProgressIndicator indicate = new ProgressIndicator();
                    indicate.setStyle(" -fx-progress-color: #ffffff;");
                    this.notificationPane.setGraphic((Node)indicate);
                    this.notificationPane.setText("Adding vehicle. Please wait...");
                    this.notificationPane.show();
                    ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
                    String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("fleetNumber", tFleetno);
                    params.put("regNo", tregNo);
                    params.put("makeCode", makeCode);
                    params.put("modelCode", modelCode);
                    params.put("vAlias", vAlias);
                    params.put("ownerCode", ownerCode);
                    params.put("brandCode", brandCode);
                    params.put("active", tActive);
                    params.put("photo", photoJson);
                    StringBuilder postData = new StringBuilder();
                    Gson g = new Gson();
                    String response2 = Config.loadDataFromPhp("masterupdate?type=vehicle", params, this.getUser());
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    if (myResponse.isStatus()) {
                        this.notificationPane.setText(myResponse.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                        ns.updateLastUsed(tFleetno);
                    } else {
                        this.notificationPane.setText(myResponse.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    }
                    this.addVehicle.setDisable(false);
                }
                catch (Exception t) {
                    t.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                    icon.setStyle("-fx-fill: #d32f2f;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                    this.addVehicle.setDisable(false);
                }
            } else {
                this.notificationPane.setText(message);
                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                icon.setStyle("-fx-fill: #d32f2f;");
                icon.setSize("24.0");
                this.notificationPane.setGraphic((Node)icon);
                this.notificationPane.show();
            }
        });
        this.vehicleOwner.setOnAction(e -> {
            block5: {
                try {
                    Member member = (Member)this.vehicleOwner.getValue();
                    if (!member.getMemberNumber().equals("choose")) break block5;
                    Member m = new Member().getMemberFromSelection(this.getUser());
                    String memberNumber = m.getMemberNumber();
                    for (Member b : this.vehicleOwner.getItems()) {
                        if (!b.getMemberNumber().equals(memberNumber)) continue;
                        this.vehicleOwner.setValue((Object)b);
                        break;
                    }
                }
                catch (ClassCastException classCastException) {
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            this.profilePhoto.setImage(image);
            this.imagePath = file.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

